<?php
$news_post = wp_kses_post($instance['news_post']);
$numberPosts = (!empty($instance['number_of_posts']))? $instance['number_of_posts'] : 4 ;
$link_text = wp_kses_post($instance['link_text']);
$link_url = wp_kses_post($instance['link_url']);
$link_text = ($link_text=='')?esc_attr__('News and updates', 'solicitor'):$link_text;
$data_style = wp_kses_post($instance['listing_layout']['data_style']);
$slider_speed = wp_kses_post($instance['listing_layout']['slider_speed']);
?>
<?php if($news_post != ''){ ?>
<div class="notice-bar">
    	<div class="container">
        	<div class="row">
            	<div class="col-md-8 col-sm-12 equalize">
     <div class="galleryflex flexslider" data-autoplay="yes" data-arrows="no" data-speed="<?php echo esc_attr($slider_speed); ?>"  data-style="<?php echo esc_attr($data_style); ?>"  data-direction="vertical">
                        <ul class="slides">
                        <?php $start = 1;
							foreach($news_post as $id) { ?>
                            <li class="slide">
                				<span class="icon-block"><i class="fa fa-newspaper-o"></i></span>
                                <p><a href="<?php echo esc_url(get_permalink($id)); ?>"><?php echo esc_attr(get_the_title($id)); ?></a></p>
                            	<span class="meta-data"><?php echo esc_attr(get_the_date(get_option('date_format'), $id)); ?></span>
                          	</li>
                        <?php 
							$start++;
							if($start>$numberPosts)
							{
								break;
							}
						} ?>
                        </ul>
                    </div>
                    
                </div>
                <?php if($link_url!='') { ?>
                <div class="col-md-4 col-sm-4 hidden-sm hidden-xs equalize">
                	<a href="<?php echo sow_esc_url($instance['link_url']); ?>" <?php if($instance['link_new_window']) echo 'target="_blank"' ?> class="btn btn-primary btn-block equalize"><span><?php echo esc_attr($link_text); ?></span><em><?php esc_html_e('See all', 'solicitor'); ?></em></a>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>