<?php

/*
Widget Name: imithemes - Solicitor News Ticker Widget
Description: A widget to show selected blog posts/events in a vertical slider view.
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_News_Ticker_Widget extends SiteOrigin_Widget {
	function __construct() {
		$arr = array();
		$arg = array('post_type'=>array('event', 'post'), 'posts_per_page'=>-1);
		$news_list = new WP_Query($arg);
		if($news_list->have_posts()):while($news_list->have_posts()):$news_list->the_post();
		$arr[get_the_ID()] = get_the_title();
		endwhile; endif; wp_reset_postdata();
		parent::__construct(
			'solicitor_news_ticker_widget',
			esc_html__('imithemes - News Ticker Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to show selected blog posts/events in a vertical slider view.', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
				'news_post' => array(
					'type' => 'select',
					'label' => esc_html__( 'Choose posts/events to display as news', 'solicitor' ),
					'multiple' => true,
					'default' => '',
					'options' => $arr
				),
				'number_of_posts' => array(
					'type' => 'slider',
					'label' => esc_html__( 'Number of news to show', 'solicitor' ),
					'default' => 4,
					'min' => 1,
					'max' => 50,
					'integer' => true,
				),
				'link_text' => array(
					'type' => 'text',
					'label' => esc_html__('All News button label', 'solicitor'),
					'default' => 'News and updates'
				),
				'link_url' => array(
					'type' => 'link',
					'label' => esc_html__('All News button URL', 'solicitor'),
				),
				'link_new_window' => array(
					'type' => 'checkbox',
					'default' => false,
					'label' => esc_html__('Open in new window', 'solicitor'),
				),
				'listing_layout' => array(
					'type' => 'section',
					'label' => esc_html__( 'Slider settings', 'solicitor' ),
					'hide' => false,
					'fields' => array(
						'data_style' => array(
						'type' => 'select',
						'label' => esc_html__( 'Choose slide effect', 'solicitor' ),
						'options' => array(
								'fade' => 'Fade',
								'slide' => 'Slide',
				)),
				'slider_speed' => array(
					'type' => 'text',
					'label' => esc_html__('Slider Speed(1 sec is equal to 1000)', 'solicitor'),
					'description' => esc_html__( 'Time for which a slide is shown. Default is 5 seconds = 5000', 'solicitor' ),
				),
             )
		),
	),
	plugin_dir_path(__FILE__)
);
}
	
	function get_template_name( $instance ) {
		return 'template';
	}

	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('solicitor_news_ticker_widget', __FILE__, 'Solicitor_News_ticker_Widget');