<?php
$widget_title = wp_kses_post($instance['widget_title']);
$services_desc = (!empty($instance['excerpt_length']))? $instance['excerpt_length'] : 25 ;
$services_per_page = wp_kses_post($instance['services_per_page']);
$the_categories = (isset($instance['categories']))?wp_kses_post($instance['categories']):'';
$paged = (get_query_var('paged'))?get_query_var('paged'):1;
$content_type = wp_kses_post($instance['content_type']);
?>

<div class="accordion accordion-services" id="toggleArea">
<?php 
if($the_categories=='')
{
	$services_args = array ( 'post_type' => 'service', 'posts_per_page' => $services_per_page, 'paged' => $paged );
}
else
{
	$the_categories = explode(',', $the_categories);
	$services_args = array ( 'post_type' => 'service', 'tax_query' => array(array('taxonomy' => 'service-category', 'field' => 'slug', 'terms' => $the_categories, 'operator' => 'IN')),$the_categories, 'posts_per_page' => $services_per_page, 'paged' => $paged );
}
$services_listings = new WP_Query($services_args);
$counter = 1;
if($services_listings->have_posts()):while($services_listings->have_posts()):$services_listings->the_post();
$in_class = ($counter==1)?'in':'';
$active_class = ($counter==1)?'active':'';
$current_post_id = get_the_id();
	
// Widget Title
if($widget_title != ''){
	echo '<h3 class="widgettitle">'.esc_attr($widget_title).'</h3>';
}
?>
<div class="accordion-group panel">
	<div class="accordion-heading accordionize">
		<a class="accordion-toggle <?php echo esc_attr($active_class); ?>" data-toggle="collapse" data-parent="#toggleArea" href="#collapse<?php echo esc_attr($current_post_id); ?>">
			<?php the_title(); ?>
			<i class="fa fa-plus-circle"></i><i class="fa fa-minus-circle"></i>
		</a>
	</div>
	<div id="collapse<?php echo $current_post_id ?>" class="accordion-body collapse <?php echo esc_attr($in_class); ?>">
		<div class="accordion-inner">
		<?php if($content_type==1) {
			 echo solicitor_excerpt(50); 
			}
			else {
			 the_content(''); }
		?>
		</div>
	</div>
</div>
<?php
$counter++;
endwhile; endif; wp_reset_postdata(); 
?>
</div>

