<?php
$widget_title = wp_kses_post($instance['widget_title']);
$grid_column = (!empty($instance['listing_layout']['grid_column']))? $instance['listing_layout']['grid_column'] : 4 ;
$services_per_page = wp_kses_post($instance['services_per_page']);
$the_categories = (isset($instance['categories']))?wp_kses_post($instance['categories']):'';
$paged = (get_query_var('paged'))?get_query_var('paged'):1;
$content_type = wp_kses_post($instance['content_type']);

// Widget Title
if($widget_title != ''){
	echo '<h3 class="widgettitle">'.esc_attr($widget_title).'</h3>';
}
?>
<div class="row">
	<ul class="isotope-grid">
<?php 
if($the_categories=='')
{
	$services_args = array ( 'post_type' => 'service', 'posts_per_page' => $services_per_page, 'paged' => $paged );
}
else
{
	$the_categories = explode(',', $the_categories);
	$services_args = array ( 'post_type' => 'service', 'tax_query' => array(array('taxonomy' => 'service-category', 'field' => 'slug', 'terms' => $the_categories, 'operator' => 'IN')),$the_categories, 'posts_per_page' => $services_per_page, 'paged' => $paged );
}
$services_listings = new WP_Query($services_args);
if($services_listings->have_posts()):while($services_listings->have_posts()):$services_listings->the_post();
?>
<li class="blog-grid-item grid-item blog-item col-md-<?php echo esc_attr($grid_column); ?> col-sm-6 format-standard">
<?php if(has_post_thumbnail()) { ?>
	<a href="<?php the_permalink(); ?>" class="media-box"><?php the_post_thumbnail('solicitor-600x400'); ?></a>
<?php } ?>
	<div class="grid-item-inner">
    	<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
		<?php if($content_type==1) {
			 echo solicitor_excerpt(50); 
			}
			else {
			 the_content(); 
			}
		?>
   	</div>
</li>
<?php
endwhile; 
echo '</ul></div>';
if(!empty($instance['show_pagination']))
{
	$GLOBALS['wp_query'] = $services_listings;
	echo solicitor_pagination();
}
endif; wp_reset_query();
?>