<?php

/*
Widget Name: imithemes - Services Widget
Description: A widget to show Services in list/grid/carousel layout
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Services_Widget extends SiteOrigin_Widget {
	function __construct() {

		parent::__construct(
			'services-widget',
			esc_html__('imithemes - Services Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to show Services in list/grid/carousel layout', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-archive',
				'panels_groups' => array('framework')
			),
			array(

			),
			
			array(
				'widget_title' => array(
					'label' => esc_html__( 'Widget Title', 'solicitor' ),
					'type' => 'text',
				),
				'content_type' => array(
					'type' => 'select',
					'label' => esc_html__('Show Venue description excerpt/content.', 'solicitor'),
					'options' => array(
						'1' => esc_html__( 'Excerpt', 'solicitor' ),
						'2' => esc_html__( 'Content', 'solicitor' ),
							),
				),
				'categories' => array(
					'type' => 'text',
					'label' => esc_html__('Categories (Enter comma separated sermon category slugs)', 'solicitor'),
				),
				'services_per_page' => array(
					'type' => 'slider',
					'label' => esc_html__( 'Number of services to show', 'solicitor' ),
					'default' => 4,
					'min' => 1,
					'max' => 50,
					'integer' => true,
				),
				'show_pagination' => array(
					'type' => 'checkbox',
					'default' => false,
					'label' => esc_html__('Enable pagination', 'solicitor'),
					'state_handler' => array(
						'layout_type[grid]' => array('show'),
						'layout_type[toggle]' => array('hide'),
					),
				),
				'listing_layout' => array(
					'type' => 'section',
					'label' => esc_html__( 'Layout', 'solicitor' ),
					'hide' => false,
					'description' => esc_html__( 'Choose listing layout.', 'solicitor' ),
					'fields' => array(
						'layout_type'    => array(
							'type'    => 'radio',
							'default' => 'grid',
							'label'   => esc_html__( 'Layout Type', 'solicitor' ),
							'options' => array(
								'toggle' => esc_html__( 'Toggle View', 'solicitor' ),
								'grid'      => esc_html__( 'Grid View', 'solicitor' ),
							),
							'state_emitter' => array(
								'callback' => 'select',
								'args' => array( 'layout_type' )
							),
						),
						'grid_column' => array(
							'type' => 'select',
							'state_name' => 'grid',
							'label' => esc_html__( 'Choose Grid View Column', 'solicitor' ),
							'options' => array(
								'12' => esc_html__( 'One', 'solicitor' ),
								'6' => esc_html__( 'Two', 'solicitor' ),
								'4' => esc_html__( 'Three', 'solicitor' ),
								'3' => esc_html__( 'Four', 'solicitor' ),
							),
							'state_handler' => array(
								'layout_type[grid]' => array('show'),
								'layout_type[toggle]' => array('hide'),
							),
						),
					),
				),
			),
			plugin_dir_path(__FILE__)
		);
	}
	function get_template_variables( $instance, $args ) {
		$layout = $instance['listing_layout'];
		return array(
				'layout_type' => array(
					'column'  => (!empty($layout['grid_column']))? $layout['grid_column'] : 4
				)
			);
	}
	function get_template_name( $instance ) {
		return $instance['listing_layout']['layout_type'] == 'toggle' ? 'toggle-view' : 'grid-view';
	}

	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}


siteorigin_widget_register('services-widget', __FILE__, 'Solicitor_Services_Widget');