<?php

/*
Widget Name: imithemes - Progress Bar Widget
Description: A widget to add Progress bar to your pages.
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Progressbar_Widget extends SiteOrigin_Widget {
	function __construct() {

		parent::__construct(
			'progressbar-widget',
			esc_html__('imithemes - Progress Bar Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to add Progress bar to your pages.', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
				'title' => array(
					'type' => 'text',
					'label' => esc_html__('Title', 'solicitor'),
					'description' => esc_html__('Title to show above the progress bar.', 'solicitor'),
					
				),
				'percentile' => array(
					'type' => 'text',
					'label' => esc_html__('Progress Percentile', 'solicitor'),
					'description' => esc_html__('Enter the progress percentile without %. For ex: 90', 'solicitor'),
					
				),
				
				'type' => array(
					'type' => 'select',
					'state_name' => 'primary',
					'label' => esc_html__( 'Choose Color Style', 'solicitor' ),
					'prompt' => esc_html__( 'Choose Color Style', 'solicitor' ),
					'options' => array(
						'primary' => esc_html__( 'Primary', 'solicitor' ),
						'warning' => esc_html__( 'Warning', 'solicitor' ),
						'info' => esc_html__( 'Info', 'solicitor' ),
						'danger' => esc_html__( 'Danger', 'solicitor' ),
						'success' => esc_html__( 'Success', 'solicitor' ),
					)
				),
				'custom_color' => array(
					'type' => 'color',
					'label' => esc_html__('Custom progress bar color', 'solicitor'),
					'default' => '',
				),
				'stripped' => array(
					'type' => 'checkbox',
					'label' => esc_html__('Use stripped background animation', 'solicitor'),
					'default' => false,
				),
				'tootltip' => array(
					'type' => 'checkbox',
					'label' => esc_html__('Show progress percentile tooltip', 'solicitor'),
					'default' => false,
				),
				'animation' => array(
					'type' => 'text',
					'default' => 200,
					'label' => esc_html__('Delay animation', 'solicitor'),
					'description' => esc_html__('Enter the delay animation time. 100 means 1 sec. Leave blank for no animation', 'solicitor'),
					
				),
			),
			plugin_dir_path(__FILE__)
		);
	}
	
	
	function get_template_name( $instance ) {
		return 'template';
	}


	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('progressbar-widget', __FILE__, 'Solicitor_Progressbar_Widget');