<?php
$widget_title = wp_kses_post($instance['widget_title']);
$the_categories = wp_kses_post($instance['categories']);
$numberPosts = (!empty($instance['number_of_posts']))? $instance['number_of_posts'] : 4 ;
$read_more_text = wp_kses_post($instance['read_more_text']);
$show_post_meta = wp_kses_post($instance['show_post_meta']);
$paged = (get_query_var('paged'))?get_query_var('paged'):1;
$posts_desc =wp_kses_post($instance['excerpt_length']);
?>
<?php 
if($the_categories=='')
{
	$post_args = array ( 'post_type' => 'post', 'posts_per_page' => $numberPosts, 'paged' => $paged );
}
else
{
	$the_categories = explode(',', $the_categories);
	$post_args = array ( 'post_type' => 'post', 'tax_query' => array(array('taxonomy' => 'category', 'field' => 'slug', 'terms' => $the_categories, 'operator' => 'IN')),$the_categories, 'posts_per_page' => $numberPosts, 'paged' => get_query_var('paged') );
}
$post_listings = new WP_Query($post_args);
if($post_listings->have_posts()) :  ?>
<div class="row">
 <ul class="isotope-grid">
<?php while($post_listings->have_posts()) : $post_listings->the_post();
   
// Widget Title
if($widget_title != ''){
	echo '<h3 class="widgettitle">'.esc_attr($widget_title).'</h3>';
}
?>
	<li id="post-<?php the_ID(); ?>" <?php post_class('blog-grid-item grid-item blog-item col-md-'.$layout_type["column"].' col-sm-6 format-standard'); ?>>
		<?php if(has_post_thumbnail()) { ?>
		<a href="<?php the_permalink(); ?>" class="media-box"><?php the_post_thumbnail('600x400'); ?></a>
		<?php } ?>
		<div class="grid-item-inner">
			<div class="post-item-meta">
		   <div class="pull-right"><a href="#"><i class="fa fa-comments-o"></i> <?php comments_number('0', '1', '%'); ?></a></div>
				<i class="fa fa-clock-o"></i> <?php echo get_the_date(get_option('date_format'), get_the_ID()); ?>
			</div>
			<div class="meta-data"><?php if($show_post_meta==1) { ?><?php the_category(', '); ?><?php } ?></div>
		<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
		<?php the_excerpt(); ?>
		<?php if($read_more_text != ''){?><a href="<?php the_permalink(); ?>" class="btn btn-default btn-ghost btn-dark btn-sm"><?php echo esc_attr($read_more_text); ?></a><?php } ?>
	</div>
	</li>
   	<?php endwhile; ?>
</ul>
</div>
<div class="pagination">
<?php if(!empty($instance['show_pagination'])){ 
	$GLOBALS['wp_query'] = $post_listings;
	echo solicitor_pagination(); 
} ?>
</div>
<?php endif; wp_reset_query(); ?>