<?php

/*
Widget Name: imithemes - Posts List/Grid Widget
Description: A widget to show posts list/grid view.
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Posts_List_Widget extends SiteOrigin_Widget {
	function __construct() {

		parent::__construct(
			'posts-list-widget',
			esc_html__('imithemes - Posts List/Grid Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to show posts list/grid view.', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
				'widget_title' => array(
					'label' => esc_html__( 'Widget Title', 'solicitor' ),
					'type' => 'text',
				),
				'categories' => array(
					'type' => 'text',
					'label' => esc_html__('Categories (Enter comma separated post category slugs)', 'solicitor'),
				),
				'number_of_posts' => array(
					'type' => 'slider',
					'label' => esc_html__( 'Number of Posts to show per page', 'solicitor' ),
					'default' => 4,
					'min' => 1,
					'max' => 50,
					'integer' => true,
				),
				'show_pagination' => array(
					'type' => 'checkbox',
					'default' => false,
					'label' => esc_html__('Show pagination', 'solicitor'),
				),
				'show_post_meta' => array(
					'type' => 'checkbox',
					'default' => true,
					'label' => esc_html__('Show post meta like post date, author, categories, comments?', 'solicitor'),
				),
				'excerpt_length' => array(
					'type' => 'checkbox',
					'default' => true,
					'label' => esc_html__('Show post excerpt. It shows post content till the more tag.', 'solicitor'),
				),
				'read_more_text' => array(
					'type' => 'text',
					'default' => 'Read more',
					'label' => esc_html__('Full details button text, Leave blank to hide button - Default is Read More', 'solicitor'),
				),
				'listing_layout' => array(
					'type' => 'section',
					'label' => esc_html__( 'Layout', 'solicitor' ),
					'hide' => false,
					'description' => esc_html__( 'Choose listing layout.', 'solicitor' ),
					'fields' => array(
						'layout_type'    => array(
							'type'    => 'radio',
							'default' => 'list',
							'label'   => esc_html__( 'Layout Type', 'solicitor' ),
							'options' => array(
								'list' => esc_html__( 'List View', 'solicitor' ),
								'grid'      => esc_html__( 'Grid View', 'solicitor' ),
							),
							'state_emitter' => array(
								'callback' => 'select',
								'args' => array( 'layout_type' )
							),
						),
						'grid_column' => array(
							'type' => 'select',
							'state_name' => 'grid',
							'prompt' => esc_html__( 'Choose Grid View Column', 'solicitor' ),
							'options' => array(
								'6' => esc_html__( 'Two', 'solicitor' ),
								'4' => esc_html__( 'Three', 'solicitor' ),
								'3' => esc_html__( 'Four', 'solicitor' ),
							),
							'state_handler' => array(
								'layout_type[grid]' => array('show'),
								'layout_type[list]' => array('hide'),
							),
						),
					),
				)
			),
			plugin_dir_path(__FILE__)
		);
	}


	
	function get_template_variables( $instance, $args ) {
		$layout = $instance['listing_layout'];
		return array(
				'layout_type' => array(
					'column'  => (!empty($layout['grid_column']))? $layout['grid_column'] : 4
				)
			);
	}
	
	function get_template_name( $instance ) {
		return $instance['listing_layout']['layout_type'] == 'list' ? 'list-view' : 'grid-view';
	}

	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('posts-list-widget', __FILE__, 'Solicitor_Posts_List_Widget');