<?php
global $allowed_tags;
foreach( $instance['blocks'] as $i => $block ) : 
	$block_title = wp_kses_post($block['block_title']);
	$block_content = wp_kses_post($block['block_content']);
	$job_button_text = wp_kses_post($block['job_button_text']);
	$job_button_url = wp_kses_post($block['job_button_url']);
	$categories = wp_kses_post($block['categories']);
	?>

	<div class="job-block">
		<?php if($job_button_url!='') { ?>
			<a href="<?php echo esc_url($job_button_url); ?>" class="btn btn-default btn-dark btn-ghost pull-right btn-sm"><?php echo esc_attr($job_button_text); ?></a>
		<?php } ?>
		<div class="meta-data accent-color"><?php echo esc_attr($categories); ?></div>
		<h4><?php echo esc_attr($block_title); ?></h4>
		<?php echo wp_kses($block_content, $allowed_tags); ?>
		<?php if($job_button_url!='') { ?>
			<ul class="social-icons social-icons-colored social-icons-inverted">
				<li class="meta-data"><?php esc_html_e('SHARE JOB', 'solicitor'); ?></li>
				<li class="facebook"><a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url($job_button_url); ?>&amp;t= <?php echo esc_attr($block_title); ?>"><i class="fa fa-facebook-f"></i></a></li>
				<li class="twitter"><a href="https://twitter.com/intent/tweet?source=<?php echo esc_url($job_button_url); ?>&amp;text=<?php echo esc_attr($block_title); ?>"><i class="fa fa-twitter"></i></a></li>
				<li class="linkedin"><a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo esc_url($job_button_url); ?>&amp;title=<?php echo esc_attr($block_title); ?>"><i class="fa fa-linkedin"></i></a></li>
				<li class="pinterest"><a href="http://pinterest.com/pin/create/button/?url=<?php echo esc_url($job_button_url); ?>&amp;description=<?php echo esc_attr($block_title); ?>"><i class="fa fa-pinterest"></i></a></li>
			</ul>
		<?php } ?>
	</div>
<?php endforeach; ?>