<?php

/*
Widget Name: imithemes - Job Text Widget
Description: A widget to show job block
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Job_Widget extends SiteOrigin_Widget {
	function __construct() {

		parent::__construct(
		   	  'job-widget',
			  esc_html__('imithemes - Job Text Widget', 'solicitor'),
			  array(
				   'description' => esc_html__('A widget to show job block', 'solicitor'),
				   'panels_icon' => 'dashicons dashicons-list-view',
				   'panels_groups' => array('framework')
			        ),
			  array(

			        ),
			  array(
			            'blocks' => array(
					        'type' => 'repeater',
					        'label' => esc_html__('Add Blocks', 'solicitor'),
					        'item_name' => esc_html__('Block', 'solicitor'),
					        'item_label' => array(
						       'selector' => "[id*='schedule_blocks_icon']",
						       'update_event' => 'change',
						       'value_method' => 'val'
				            ),
					    'fields' => array(
				            'categories' => array(
				     	    'type' => 'text',
					        'label' => esc_html__('Job Categories', 'solicitor'),
				            ),
				            'block_title' => array(
				            'type' => 'text',
					        'default' => '',
					        'label' => esc_html__('Enter Job Position', 'solicitor'),
				            ),	
			                'block_content' => array(
				            'type' => 'tinymce',
				            'label' => esc_html__('Job Description', 'solicitor'),
				            'description' => __('Enter block content', 'solicitor'),
			                ),
				            'job_button_text' => array(
					        'type' => 'text',
					        'default' => esc_html__('Apply for this position', 'solicitor'),
					        'label' => esc_html__('Label for apply button', 'solicitor'),
			    	        ),
				            'job_button_url' => array(
					        'type' => 'text',
					        'default' => '',
					        'label' => esc_html__('Enter URL for apply button', 'solicitor'),
				      	),
						
					),
				)
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name( $instance ) {
		return 'template';
	}

	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('job-widget', __FILE__, 'Solicitor_Job_Widget');