<?php

/*
Widget Name: imithemes - Icon Box Widget
Description: A widget for multiple type Icon Box Styles
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Iconbox_Widget extends SiteOrigin_Widget {
	function __construct() {

		parent::__construct(
			'iconbox-widget',
			esc_html__('imithemes - Icon Box Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget for multiple type Icon Box Styles', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
				'icon' => array(
					'type' => 'icon',
					'label' => esc_html__('Icon', 'solicitor'),
				),
				'icon_image' => array(
					'type' => 'media',
					'library' => 'image',
					'label' => esc_html__('Icon image', 'solicitor'),
					'description' => esc_html__('Use your own icon image.', 'solicitor'),
				),
				'custom_tcolor' => array(
					'type' => 'color',
					'label' => esc_html__('Custom icon color', 'solicitor'),
					'default' => '',
				),
				'title' => array(
					'type' => 'text',
					'label' => esc_html__('Icon Box Title', 'solicitor'),
					'description' => esc_html__('Enter Icon Box Title', 'solicitor'),
					
				),
				'custom_titlecolor' => array(
					'type' => 'color',
					'label' => esc_html__('Custom title color', 'solicitor'),
					'default' => '',
				),
				'content' => array(
					'type' => 'textarea',
					'label' => esc_html__('Icon Box Content', 'solicitor'),
					'description' => esc_html__('Enter Icon Box Content', 'solicitor'),
					
				),
				'custom_textcolor' => array(
					'type' => 'color',
					'label' => esc_html__('Custom content text color', 'solicitor'),
					'default' => '',
				),
				'link' => array(
					'type' => 'link',
					'label' => esc_html__('Icon Box Destination URL', 'solicitor'),
				),
				'link_new_window' => array(
					'type' => 'checkbox',
					'default' => false,
					'label' => esc_html__('Open in new window', 'solicitor'),
				),
				'align' => array(
					'type' => 'select',
					'state_name' => 'standard',
					'label' => esc_html__( 'Icon Box Align', 'solicitor' ),
					'prompt' => esc_html__( 'Choose Alignment', 'solicitor' ),
					'options' => array(
						'standard' => esc_html__( 'Default(Left)', 'solicitor' ),
						'ibox-center' => esc_html__( 'Centered', 'solicitor' ),
					)
				),
				'type' => array(
					'type' => 'select',
					'state_name' => 'default',
					'label' => esc_html__( 'Icon Box Type', 'solicitor' ),
					'prompt' => esc_html__( 'Choose Type', 'solicitor' ),
					'options' => array(
						'default' => esc_html__( 'Default', 'solicitor' ),
						'ibox-outline' => esc_html__( 'Outline', 'solicitor' ),
						'ibox-border' => esc_html__( 'Thin Border', 'solicitor' ),
						'ibox-plain' => esc_html__( 'Plain', 'solicitor' ),
					)
				),
				'style' => array(
					'type' => 'select',
					'state_name' => 'standard',
					'label' => esc_html__( 'Icon Box Theme', 'solicitor' ),
					'prompt' => esc_html__( 'Choose Theme', 'solicitor' ),
					'options' => array(
						'standard' => esc_html__( 'Default', 'solicitor' ),
						'ibox-light' => esc_html__( 'Light', 'solicitor' ),
						'ibox-dark' => esc_html__( 'Dark', 'solicitor' ),
					)
				),
				'circle' => array(
					'type' => 'select',
					'state_name' => 'standard',
					'label' => esc_html__( 'Icon Box Style', 'solicitor' ),
					'prompt' => esc_html__( 'Choose Style', 'solicitor' ),
					'options' => array(
						'standard' => esc_html__( 'Default(Circle)', 'solicitor' ),
						'ibox-rounded' => esc_html__( 'Rounded', 'solicitor' ),
					)
				),
				'custom_color' => array(
					'type' => 'color',
					'label' => esc_html__('Custom background & border color', 'solicitor'),
					'default' => '',
				),
				'animation' => array(
					'type' => 'select',
					'state_name' => 'fadeIn',
					'label' => esc_html__( 'Choose animation', 'solicitor' ),
					'prompt' => esc_html__( 'Choose animation', 'solicitor' ),
					'options' => array(
						'flash' => esc_html__( 'Flash', 'solicitor' ),
						'shake' => esc_html__( 'Shake', 'solicitor' ),
						'bounce' => esc_html__( 'Bounce', 'solicitor' ),
						'tada' => esc_html__( 'Tada', 'solicitor' ),
						'swing' => esc_html__( 'Swing', 'solicitor' ),
						'wobble' => esc_html__( 'Wobble', 'solicitor' ),
						'wiggle' => esc_html__( 'Wiggle', 'solicitor' ),
						'pulse' => esc_html__( 'Pulse', 'solicitor' ),
						'fadeIn' => esc_html__( 'FadeIn', 'solicitor' ),
						'fadeInUp' => esc_html__( 'FadeInUp', 'solicitor' ),
						'fadeInLeft' => esc_html__( 'FadeInLeft', 'solicitor' ),
						'fadeInRight' => esc_html__( 'FadeInRight', 'solicitor' ),
						'fadeInUpBig' => esc_html__( 'FadeInUpBig', 'solicitor' ),
						'fadeInDownBig' => esc_html__( 'FadeInDownBig', 'solicitor' ),
						'fadeInLeftBig' => esc_html__( 'FadeInDownBig', 'solicitor' ),
						'fadeInRightBig' => esc_html__( 'FadeInRightBig', 'solicitor' ),
						'bounceIn' => esc_html__( 'BounceIn', 'solicitor' ),
						'bounceInUp' => esc_html__( 'BounceInUp', 'solicitor' ),
						'bounceInDown' => esc_html__( 'BounceInDown', 'solicitor' ),
						'bounceInLeft' => esc_html__( 'BounceInLeft', 'solicitor' ),
						'bounceInRight' => esc_html__( 'BounceInRight', 'solicitor' ),
						'rotateIn' => esc_html__( 'RotateIn', 'solicitor' ),
						'rotateInUpLeft' => esc_html__( 'RotateInUpLeft', 'solicitor' ),
						'rotateInDownLeft' => esc_html__( 'RotateInDownLeft', 'solicitor' ),
						'rotateInUpRight' => esc_html__( 'RotateInUpRight', 'solicitor' ),
						'rotateInDownRight' => esc_html__( 'RotateInDownRight', 'solicitor' ),
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}
	
	
	function get_template_name( $instance ) {
		return 'template';
	}


	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('iconbox-widget', __FILE__, 'Solicitor_Iconbox_Widget');