<?php

/*
Widget Name: imithemes - Featured Block Widget
Description: A widget to show featured block.
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Featured_Blocks extends SiteOrigin_Widget {
	function __construct() {

		parent::__construct(
			'featured-blocks-widget',
			esc_html__('imithemes - Featured Block Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to show featured blocks.', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(	
				'featured_blocks_title' => array(
					'type' => 'text',
					'default' => '',
					'label' => esc_html__('Enter title for block', 'solicitor'),
				),	
				'featured_icon_image' => array(
					'type' => 'media',
					'library' => 'image',
					'fallback' => false,
					'label' => esc_html__('Upload image', 'solicitor'),
				),
				'featured_blocks_button_text' => array(
					'type' => 'text',
					'default' => '',
					'label' => esc_html__('Enter button label', 'solicitor'),
				),
				'featured_blocks_button_url' => array(
					'type' => 'link',
					'label' => esc_html__('Enter URL for button', 'solicitor'),
				),
				'featured_blocks_message' => array(
					'type' => 'tinymce',
					'label' => esc_html__( 'Enter content of featured block', 'solicitor' ),
					'default' => '',
					'rows' => 4
				)
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name( $instance ) {
		return 'template';
	}

	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('featured-blocks-widget', __FILE__, 'Solicitor_Featured_Blocks');