<?php

/*
Widget Name: imithemes - Event List/Grid Widget
Description: A widget to show events list/grid view.
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Event_List_Grid_Widget extends SiteOrigin_Widget {
	function __construct() {
		// Image Size and terms
		$arr = array();
		$arr[] = esc_html__('All', 'solicitor');
		$event_terms = get_terms('event-category');
		if(!is_wp_error($event_terms))
		{
			foreach($event_terms as $term)
			{
				$arr[$term->slug] = $term->name;
			}
		}
		$img_arr = array();
		$image_sizes = get_intermediate_image_sizes();
		if(!empty($image_sizes)&&!is_wp_error($image_sizes))
		{
			foreach($image_sizes as $size)
			{
				$img_arr[$size] = $size;
			}
		}

		parent::__construct(
			'event-list-grid-widget',
			esc_html__('imithemes - Event List/Grid Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to show events list/grid view.', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
				'widget_title' => array(
					'label' => esc_html__( 'Widget Title', 'solicitor' ),
					'type' => 'text',
				),
				'categories' => array(
					'type' => 'select',
					'label' => esc_html__( 'Filter by categories', 'solicitor' ),
					'description' => esc_html__( 'To select multiple categories select with Ctrl/Command key pressed.', 'solicitor' ),
					'multiple' => true,
					'default' => '',
					'options' => $arr
				),
				'event_type' => array(
					'type' => 'select',
					'state_name' => 'future',
					'label' => esc_html__( 'Choose Events Type', 'solicitor' ),
					'options' => array(
						'future' => esc_html__( 'Future', 'solicitor' ),
						'past' => esc_html__( 'Past', 'solicitor' ),
					)
				),
				'event_number' => array(
					'type' => 'slider',
					'label' => esc_html__( 'Number of Event Items to show', 'solicitor' ),
					'default' => 3,
					'min' => 1,
					'max' => 50,
					'integer' => true,
				),
				'excerpt_length' => array(
					'type' => 'text',
					'default' => 25,
					'label' => esc_html__('Show events excerpt. Enter the number of words to show, leave blank to not show. Default value is: 25', 'solicitor'),
					'state_handler' => array(
						'layout_type[grid]' => array('show'),
						'layout_type[list]' => array('hide'),
					),
				),
				'read_more_text' => array(
					'type' => 'text',
					'default' => 'Read more',
					'label' => esc_html__('Full details button text, Leave blank to hide button - Default is Read More', 'solicitor'),
				), 
				'listing_layout' => array(
					'type' => 'section',
					'label' => esc_html__( 'Layout', 'solicitor' ),
					'hide' => false,
					'description' => esc_html__( 'Choose listing layout.', 'solicitor' ),
					'fields' => array(
						'layout_type'    => array(
							'type'    => 'radio',
							'default' => 'list',
							'label'   => esc_html__( 'Layout style', 'solicitor' ),
							'options' => array(
								'grid' => esc_html__( 'Grid', 'solicitor' ),
								'list'      => esc_html__( 'List', 'solicitor' ),
							),
							'state_emitter' => array(
								'callback' => 'select',
								'args' => array( 'layout_type' )
							),
						),
						'grid_column' => array(
							'type' => 'select',
							'state_name' => 'grid',
							'prompt' => esc_html__( 'Choose Grid View Column', 'solicitor' ),
							'options' => array(
								'12' => esc_html__( 'One', 'solicitor' ),
								'6' => esc_html__( 'Two', 'solicitor' ),
								'4' => esc_html__( 'Three', 'solicitor' ),
								'3' => esc_html__( 'Four', 'solicitor' ),
							),
							'state_handler' => array(
								'layout_type[grid]' => array('show'),
								'layout_type[list]' => array('hide'),
							),
						),
						'carousel_mode' => array(
							'type' => 'checkbox',
							'label' => esc_html__('Show as carousel', 'solicitor'),
							'state_handler' => array(
								'layout_type[grid]' => array('show'),
								'layout_type[list]' => array('hide'),
							),
						),
						'carousel_pagi' => array(
							'type' => 'checkbox',
							'default' => false,
							'label' => esc_html__('Enable carousel pagination', 'solicitor'),
							'state_handler' => array(
								'layout_type[grid]' => array('show'),
								'layout_type[list]' => array('hide'),
							),
						),
						'carousel_nav' => array(
							'type' => 'checkbox',
							'default' => true,
							'label' => esc_html__('Enable carousel Next/prev arrows', 'solicitor'),
							'state_handler' => array(
								'layout_type[grid]' => array('show'),
								'layout_type[list]' => array('hide'),
							),
						),
						'carousel_auto' => array(
							'type' => 'number',
							'default' => '',
							'label' => esc_html__('Enter time interval for Auto Carousel. 1000 = 1 second. Leave blank for no AutoPlay.', 'solicitor'),
							'state_handler' => array(
								'layout_type[grid]' => array('show'),
								'layout_type[list]' => array('hide'),
							),
						),
					),
				),
				'img_size' => array(
					'type' => 'select',
					'label' => esc_html__( 'Thumbnail Image Size', 'solicitor' ),
					'default' => 'solicitor-600x400',
					'options' => $img_arr,
					'state_handler' => array(
						'layout_type[grid]' => array('show'),
						'layout_type[list]' => array('hide'),
					),
				),
				'event_pagination' => array(
					'type' => 'checkbox',
					'default' => false,
					'label' => esc_html__('Show Pagination', 'solicitor'),
				),
			),	
			plugin_dir_path(__FILE__)
		);
	}
	
	function get_template_name( $instance ) {
		return 'template';
	}

	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('event-list-grid-widget', __FILE__, 'Solicitor_Event_List_Grid_Widget');