<?php

/*
Widget Name: imithemes - Animated Counter Widget
Description: A widget to add Animated Numbers Counter to your pages.
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Counter_Widget extends SiteOrigin_Widget {
	function __construct() {

		parent::__construct(
			'counter-widget',
			esc_html__('imithemes - Animated Counter Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to add Animated Numbers Counter to your pages.', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
				'icon' => array(
					'type' => 'icon',
					'label' => esc_html__('Icon', 'solicitor'),
				),
				'icon_color' => array(
					'type' => 'color',
					'label' => esc_html__('Icon color', 'solicitor'),
					'default' => '#999999',
				),
  				'icon_size' => array(
					'type' => 'number',
					'label' => esc_html__('Icon size', 'solicitor'),
					'default' =>48,
				),
				'icon_image' => array(
					'type' => 'media',
					'library' => 'image',
					'label' => esc_html__('Icon image', 'solicitor'),
					'description' => esc_html__('Use your own icon image.', 'solicitor'),
				),
				'number' => array(
					'type' => 'number',
					'label' => esc_html__('Number (To count to)', 'solicitor'),
				),
				'number_color' => array(
					'type' => 'color',
					'label' => esc_html__('Number Color', 'solicitor'),
					'default' => '#333333',
				),
				'text' => array(
					'type' => 'text',
					'label' => esc_html__('Text to show below number', 'solicitor'),
				),
				'text_color' => array(
					'type' => 'color',
					'label' => esc_html__('Text Color', 'solicitor'),
					'default' => '#999999',
				),
			),
			plugin_dir_path(__FILE__)
		);
	}
	
	
	function get_template_name( $instance ) {
		return 'template';
	}


	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('counter-widget', __FILE__, 'Solicitor_Counter_Widget');