<?php

/*
Widget Name: Image Carousel Widget
Description: A widget to show a carousel or list of images/logos.
Author: imithemes
Author URI: http://imithemes.com
*/

class Carousel_Widget extends SiteOrigin_Widget {
	function __construct() {

		parent::__construct(
			'carousel-widget',
			esc_html__('Carousel Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to show a carousel or list of images/logos.', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
				'title' => array(
					'type' => 'text',
					'label' => esc_html__('Title', 'solicitor'),
				),
				'images' => array(
					'type' => 'repeater',
					'label' => esc_html__('Images', 'solicitor'),
					'item_name' => esc_html__('Image', 'solicitor'),
					'item_label' => array(
						'selector' => "[id*='image-title']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(

						'icon_image' => array(
							'type' => 'media',
							'library' => 'image',
							'label' => esc_html__('Upload image', 'solicitor'),
						),
					),
				),
				'number_of_posts' => array(
					'type' => 'slider',
					'label' => esc_html__( 'Number of images/logos to show in a row', 'solicitor' ),
					'default' => 4,
					'min' => 1,
					'max' => 5,
					'integer' => true,
				),
				'carousel_pagi' => array(
					'type' => 'checkbox',
					'default' => false,
					'label' => esc_html__('Enable carousel pagination', 'solicitor'),
				),
				'carousel_nav' => array(
					'type' => 'checkbox',
					'default' => true,
					'label' => esc_html__('Enable carousel Next/prev arrows', 'solicitor'),
				),
				'carousel_auto' => array(
					'type' => 'number',
					'default' => '',
					'label' => esc_html__('Enter time interval for Auto Carousel. 1000 = 1 second. Leave blank for no AutoPlay.', 'solicitor'),
				)
			),
			plugin_dir_path(__FILE__)
		);
	}
	
	
	function get_template_name( $instance ) {
		return 'carousel-view';
	}


	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('carousel-widget', __FILE__, 'Carousel_Widget');