<?php

/*
Widget Name: imithemes - Alert Box Widget
Description: A widget to add Alert Boxes to your pages.
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Alert_Widget extends SiteOrigin_Widget {
	function __construct() {

		parent::__construct(
			'alert-widget',
			esc_html__('imithemes - Alert Box Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to add Alert Boxes to your pages.', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
				'content' => array(
					'type' => 'textarea',
					'label' => esc_html__('Alert Box Content', 'solicitor'),
					'description' => esc_html__('HTML tags are allowed in this.', 'solicitor'),
					
				),
				'type' => array(
					'type' => 'select',
					'state_name' => 'standard',
					'label' => esc_html__( 'Choose Color Style', 'solicitor' ),
					'prompt' => esc_html__( 'Choose Color Style', 'solicitor' ),
					'options' => array(
						'standard' => esc_html__( 'Standard', 'solicitor' ),
						'warning' => esc_html__( 'Warning', 'solicitor' ),
						'error' => esc_html__( 'Error', 'solicitor' ),
						'info' => esc_html__( 'Info', 'solicitor' ),
						'success' => esc_html__( 'Success', 'solicitor' ),
					)
				),
				'custom_color' => array(
					'type' => 'color',
					'label' => esc_html__('Custom background color', 'solicitor'),
					'default' => '',
				),
				'custom_bcolor' => array(
					'type' => 'color',
					'label' => esc_html__('Custom border color', 'solicitor'),
					'default' => '',
				),
				'custom_tcolor' => array(
					'type' => 'color',
					'label' => esc_html__('Custom text color', 'solicitor'),
					'default' => '',
				),
				'close' => array(
					'type' => 'checkbox',
					'label' => esc_html__('Show close button', 'solicitor'),
					'default' => true,
				),
				'animation' => array(
					'type' => 'select',
					'state_name' => 'fadeIn',
					'label' => esc_html__( 'Choose animation', 'solicitor' ),
					'prompt' => esc_html__( 'Choose animation', 'solicitor' ),
					'options' => array(
						'flash' => esc_html__( 'Flash', 'solicitor' ),
						'shake' => esc_html__( 'Shake', 'solicitor' ),
						'bounce' => esc_html__( 'Bounce', 'solicitor' ),
						'tada' => esc_html__( 'Tada', 'solicitor' ),
						'swing' => esc_html__( 'Swing', 'solicitor' ),
						'wobble' => esc_html__( 'Wobble', 'solicitor' ),
						'wiggle' => esc_html__( 'Wiggle', 'solicitor' ),
						'pulse' => esc_html__( 'Pulse', 'solicitor' ),
						'fadeIn' => esc_html__( 'FadeIn', 'solicitor' ),
						'fadeInUp' => esc_html__( 'FadeInUp', 'solicitor' ),
						'fadeInLeft' => esc_html__( 'FadeInLeft', 'solicitor' ),
						'fadeInRight' => esc_html__( 'FadeInRight', 'solicitor' ),
						'fadeInUpBig' => esc_html__( 'FadeInUpBig', 'solicitor' ),
						'fadeInDownBig' => esc_html__( 'FadeInDownBig', 'solicitor' ),
						'fadeInLeftBig' => esc_html__( 'FadeInDownBig', 'solicitor' ),
						'fadeInRightBig' => esc_html__( 'FadeInRightBig', 'solicitor' ),
						'bounceIn' => esc_html__( 'BounceIn', 'solicitor' ),
						'bounceInUp' => esc_html__( 'BounceInUp', 'solicitor' ),
						'bounceInDown' => esc_html__( 'BounceInDown', 'solicitor' ),
						'bounceInLeft' => esc_html__( 'BounceInLeft', 'solicitor' ),
						'bounceInRight' => esc_html__( 'BounceInRight', 'solicitor' ),
						'rotateIn' => esc_html__( 'RotateIn', 'solicitor' ),
						'rotateInUpLeft' => esc_html__( 'RotateInUpLeft', 'solicitor' ),
						'rotateInDownLeft' => esc_html__( 'RotateInDownLeft', 'solicitor' ),
						'rotateInUpRight' => esc_html__( 'RotateInUpRight', 'solicitor' ),
						'rotateInDownRight' => esc_html__( 'RotateInDownRight', 'solicitor' ),
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}
	
	
	function get_template_name( $instance ) {
		return 'template';
	}


	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('alert-widget', __FILE__, 'Solicitor_Alert_Widget');