<?php
/* * ** Meta Box Functions **** */
$prefix = 'solicitor_';
global $meta_boxes;
$options = get_option('solicitor_options');
$gmap_api_key = (isset($options['google_map_api']))?$options['google_map_api']:'';
load_theme_textdomain('solicitor', SOLICITOR_FILEPATH . '/language');
$meta_boxes = array();
//Page Design Meta Box
$meta_boxes[] = array(
	'title'       => esc_html__( 'Page Design Options', 'solicitor' ),
	'tabs'      => array(
		'layout'    => array(
			'label' => esc_html__( 'Layout', 'solicitor' ),
		),
		'header'    => array(
			'label' => esc_html__( 'Header', 'solicitor' ),
		),
		'page_header'  => array(
			'label' => esc_html__( 'Page Header', 'solicitor' ),
		),
		'page_title'  => array(
			'label' => esc_html__( 'Page Title', 'solicitor' ),
		),
		'page_content' => array(
			'label' => esc_html__( 'Content', 'solicitor' ),
		),
		'social_share'    => array(
			'label' => esc_html__( 'Social Sharing', 'solicitor' ),
		),
	),
	// Tab style: 'default', 'box' or 'left'. Optional
	'tab_style' => 'left',
	// Show meta box wrapper around tabs? true (default) or false. Optional
	'tab_wrapper' => true,
   	'pages' => array('post','page','team','service','product','event'),
	'fields'    => array(
		array(
            'name' => esc_html__('Header Style', 'solicitor'),
            'id' => $prefix . 'page_header_style',
            'desc' => esc_html__("Select header style for the page.", 'solicitor'),
            'type' => 'select',
			'tab'  => 'header',
            'options' => array(
				'' => esc_html__('Theme Default', 'solicitor'),
				'1' => esc_html__('Style 1', 'solicitor'),
				'2' => esc_html__('Style 2', 'solicitor'),
                '3' => esc_html__('Style 3', 'solicitor'),
				'hidden' => esc_html__('No Header', 'solicitor'),
            )
        ),
		array(
            'name' => esc_html__('Page layout', 'solicitor'),
            'id' => $prefix . 'page_layout',
            'desc' => esc_html__("Select layout for the page.", 'solicitor'),
            'type' => 'select',
			'tab'  => 'layout',
            'options' => array(
				'' => esc_html__('Theme Default', 'solicitor'),
				'full-width-page' => esc_html__('Full Width', 'solicitor'),
				'boxed' => esc_html__('Boxed', 'solicitor'),
            )
        ),
		array(
            'name' => esc_html__('Content Width', 'solicitor'),
            'desc' => esc_html__("Enter width of content in px or %", 'solicitor'),
            'id' => $prefix . 'content_width',
            'type' => 'text',
			'tab'  => 'page_content',
		),
		array(
            'name' => esc_html__('Content Padding Top', 'solicitor'),
            'id' => $prefix . 'content_padding_top',
            'type' => 'number',
            'std' => 60,
			'tab'  => 'page_content',
		),
		array(
            'name' => esc_html__('Content Padding Bottom', 'solicitor'),
            'id' => $prefix . 'content_padding_bottom',
            'type' => 'number',
            'std' => '60',
			'tab'  => 'page_content',
		),
		array(
            'name' => esc_html__('Background Color', 'solicitor'),
            'id' => $prefix . 'pages_body_bg_color',
            'desc' => esc_html__("Choose background color for the outer area", 'solicitor'),
            'type' => 'color',
			'tab'  => 'layout',
			'visible' => array( 'solicitor_page_layout', '=', 'boxed' )
        ),
		array(
            'name' => esc_html__('Background Image', 'solicitor'),
            'id' => $prefix . 'pages_body_bg_image',
            'desc' => esc_html__("Choose background image for the outer area", 'solicitor'),
            'type' => 'image_advanced',
			'tab'  => 'layout',
            'max_file_uploads' => 1,
			'visible' => array( 'solicitor_page_layout', '=', 'boxed' )
        ),
		array(
            'name' => esc_html__('100% Background Image', 'solicitor'),
            'id' => $prefix . 'pages_body_bg_wide',
            'desc' => esc_html__("Choose to have the background image display at 100%.", 'solicitor'),
            'type' => 'select',
			'tab'  => 'layout',
            'options' => array(
                '1' => esc_html__('Yes', 'solicitor'),
                '0' => esc_html__('No', 'solicitor'),
            ),
            'std' => 0,
			'visible' => array( 'solicitor_page_layout', '=', 'boxed' )
        ),
		array(
            'name' => esc_html__('Background Repeat', 'solicitor'),
            'id' => $prefix . 'pages_body_bg_repeat',
            'desc' => esc_html__("Select how the background image repeats.", 'solicitor'),
            'type' => 'select',
			'tab'  => 'layout',
            'options' => array(
                'repeat' => esc_html__('Repeat', 'solicitor'),
                'repeat-x' => esc_html__('Repeat Horizontally', 'solicitor'),
                'repeat-y' => esc_html__('Repeat Vertically', 'solicitor'),
                'no-repeat' => esc_html__('No Repeat', 'solicitor'),
            ),
            'std' => 'repeat',
			'visible' => array( 'solicitor_page_layout', '=', 'boxed' )
        ),
		array(
            'name' => esc_html__('Background Color', 'solicitor'),
            'id' => $prefix . 'pages_content_bg_color',
            'desc' => esc_html__("Choose background color for the Content area", 'solicitor'),
            'type' => 'color',
			'tab'  => 'page_content',
        ),
		array(
            'name' => esc_html__('Background Image', 'solicitor'),
            'id' => $prefix . 'pages_content_bg_image',
            'desc' => esc_html__("Choose background image for the Content area", 'solicitor'),
            'type' => 'image_advanced',
			'tab'  => 'page_content',
            'max_file_uploads' => 1
        ),
		array(
            'name' => esc_html__('100% Background Image', 'solicitor'),
            'id' => $prefix . 'pages_content_bg_wide',
            'desc' => esc_html__("Choose to have the background image display at 100%.", 'solicitor'),
            'type' => 'select',
			'tab'  => 'page_content',
            'options' => array(
                1 => esc_html__('Yes', 'solicitor'),
                0 => esc_html__('No', 'solicitor'),
            ),
            'std' => 0,
        ),
		array(
            'name' => esc_html__('Background Repeat', 'solicitor'),
            'id' => $prefix . 'pages_content_bg_repeat',
            'desc' => esc_html__("Select how the background image repeats.", 'solicitor'),
            'type' => 'select',
			'tab'  => 'page_content',
            'options' => array(
                'repeat' => esc_html__('Repeat', 'solicitor'),
                'repeat-x' => esc_html__('Repeat Horizontally', 'solicitor'),
                'repeat-y' => esc_html__('Repeat Vertically', 'solicitor'),
                'no-repeat' => esc_html__('No Repeat', 'solicitor'),
            ),
            'std' => 'repeat',
        ),
		array(
            'name' => esc_html__('Page Header Show/Hide', 'solicitor'),
            'id' => $prefix . 'page_header_show',
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
                '1' => esc_html__('Show', 'solicitor'),
                '0' => esc_html__('Hide', 'solicitor'),
            ),
            'std' => 1,
        ),
		array(
            'name' => esc_html__('Choose Header Type', 'solicitor'),
            'id' => $prefix . 'pages_Choose_slider_display',
            'desc' => esc_html__("Select Banner Type.", 'solicitor'),
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
				'1' => esc_html__('Colored Banner', 'solicitor'),
				'2' => esc_html__('Image Banner', 'solicitor'),
                '4' => esc_html__('Flex Slider', 'solicitor'),
                '5' => esc_html__('Revolution Slider', 'solicitor'),
            ),
			'std' => 2,
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
        ),
		array(
			'name' => esc_html__( 'Page header right content', 'solicitor' ),
			'id' => $prefix.'page_header_right',
            'desc' => esc_html__("Choose what do you want to display at the right side of page title", 'solicitor'),
			'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
				'1' => esc_html__('None', 'solicitor'),
				'2' => esc_html__('Button', 'solicitor'),
                '3' => esc_html__('Upcoming event counter', 'solicitor'),
            ),
			'std' => 1,
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'hidden' => array( 'solicitor_pages_Choose_slider_display', 'between', [3,5] ),
		),
		array(
			'name' => esc_html__( 'Banner Color', 'solicitor' ),
			'id' => $prefix.'pages_banner_color',
			'type' => 'color',
			'tab'  => 'page_header',
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'visible' => array( 'solicitor_pages_Choose_slider_display', '=', '1' ),
		),
		array(
            'name' => esc_html__('Page header button label', 'solicitor'),
            'id' => $prefix . 'pages_banner_btn_text',
            'type' => 'text',
			'tab'  => 'page_header',
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'visible' => array( 'solicitor_page_header_right', '=', '2' ),
        ),
		array(
            'name' => esc_html__('Page header button URL', 'solicitor'),
            'id' => $prefix . 'pages_banner_btn_url',
            'type' => 'text',
			'tab'  => 'page_header',
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'visible' => array( 'solicitor_page_header_right', '=', '2' ),
        ),
		array(
            'name' => esc_html__('Banner Menu Show/Hide', 'solicitor'),
            'id' => $prefix . 'banner_menu_switch',
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
                0 => esc_html__('Hide', 'solicitor'),
                1 => esc_html__('Show', 'solicitor'),
            ),
            'std' => 0,
			'desc' => esc_html__( 'Select Show to add a sub menu over Image/Color/FlexSlider page header. This will show sub pages of a page in the menu. You should enable it on the parent page only and the menu will be avilable for sub pages by own.', 'solicitor' ),
        ),
		array(
            'name' => esc_html__('Use featured image as page banner', 'solicitor'),
            'id' => $prefix . 'featured_image_banner',
            'desc' => esc_html__("If checked then your page/post featured image will be used as it's page header banner image. Uncheck to upload your own new image for the page header banner.", 'solicitor'),
            'type' => 'checkbox',
			'tab'  => 'page_header',
			'std'  => 0,
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'visible' => array( 'solicitor_pages_Choose_slider_display', '=', '2' ),
        ),
		array(
            'name' => esc_html__('Banner Image', 'solicitor'),
            'id' => $prefix . 'header_image',
            'desc' => esc_html__("Upload banner image for header for this Page/Post.", 'solicitor'),
            'type' => 'image_advanced',
			'tab'  => 'page_header',
            'max_file_uploads' => 1,
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'visible' => array( 'solicitor_pages_Choose_slider_display', '=', '2' ),
        ),
        array(
		   'name' => esc_html__('Select Revolution Slider from list','solicitor'),
			'id' => $prefix . 'pages_select_revolution_from_list',
			'desc' => esc_html__("Select Revolution Slider from list", 'solicitor'),
			'type' => 'select',
			'tab'  => 'page_header',
			'options' => solicitor_RevSliderShortCode(),
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'visible' => array( 'solicitor_pages_Choose_slider_display', '=', '5' ),
		),
        //Slider Image
		array(
            'name' => esc_html__('Banner/Slider Height', 'solicitor'),
            'id' => $prefix . 'pages_slider_height',
            'desc' => esc_html__("Enter Height for Banner/Slider Ex-265.", 'solicitor'),
            'type' => 'text',
			'tab'  => 'page_header',
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'hidden' => array( 'solicitor_pages_Choose_slider_display', '=', '4' ),
			'hidden' => array( 'solicitor_pages_Choose_slider_display', '=', '5' ),
        ),
        array(
            'name' => esc_html__('Slider Images', 'solicitor'),
            'id' => $prefix . 'pages_slider_image',
            'desc' => esc_html__("Upload/Select Slider Images.", 'solicitor'),
            'type' => 'image_advanced',
			'tab'  => 'page_header',
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'visible' => array( 'solicitor_pages_Choose_slider_display', '=', '4' ),
        ),
		array(
            'name' => esc_html__('Slider Pagination', 'solicitor'),
            'id' => $prefix . 'pages_slider_pagination',
            'desc' => esc_html__("Enable to show pagination for slider.", 'solicitor'),
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
                'yes' => esc_html__('Enable', 'solicitor'),
                'no' => esc_html__('Disable', 'solicitor'),
            ),
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'visible' => array( 'solicitor_pages_Choose_slider_display', '=', '4' ),
        ),
		array(
            'name' => esc_html__('Slider Auto Slide', 'solicitor'),
            'id' => $prefix . 'pages_slider_auto_slide',
            'desc' => esc_html__("Select Yes to slide automatically.", 'solicitor'),
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
                'yes' => esc_html__('Yes', 'solicitor'),
                'no' => esc_html__('No', 'solicitor'),
            ),
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'visible' => array( 'solicitor_pages_Choose_slider_display', '=', '4' ),
        ),
		array(
            'name' => esc_html__('Slider Direction Arrows', 'solicitor'),
            'id' => $prefix . 'pages_slider_direction_arrows',
            'desc' => esc_html__("Select Yes to show slider direction arrows.", 'solicitor'),
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
                'yes' => esc_html__('Yes', 'solicitor'),
                'no' => esc_html__('No', 'solicitor'),
            ),
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'visible' => array( 'solicitor_pages_Choose_slider_display', '=', '4' ),
        ),
		array(
            'name' => esc_html__('Slider Effects', 'solicitor'),
            'id' => $prefix . 'pages_slider_effects',
            'desc' => esc_html__("Select effects for slider.", 'solicitor'),
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
                'fade' => esc_html__('Fade', 'solicitor'),
                'slide' => esc_html__('Slide', 'solicitor'),
            ),
			'visible' => array( 'solicitor_page_header_show', '=', '1' ),
			'visible' => array( 'solicitor_pages_Choose_slider_display', '=', '4' ),
        ),
		array(
            'name' => esc_html__('Page Title Show/Hide', 'solicitor'),
            'id' => $prefix . 'pages_title_show',
            'type' => 'select',
			'tab'  => 'page_title',
            'options' => array(
                1 => esc_html__('Show', 'solicitor'),
                0 => esc_html__('Hide', 'solicitor'),
            ),
            'std' => 1,
        ),
		array(
            'name' => esc_html__('Page Title Text Color', 'solicitor'),
            'id' => $prefix . 'pages_banner_text_color',
            'desc' => esc_html__("Select banner text color.", 'solicitor'),
            'type' => 'color',
			'tab'  => 'page_title'
        ),
		array(
            'name' => esc_html__('Page Title Alignment', 'solicitor'),
            'id' => $prefix . 'pages_title_alignment',
            'desc' => esc_html__("Choose aligment of the page title.", 'solicitor'),
            'type' => 'select',
			'tab'  => 'page_title',
            'options' => array(
				'' => esc_html__('Theme Default', 'solicitor'),
				'left' => esc_html__('Left', 'solicitor'),
				'center' => esc_html__('Center', 'solicitor'),
                'right' => esc_html__('Right', 'solicitor'),
            ),
        ),
		array(
            'name' => esc_html__('Show social sharing buttons', 'solicitor'),
            'id' => $prefix . 'page_social_share',
            'type' => 'select',
			'tab'  => 'social_share',
            'options' => array(
                '1' => esc_html__('Show', 'solicitor'),
                '0' => esc_html__('Hide', 'solicitor'),
            ),
            'std' => 1,
        ),
	),
);
/* Registrant Meta Box
  ================================================== */
$meta_boxes[] = array(
    'id' => 'registrant_meta_box',
    'title' => esc_html__('Registrant Details', 'solicitor'),
    'pages' => array('event_registrants'),
    'fields' => array(
		array(
            'name' => esc_html__('Email', 'solicitor'),
            'id' => $prefix . 'registrant_email',
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Phone', 'solicitor'),
            'id' => $prefix . 'registrant_phone',
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Address', 'solicitor'),
            'id' => $prefix . 'registrant_address',
            'type' => 'textarea',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Addition Notes', 'solicitor'),
            'id' => $prefix . 'registrant_additional_notes',
            'type' => 'textarea',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Date', 'solicitor'),
            'id' => $prefix . 'registrant_event_date',
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Transaction ID', 'solicitor'),
            'id' => $prefix . 'registrant_transaction',
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Payment Status', 'solicitor'),
            'id' => $prefix . 'registrant_payment_status',
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Paid Amount', 'solicitor'),
            'id' => $prefix . 'registrant_paid_amount',
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Registration Number', 'solicitor'),
            'id' => $prefix . 'registrant_registration_number',
            'type' => 'text',
            'std' => '',
        ),
    )
);
/* Event Meta Box
  ================================================== */
/*** Event Details Meta box ***/   
$meta_boxes[] = array(
    'id' => 'event_meta_box',
    'title' => esc_html__('Event Date', 'solicitor'),
    'pages' => array('event'),
    'fields' => array( 
        array(
            'name' => esc_html__('Event Start Date', 'solicitor'),
            'id' => $prefix . 'event_start_dt',
            'desc' => esc_html__("Insert date of Event start.", 'solicitor'),
            'type' => 'datetime',
			'js_options' => array(
	              'dateFormat'      => 'yy-mm-dd',
				  'hourMax' => 24,
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
					'stepMinute' => 5,
					'showSecond' => false,
					'stepSecond' => 10,
				),
        ),
        //Event End Date
        array(
            'name' => esc_html__(' Event End Date', 'solicitor'),
            'id' => $prefix . 'event_end_dt',
            'desc' => esc_html__("Insert date of Event end, multiple days Event could not be recur.", 'solicitor'),
            'type' => 'datetime',
			'js_options' => array(
	              'dateFormat'      => 'yy-mm-dd',
				  'hourMax' => 24,
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
					'stepMinute' => 5,
					'showSecond' => false,
					'stepSecond' => 10,
				),
        ),
    )
);
/*** Event Address Meta box ***/   
$meta_boxes[] = array(
    'id' => 'event_address_box',
    'title' => esc_html__('Event Details', 'solicitor'),
    'pages' => array('event'),
    'fields' => array( 
		array(
			'name'  => esc_html__('Address', 'solicitor'),
			'id'    => $prefix."event_address",
			'desc'  =>  esc_html__("This field should have real address to get GMap.", 'solicitor'),
			'type' => 'text',
		),   
		array(
			'id'    => $prefix."event_map_location",
			'name' => esc_html__( 'Location', 'solicitor' ),
			'type' => 'map',
			'api_key' => $gmap_api_key,
			'std' => '-6.233406,-35.049906,15', // 'latitude,longitude[,zoom]' (zoom is optional)
			'style' => 'width: 500px; height: 500px',
			'address_field' => 'solicitor_event_address', // Name of text field where address is entered. Can be list of text fields, separated by commas (for ex. city, state)
		),
		array(
			'name'  => esc_html__('Event Manager Name', 'solicitor'),
			'id'    => $prefix."event_manager_name",
			'desc'  =>  esc_html__("Enter event manager name.", 'solicitor'),
			'type' => 'text',
		),
		array(
			'name'  => esc_html__('Event Manager Email', 'solicitor'),
			'id'    => $prefix."event_manager",
			'desc'  =>  esc_html__("Enter event manager email address for contact.", 'solicitor'),
			'type' => 'text',
		),
		array(
			'name' => esc_html__( 'Enable Registration', 'solicitor' ),
			'id' => $prefix.'event_registration',
			'type' => 'checkbox',
			// Value can be 0 or 1
			'std' => 0,
		),  
		array(
			'name' => esc_html__( 'Custom Registration Button URL', 'solicitor' ),
			'id' => $prefix.'custom_event_registration',
			'desc' => esc_html__("For example EventBrite Event page URL of yours.", 'solicitor'),
			'type' => 'text'
		),
		array(
			'name' => esc_html__( 'Open custom URL in new Tab/Window', 'solicitor' ),
			'id' => $prefix.'custom_event_registration_target',
			'type' => 'checkbox',
			// Value can be 0 or 1
			'std' => 1,
		),
		array(
			'name' => esc_html__( 'Total Attendees', 'solicitor' ),
			'id' => $prefix.'event_attendees',
			'desc' => esc_html__("Enter number of attendees allowed for this event.", 'solicitor'),
			'type' => 'text'
		),
		)
);
/*** Event Recurrence Meta box ***/   
$meta_boxes[] = array(
    'id' => 'event_recurring_box',
    'title' => esc_html__('Recurring Event', 'solicitor'),
    'pages' => array('event'),
    'fields' => array( 		 
        //Frequency of Event
		array(
            'name' => esc_html__('Event Frequency Type', 'solicitor'),
            'id' => $prefix . 'event_frequency_type',
            'desc' => esc_html__("Select Frequency Type.", 'solicitor'),
            'type' => 'select',
            'options' => array(
				'0' => esc_html__('Not Required','solicitor'),
				'1' => esc_html__('Fixed Date','solicitor'),
        '2' => esc_html__('Week Day', 'solicitor'),
        ),
		),
		array(
            'name' => esc_html__('Week of Month', 'solicitor'),
            'id' => $prefix . 'event_day_month',
            'desc' => esc_html__("Select Week of Month.", 'solicitor'),
            'type' => 'select',
            'options' => array(
				'first' => esc_html__('First','solicitor'),
        'second' => esc_html__('Second', 'solicitor'),
				'third' => esc_html__('Third', 'solicitor'),
				'fourth' => esc_html__('Fourth', 'solicitor'),
				'last' => esc_html__('Last', 'solicitor'),
        ),
		),
		array(
            'name' => esc_html__('Event Week Day', 'solicitor'),
            'id' => $prefix . 'event_week_day',
            'desc' => esc_html__("Select Week Day.", 'solicitor'),
            'type' => 'select',
            'options' => array(
				'sunday' => esc_html__('Sunday','solicitor'),
                'monday' => esc_html__('Monday', 'solicitor'),
				'tuesday' => esc_html__('Tuesday', 'solicitor'),
				'wednesday' => esc_html__('Wednesday', 'solicitor'),
				'thursday' => esc_html__('Thursday', 'solicitor'),
				'friday' => esc_html__('Friday', 'solicitor'),
				'saturday' => esc_html__('Saturday', 'solicitor'),
        ),
		),
        array(
            'name' => esc_html__('Event Frequency', 'solicitor'),
            'id' => $prefix . 'event_frequency',
            'desc' => esc_html__("Select Frequency.", 'solicitor'),
            'type' => 'select',
            'options' => array(
				'35' => esc_html__('Select', 'solicitor'),
                '1' => esc_html__('Every Day', 'solicitor'),
				'2' => esc_html__('Every Second Day', 'solicitor'),
				'3' => esc_html__('Every Third Day', 'solicitor'),
				'4' => esc_html__('Every Fourth Day', 'solicitor'),
				'5' => esc_html__('Every Fifth Day', 'solicitor'),
				'6' => esc_html__('Every Sixth Day', 'solicitor'),
                '7' => esc_html__('Every Week', 'solicitor'),
				'30' => esc_html__('Every Month', 'solicitor'),
            ),
        ),
		//Frequency Count
		array(
            'name' => esc_html__('Number of times to repeat event', 'solicitor'),
            'id' => $prefix . 'event_frequency_count',
            'desc' => esc_html__("Enter the number of how many time this event should repeat.", 'solicitor'),
            'type' => 'text',
        ),
		array(
            'name' => esc_html__('Multiple Days Frequency Type', 'solicitor'),
            'id' => $prefix . 'event_multiple_type',
            'desc' => esc_html__("Select Multiple Days Frequency Type.", 'solicitor'),
            'type' => 'select',
            'options' => array(
							'0' => esc_html__('Exclude','solicitor'),
							'1' => esc_html__('Add Dynamic Date','solicitor'),
							
        ),
		),
		array(
            'name' => esc_html__('Multiple Event Date', 'solicitor'),
            'id' => $prefix . 'event_multiple_dates',
            'desc' => esc_html__("Add/Exclude Multiple Date.", 'solicitor'),
            'type' => 'date',
						'clone' => true,
			'js_options' => array(
				'dateFormat'      =>'yy-mm-dd',
				'changeMonth'     => true,
				'changeYear'      => true,
				'showButtonPanel' => false,
			),
        ),    
		array(
            'name' => esc_html__('Do not change', 'solicitor'),
            'id' => $prefix . 'event_frequency_end',
            'desc' => esc_html__("If any changes done in this file, may your theme will not work like running now.", 'solicitor'),
            'type' => 'hidden',
        ),    
    )
);
//Team Meta Box
$meta_boxes[] = array(
    'id' => 'staff_meta_box',
    'title' => esc_html__('Team Member Info', 'solicitor'),
    'pages' => array('team'),
    'fields' => array(
		array(
            'name' => esc_html__('Team Position', 'solicitor'),
            'id' => $prefix . 'staff_position',
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Email ID', 'solicitor'),
            'id' => $prefix . 'email_id',
            'type' => 'text',
            'std' => '',
        ),
	    array(
            'name' => esc_html__('Social Icon', 'solicitor'),
            'id' => $prefix. 'social_icon_list',
            'desc' => esc_html__('Enter Social Icon and Url.', 'solicitor'),
            'type' => 'text_list',
            'clone' => true,
            'options' => array(
            '0' => esc_html__('Social', 'solicitor'),
            '1' => esc_html__('URL', 'solicitor'))
        ),
    )
);
//Testimonials Meta Box
$meta_boxes[] = array(
    'id' => 'template-testimonial1',
    'title' => esc_html__('Testimonial Info', 'solicitor'),
    'pages' => array('testimonial'),
    'fields' => array(
		array(
            'name' => esc_html__('Client Info', 'solicitor'),
            'id' => $prefix . 'testimonial_position',
            'type' => 'text',
            'std' => '',
        ),
    )
);
/* * ******************* META BOX REGISTERING ********************** */
/**
 * Register meta boxes
 *
 * @return void
 */
function solicitor_register_meta_boxes() {
    global $meta_boxes;
    // Make sure there's no errors when the plugin is deactivated or during upgrade
    if (class_exists('RW_Meta_Box')) {
        foreach ($meta_boxes as $meta_box) {
            new RW_Meta_Box($meta_box);
        }
    }
}
add_action('rwmb_meta_boxes', 'solicitor_register_taxonomy_meta_boxes');
function solicitor_register_taxonomy_meta_boxes($meta_boxes) {
$prefix = 'solicitor_';
/* Term Meta Box
  ================================================== */
$meta_boxes[] = array(
    'title' => esc_html__('Additional Info', 'solicitor'),
    'taxonomies' => array('event-category', 'service-category', 'team-category', 'category'),
    'fields' => array(
		array(
            'name' => esc_html__('Page Image Banner', 'solicitor'),
            'id' => $prefix . 'term_banner_image',
            'type' => 'image_advanced',
            'max_file_uploads' => 1
		),
    )
);
	return $meta_boxes;
}
// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking Page template, categories, etc.
add_action('admin_init', 'solicitor_register_meta_boxes');
/* * ******************* META BOX CHECK ********************** */
/**
 * Check if meta boxes is included
 *
 * @return bool
 */
function rw_maybe_include($template_file) {
    // Include in back-end only
    if (!defined('WP_ADMIN') || !WP_ADMIN)
        return false;
    // Always include for ajax
    if (defined('DOING_AJAX') && DOING_AJAX)
        return true;
    // Check for post IDs
    $checked_post_IDs = array();
    if (isset($_GET['post']))
        $post_id = $_GET['post'];
    elseif (isset($_POST['post_ID']))
        $post_id = $_POST['post_ID'];
    else
        $post_id = false;
    $post_id = (int) $post_id;
    if (in_array($post_id, $checked_post_IDs))
        return true;
    // Check for Page template
    $checked_templates = array($template_file);
    $template = get_post_meta($post_id, '_wp_page_template', true);
    if (in_array($template, $checked_templates))
        return true;
// If no condition matched
    return false;
}
?>