<?php

    /**
     * ReduxFramework Barebones Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }
	load_theme_textdomain('bootstrap-theme', SOLICITOR_FILEPATH . '/language');
    // This is your option name where all the Redux data is stored.
    $opt_name = "solicitor_options";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Theme Options', 'solicitor' ),
        'page_title'           => esc_html__( 'Theme Options', 'solicitor' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => 57,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        //'compiler'             => true,
		'disable_tracking' => true,
        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/imithemes',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://twitter.com/imithemes',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
    } else {
    }

    // Add content after the form.

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     * ---> START HELP TABS
     */


    // Set the help sidebar
    $content = esc_html__( '<p>This is the sidebar content, HTML is allowed.</p>', 'solicitor' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */
	load_theme_textdomain('bootstrap-theme', SOLICITOR_FILEPATH . '/language');
			$defaultAdminlogo = get_template_directory_uri().'/images/logo-admin.png';
			$default_logo = get_template_directory_uri() . '/images/logo.png';
			$defaultRetinaLogo = get_template_directory_uri().'/images/logo@2x.png';
			$footer_logo = get_template_directory_uri() . '/images/logo-light.png';
    // -> START Basic Fields
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-cogs',
    'icon_class' => 'icon-large',
    'title' => esc_html__('General', 'solicitor'),
    'fields' => array(
        array(
            'id' => 'enable_maintenance',
            'type' => 'switch',
            'title' => esc_html__('Enable Maintenance', 'solicitor'),
            'subtitle' => esc_html__('Enable the themes in maintenance mode.', 'solicitor'),
            "default" => 'off',
            'on' => esc_html__('Enabled', 'solicitor'),
            'off' => esc_html__('Disabled', 'solicitor'),
        ),
        array(
            'id' => 'enable_backtotop',
            'type' => 'switch',
            'title' => esc_html__('Enable Back To Top', 'solicitor'),
            'subtitle' => esc_html__('Enable the back to top button that appears in the bottom right corner of the screen.', 'solicitor'),
            "default" => 1,
        ),
       array(
            'id' => 'space-before-head',
            'type' => 'ace_editor',
            'title' => esc_html__('Space before closing head tag', 'solicitor'),
            'subtitle' => esc_html__('Add your code before closing head tag', 'solicitor'),
			'default' => '',
        ),
       array(
            'id' => 'space-before-body',
            'type' => 'ace_editor',
            'title' => esc_html__('Space before closing body tag', 'solicitor'),
            'subtitle' => esc_html__('Add your code before closing body tag', 'solicitor'),
			'default' => '',
        ),
    )
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-website',
    'icon_class' => 'icon-large',
    'title' => esc_html__('Responsive', 'solicitor'),
    'fields' => array(
        array(
            'id' => 'switch-responsive',
            'type' => 'switch',
            'title' => esc_html__('Enable Responsive', 'solicitor'),
            'subtitle' => esc_html__('Enable/Disable the responsive behaviour of the theme', 'solicitor'),
            "default" => 1,
        ),
        array(
            'id' => 'switch-zoom-pinch',
            'type' => 'switch',
            'title' => esc_html__('Enable Zoom on mobile devices', 'solicitor'),
            'subtitle' => esc_html__('Enable/Disable zoom pinch behaviour on touch devices', 'solicitor'),
            "default" => 0,
        ),
    )
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-screen',
    'title' => esc_html__('Layout', 'solicitor'),
    'fields' => array(
        array(
			'id'=>'site_layout',
			'type' => 'image_select',
			'compiler'=>true,
			'title' => esc_html__('Page Layout', 'solicitor'), 
			'subtitle' => esc_html__('Select the page layout type', 'solicitor'),
			'options' => array(
					'wide' => array('alt' => 'Wide', 'img' => get_template_directory_uri().'/images/wide.png'),
					'boxed' => array('alt' => 'Boxed', 'img' => get_template_directory_uri().'/images/boxed.png')
				),
			'default' => 'wide',
			),
		array(
			'id'=>'repeatable-bg-image',
			'type' => 'image_select',
			'required' => array('site_layout','equals','boxed'),
			'title' => esc_html__('Repeatable Background Images', 'solicitor'), 
			'subtitle' => esc_html__('Select image to set in background.', 'solicitor'),
			'options' => array(
				'pt1.png' => array('alt' => 'pt1', 'img' => get_template_directory_uri().'/images/patterns/pt1.png'),
				'pt2.png' => array('alt' => 'pt2', 'img' => get_template_directory_uri().'/images/patterns/pt2.png'),
				'pt3.png' => array('alt' => 'pt3', 'img' => get_template_directory_uri().'/images/patterns/pt3.png'),
				'pt4.png' => array('alt' => 'pt4', 'img' => get_template_directory_uri().'/images/patterns/pt4.png'),
				'pt5.png' => array('alt' => 'pt5', 'img' => get_template_directory_uri().'/images/patterns/pt5.png'),
				'pt6.png' => array('alt' => 'pt6', 'img' => get_template_directory_uri().'/images/patterns/pt6.png'),
				'pt7.png' => array('alt' => 'pt7', 'img' => get_template_directory_uri().'/images/patterns/pt7.png'),
				'pt8.png' => array('alt' => 'pt8', 'img' => get_template_directory_uri().'/images/patterns/pt8.png'),
				'pt9.png' => array('alt' => 'pt9', 'img' => get_template_directory_uri().'/images/patterns/pt9.png'),
				'pt10.png' => array('alt' => 'pt10', 'img' => get_template_directory_uri().'/images/patterns/pt10.png'),
				'pt11.jpg' => array('alt' => 'pt11', 'img' => get_template_directory_uri().'/images/patterns/pt11.png'),
				'pt12.jpg' => array('alt' => 'pt12', 'img' => get_template_directory_uri().'/images/patterns/pt12.png'),
				'pt13.jpg' => array('alt' => 'pt13', 'img' => get_template_directory_uri().'/images/patterns/pt13.png'),
				'pt14.jpg' => array('alt' => 'pt14', 'img' => get_template_directory_uri().'/images/patterns/pt14.png'),
				'pt15.jpg' => array('alt' => 'pt15', 'img' => get_template_directory_uri().'/images/patterns/pt15.png'),
				'pt16.png' => array('alt' => 'pt16', 'img' => get_template_directory_uri().'/images/patterns/pt16.png'),
				'pt17.png' => array('alt' => 'pt17', 'img' => get_template_directory_uri().'/images/patterns/pt17.png'),
				'pt18.png' => array('alt' => 'pt18', 'img' => get_template_directory_uri().'/images/patterns/pt18.png'),
				'pt19.png' => array('alt' => 'pt19', 'img' => get_template_directory_uri().'/images/patterns/pt19.png'),
				'pt20.png' => array('alt' => 'pt20', 'img' => get_template_directory_uri().'/images/patterns/pt20.png'),
				'pt21.png' => array('alt' => 'pt21', 'img' => get_template_directory_uri().'/images/patterns/pt21.png'),
				'pt22.png' => array('alt' => 'pt22', 'img' => get_template_directory_uri().'/images/patterns/pt22.png'),
				'pt23.png' => array('alt' => 'pt23', 'img' => get_template_directory_uri().'/images/patterns/pt23.png'),
				'pt24.png' => array('alt' => 'pt24', 'img' => get_template_directory_uri().'/images/patterns/pt24.png'),
				'pt25.png' => array('alt' => 'pt25', 'img' => get_template_directory_uri().'/images/patterns/pt25.png'),
				'pt26.png' => array('alt' => 'pt26', 'img' => get_template_directory_uri().'/images/patterns/pt26.png'),
				'pt27.png' => array('alt' => 'pt27', 'img' => get_template_directory_uri().'/images/patterns/pt27.png'),
				'pt28.png' => array('alt' => 'pt28', 'img' => get_template_directory_uri().'/images/patterns/pt28.png'),
				'pt29.png' => array('alt' => 'pt29', 'img' => get_template_directory_uri().'/images/patterns/pt29.png'),
				'pt30.png' => array('alt' => 'pt30', 'img' => get_template_directory_uri().'/images/patterns/pt30.png')
				)
			),	
		array(
			'id'=>'upload-repeatable-bg-image',
			'compiler'=>true,
			'required' => array('site_layout','equals','boxed'),
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Upload Repeatable Background Image', 'solicitor')
			),
		array(
			'id'=>'full-screen-bg-image',
			'compiler'=>true,
			'required' => array('site_layout','equals','boxed'),
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Upload Full Screen Background Image', 'solicitor')
		),
        array(
			'id'=>'site_width',
			'type' => 'text',
			'compiler'=>true,
			'title' => esc_html__('Site width in pixels. DO NOT PUT px HERE', 'solicitor'), 
			'subtitle' => esc_html__('Width of the site container.', 'solicitor'),
			'default' => '1170',
		),	
		
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Content', 'solicitor'),
	'subsection' => true,
    'fields' => array(
		array(  'id' => 'content_background',
				'type' => 'background',
				'background-color'=> true,
				'output' => array('.content'),
				'title' => esc_html__('Content area Background', 'solicitor'),
    			'subtitle' => esc_html__('Background color or image for the content area. This works for both boxed or wide layouts.', 'solicitor'),
		),
		array(
			'id'       => 'content_padding',
			'type'     => 'spacing',
			'units'    => array('px'),
			'mode'	   => 'padding',
			'left'	   => false,
			'right'	   => false,
			'output'   => array('.content'),
			'title'    => esc_html__('Top and Bottom padding for content area', 'solicitor'),
			'subtitle' => esc_html__('Enter top and bottom padding for content area. Default is 50px/50px', 'solicitor'),
			'default'            => array(
			'padding-top'     => '60px',
			'padding-bottom'  => '60px',
			'units'          => 'px',
			),
		),
		array(
			'id'       => 'content_min_height',
			'type'     => 'text',
			'title'    => esc_html__('Minimum Height for Content area', 'solicitor'),
			'subtitle' => esc_html__('Enter minimum height for the page content area. DO NOT PUT px HERE. Default is 400', 'solicitor'),
			'default'  => '400'
		),
        array(
			'id'=>'content_wide_width',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('100% Content Width', 'solicitor'), 
			'subtitle' => esc_html__('Check this box to set the content area to 100% of the browser width. Uncheck to follow site width.', 'solicitor'),
			'default' => '0',
		),

	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-chevron-up',
    'title' => esc_html__('Header', 'solicitor'),
    'desc' => esc_html__('These are the options for the header.', 'solicitor'),
    'fields' => array(
		array(
    		'id' => 'header_layout',
    		'type' => 'image_select',
    		'compiler'=>true,
			'title' => esc_html__('Header Layout','solicitor'), 
			'subtitle' => esc_html__('Select the Header layout', 'solicitor'),
    		'options' => array(
				'1' => array('title' => '', 'img' => get_template_directory_uri().'/images/headers/one.png'),
				'2' => array('title' => '', 'img' => get_template_directory_uri().'/images/headers/two.png'),
				'3' => array('title' => '', 'img' => get_template_directory_uri().'/images/headers/three.png'),
    		),
    		'default' => '1'
    	),
        array(
			'id'=>'header_wide_width',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('100% Header Width', 'solicitor'), 
			'subtitle' => esc_html__('Check this box to set the header area to 100% of the browser width. Uncheck to follow site width.', 'solicitor'),
			'default' => '0',
		),
		array(  'id' => 'header_background_alpha',
			'type' => 'background',
			'output' => array('.site-header'),
			'title' => esc_html__('Header Background', 'solicitor'),
			'required' => array('header_layout','!=','2'),
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Header Info', 'solicitor'),
	'subsection' => true,
    'fields' => array(
			array(
            	'id' => 'header_info_switch',
            	'type' => 'switch',
            	'title' => esc_html__('Show/Hide', 'solicitor'),
            	'subtitle' => esc_html__('Show/Hide information that is shown in the header','solicitor'),
            	'default' => 1,
        	),	
			array(
            	'id' => 'header_icon1',
            	'type' => 'text',
            	'title' => esc_html__('Header Info 1 icon', 'solicitor'),
            	'subtitle' => esc_html__('Insert top bar icon, you can select icon from http://fontawesome.io/icons/, Ex- fa-anchor', 'solicitor'),
            	'default' => 'fa fa-map-marker'
        	),
			array(
            	'id' => 'header_text1',
            	'type' => 'text',
            	'title' => esc_html__('Header Info 1 text', 'solicitor'),
            	'default' => 'Suite 300 Houston<br> Texas - 77042 USA'
        	),
			array(
    			'id'   =>'divider_1',
    			'type' => 'divide'
			),
			array(
            	'id' => 'header_icon2',
            	'type' => 'text',
            	'title' => esc_html__('Header Info 2 icon', 'solicitor'),
            	'subtitle' => esc_html__('Insert top bar icon, you can select icon from http://fontawesome.io/icons/, Ex- fa-anchor', 'solicitor'),
            	'default' => 'fa fa-phone'
        	),
			array(
            	'id' => 'header_text2',
            	'type' => 'text',
            	'title' => esc_html__('Header Info 2 text', 'solicitor'),
            	'default' => '<strong>Call us toll free</strong><br>1800-9090-8089'
        	),
			array(
    			'id'   =>'divider_2',
    			'type' => 'divide'
			),
			array(
            	'id' => 'header_icon3',
            	'type' => 'text',
            	'title' => esc_html__('Header Info 3 icon', 'solicitor'),
            	'subtitle' => esc_html__('Insert top bar icon, you can select icon from http://fontawesome.io/icons/, Ex- fa-anchor', 'solicitor'),
           	 	'default' => 'fa fa-clock-o'
        	),
			array(
            	'id' => 'header_text3',
            	'type' => 'text',
            	'title' => esc_html__('Header Info 3 text', 'solicitor'),
            	'default' => '<strong>Working Hours</strong><br>Mon - Sat 06:00 to 18:00'
			),
			array(
				'id'       => 'header_info_icon_typo',
				'type'     => 'typography',
				'text-transform' => false,
				'font-family' => false,
				'word-spacing' => false,
				'letter-spacing' => false,
				'font-style' => false,
				'font-weight' => false,
				'color' => true,
				'line-height' => false,
				'text-align' => false,
				'title'    => esc_html__('Header Info Icon Typograohy', 'solicitor'),
				'output'   => array('#info-content > li i, .header-style3 #info-content > li i')
			),
			array(
				'id'       => 'header_info_typo',
				'type'     => 'typography',
				'text-transform' => true,
				'word-spacing' => true,
				'letter-spacing' => true,
				'color' => true,
				'line-height' => false,
				'text-align' => false,
				'title'    => esc_html__('Header Info Typograohy', 'solicitor'),
				'output'   => array('#info-content > li, .header-style3 #info-content > li')
			),
		)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Topbar', 'solicitor'),
	'subsection' => true,
    'fields' => array(
		array(
            'id' => 'enable_topbar',
            'type' => 'switch',
            'title' => esc_html__('Enable Topbar', 'solicitor'),
            "default" => 'off',
            '1' => esc_html__('Enable', 'solicitor'),
            '0' => esc_html__('Disable', 'solicitor'),
        ),
		array(  'id' => 'topbar_background_alpha',
			'type' => 'background',
			'output' => array('.topbar'),
			'title' => esc_html__('Topbar Background', 'solicitor'),
		),
		array(
			'id'=>'header_text_left',
			'type' => 'text',
			'compiler'=>true,
			'title' => esc_html__('Topbar message', 'solicitor'), 
			'description' => esc_html__('Keep it short and sweet.', 'solicitor'),
			'default' => '',
		),	
		array(
			'id'=>'header_text_url',
			'type' => 'text',
			'compiler'=>true,
			'title' => esc_html__('Topbar message URL', 'solicitor'), 
			'default' => '',
		),
		array(
			'id'       => 'header_text_typo',
			'type'     => 'typography',
			'color' => true,
			'line-height' => false,
			'text-align' => false,
			'title'    => esc_html__('Topbar message Typograohy', 'solicitor'),
			'output'   => array('.topbar p')
		),
		array(
			'id' => 'header_social_links',
			'type' => 'sortable',
			'label' => true,
			'compiler'=>true,
			'title' => esc_html__('Social Links', 'solicitor'),
			'desc' => esc_html__('Insert Social URL in their respective fields and sort by drag drop.', 'solicitor'),
			'options' => array(
				'fa-facebook' => 'facebook',
				'fa-twitter' => 'twitter',
				'fa-pinterest' => 'pinterest',
				'fa-google-plus' => 'google',
				'fa-youtube' => 'youtube',
				'fa-instagram' => 'instagram',
				'fa-vimeo-square' => 'vimeo',
				'fa-rss' => 'rss',
				'fa-dribbble' => 'dribbble',
				'fa-dropbox' => 'dropbox',
				'fa-bitbucket' => 'bitbucket',
				'fa-flickr' => 'flickr',
				'fa-foursquare' => 'foursquare',
				'fa-github' => 'github',
				'fa-gittip' => 'gittip',
				'fa-linkedin' => 'linkedin',
				'fa-pagelines' => 'pagelines',
				'fa-skype' => 'Enter Skype ID',
				'fa-tumblr' => 'tumblr',
				'fa-vk' => 'vk',
				'fa-envelope' => 'Enter Email Address'
			)
		),
		array(
			'id'       => 'topbar_social_typo',
			'type'     => 'typography',
			'text-transform' => false,
			'word-spacing' => false,
			'letter-spacing' => false,
			'color' => false,
			'line-height' => false,
			'text-align' => false,
			'font-family' => false,
			'font-weight' => false,
			'font-style' => false,
			'preview'  => false,
			'title'    => esc_html__('Social Icons size', 'solicitor'),
			'output'   => array('.topbar .social-icons li a')
		),
		array(
			'id'       => 'topbar_social_link_color',
			'type'     => 'link_color',
			'title'    => esc_html__('Social Icons Link Color', 'solicitor'),
			'desc'     => esc_html__('Set the links color, hover, active for social icons in the topbar.', 'solicitor'),
			'output'   => array('.topbar .social-icons li a'),
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Inner Page Header', 'solicitor'),
	'subsection' => true,
    'fields' => array(
        array(
			'id'=>'inner_page_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Show/Hide page header', 'solicitor'), 
			'subtitle' => esc_html__('Check this box to show page header on the inner pages/posts/custom posts. This can be used as default for all inner pages and can override the individual page design options.', 'solicitor'),
			'default' => 1,
		),
		array(  
			'id' => 'inner_page_header_background',
			'type' => 'background',
			'background-color'=> true,
			'background-image'=> false,
			'background-repeat'=> false,
			'background-attachment'=> false,
			'background-size'=> false,
			'background-position'=> false,
			'preview'=> false,
			'output' => array('.page-header'),
			'title' => esc_html__('Default Page Header Color', 'solicitor'),
			'subtitle' => esc_html__('Background color for the inner pages header.', 'solicitor'),
		),
		array(
			'id'=>'solicitor_default_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image', 'solicitor'),
			'subtitle' => esc_html__('Upload default banner image for the inner pages header.', 'solicitor'),
            'default' => array('url' => ''),
		),
		array(
			'id'=>'default_event_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for Events', 'solicitor'),
			'subtitle' => esc_html__('Upload default banner image for the events header.', 'solicitor'),
            'default' => array('url' => ''),
		),
		array(
			'id'=>'default_post_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for Blog Posts', 'solicitor'),
			'subtitle' => esc_html__('Upload default banner image for the blog posts header.', 'solicitor'),
            'default' => array('url' => ''),
		),
		array(
			'id'=>'default_service_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for Services', 'solicitor'),
			'subtitle' => esc_html__('Upload default banner image for the service posts header.', 'solicitor'),
            'default' => array('url' => ''),
		),
		array(
			'id'=>'default_team_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for Team', 'solicitor'),
			'subtitle' => esc_html__('Upload default banner image for the team posts header.', 'solicitor'),
            'default' => array('url' => ''),
		),
		array(
			'id'=>'default_product_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for WooCommerce products', 'solicitor'),
			'subtitle' => esc_html__('Upload default banner image for the woocommerce product posts header.', 'solicitor'),
            'default' => array('url' => ''),
		),
		array(
			'id'       => 'inner_page_header_min_height',
			'type'     => 'text',
			'title'    => esc_html__('Default Height', 'solicitor'),
			'subtitle' => esc_html__('Enter default height for the inner pages header. DO NOT PUT px HERE', 'solicitor'),
		),
        array(
			'id'=>'inner_page_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Show page title', 'solicitor'), 
			'subtitle' => esc_html__('Check this box to show page title in the page banner. Uncheck to hide. This can be used as default for all inner pages and can override the individual page design options.', 'solicitor'),
			'default' => '1',
		),
        array(
            'id' => 'inner_page_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title Typography', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => false,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('.page-header h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_page_header_title_color',
            'type'        => 'color',
			'title'       => esc_html__('Page header elements color', 'solicitor'),
			'output'      => array('.page-header h1, .event-counter .timer-col'),
        ),
        array(
            'id' => 'page_title_sec',
            'type' => 'section',
			'indent' => true,
            'title' => esc_html__('Archive Page Titles', 'solicitor'),
        ),
		array(
            'id' => 'event_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for Events Archive', 'solicitor'),
            'subtitle' => esc_html__('Enter title of the archive page for the Events post type.', 'solicitor'),
            'default' => 'Events'
        ),
		array(
            'id' => 'blog_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for Blog Archive', 'solicitor'),
            'subtitle' => esc_html__('Enter title of the archive page for the Blog post type.', 'solicitor'),
            'default' => 'Blog'
        ),
		array(
            'id' => 'service_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for Services Archive', 'solicitor'),
            'subtitle' => esc_html__('Enter title of the archive page for the Services post type.', 'solicitor'),
            'default' => 'Services'
        ),
		array(
            'id' => 'team_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for Team Archive', 'solicitor'),
            'subtitle' => esc_html__('Enter title of the archive page for the Team post type.', 'solicitor'),
            'default' => 'Team'
        ),
		array(
            'id' => 'shop_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for Shop Archive', 'solicitor'),
            'subtitle' => esc_html__('Enter title of the archive page for the Products/Shop post type.', 'solicitor'),
            'default' => 'Shop'
        ),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-upload',
    'title' => esc_html__('Logo', 'solicitor'),
    'desc' => esc_html__('These are the options for the header.', 'solicitor'),
    'fields' => array(
        array(
            'id' => 'logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Logo', 'solicitor'),
            'subtitle' => esc_html__('Upload site logo to display in header.', 'solicitor'),
            'default' => array('url' => $default_logo),
        ),
        array(
            'id' => 'retina_logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Logo for Retina Devices', 'solicitor'),
            'desc' => esc_html__('Retina Display is a marketing term developed by Apple to refer to devices and monitors that have a resolution and pixel density so high &minus; roughly 300 or more pixels per inch', 'solicitor'),
            'subtitle' => esc_html__('Upload site logo to display in header.', 'solicitor'),
            'default' => array('url' => $defaultRetinaLogo),
        ),
		array(
            'id' => 'retina_logo_width',
            'type' => 'text',
            'title' => esc_html__('Standard Logo Width for Retina Logo', 'solicitor'),
            'subtitle' => esc_html__('If retina logo is uploaded, enter the standard logo (1x) version width, do not enter the retina logo width.', 'solicitor'),
            'default' => '164'
        ),
		array(
            'id' => 'retina_logo_height',
            'type' => 'text',
            'title' => esc_html__('Standard Logo Height for Retina Logo', 'solicitor'),
            'subtitle' => esc_html__('If retina logo is uploaded, enter the standard logo (1x) version height, do not enter the retina logo height.', 'solicitor'),
            'default' => '45'
        ),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Admin Logo', 'solicitor'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'custom_admin_login_logo',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Custom admin login logo', 'solicitor'),
            'compiler' => 'true',
            'desc' => esc_html__('Upload a 254 x 95px image here to replace the WP admin login screen logo.', 'solicitor'),
            'subtitle' => esc_html__('', 'solicitor'),
            'default' => array('url' => $defaultAdminlogo),
        )
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-lines',
    'title' => esc_html__('Menu', 'solicitor'),
    'desc' => esc_html__('These are the options for the menu.', 'solicitor'),
    'fields' => array(
        array(
            'id' => 'nav_directions_arrows',
            'type' => 'checkbox',
            'title' => esc_html__('Direction arrows with menu label', 'solicitor'),
            'subtitle' => esc_html__('Uncheck to disable arrows that appear with menu text which is having dropdown. Check to enable.', 'solicitor'),
            "default" => 1,
        ),
		array(
			'id'       => 'main_nav_link_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => false,
			'line-height' => false,
			'text-align' => false,
			'title'    => esc_html__('Main Navigation Links Typography', 'solicitor'),
			'output'   => array('.dd-menu > li > a')
		),
		array(
			'id'       => 'main_nav_link',
			'type'     => 'link_color',
			'title'    => esc_html__('Main Navigation Link Color', 'solicitor'),
			'desc'     => esc_html__('Set the Main Navigation links color, hover, active.', 'solicitor'),
			'output'   => array('.dd-menu > li > a, .header-style2 .dd-menu > li > a'),
		),
		array(
            'id' => 'dd_background',
            'type' => 'background',
			'background-image' => false,
			'background-repeat' => false,
			'background-size' => false,
			'background-position' => false,
			'background-attachment' => false,
			'preview' => false,
			'transparent' => false,
			'output' => array('.dd-menu > li ul, .header-style2 .dd-menu > li ul'),
            'title' => esc_html__('Background color for dropdown menus', 'solicitor'),
            'desc' => esc_html__('Background color set for the dropdowns of main navigation.', 'solicitor'),
        ),
		array(
			'id'       => 'dd_item_border',
			'type'     => 'border',
			'title'    => esc_html__('Dropdown links border bottom', 'solicitor'),
			'output'   => array('.dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a, .dd-menu > li > ul > li > ul > ul > li > a'),
			'top' 	   => false,
			'left' 	   => false,
			'right' 	   => false,
			'bottom' 	=> true
		),
		array(
			'id'       => 'dd_item_spacing',
			'type'     => 'spacing',
			'title'    => esc_html__('Dropdown links spacing', 'solicitor'),
			'output'   => array('.dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a, .dd-menu > li > ul > li > ul > ul > li > a'),
			'mode' 	   => 'padding',
			'units'    => array('px'),
		),
		array(
            'id' => 'dd_item_background',
            'type' => 'background',
			'background-image' => false,
			'background-repeat' => false,
			'background-size' => false,
			'background-position' => false,
			'background-attachment' => false,
			'preview' => false,
			'transparent' => false,
			'output' => array('.dd-menu > li > ul > li > a:hover, .dd-menu > li > ul > li > ul > li > a:hover'),
            'title' => esc_html__('Background color for dropdown menus links hover', 'solicitor'),
        ),
		array(
			'id'       => 'dd_item_link_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => false,
			'line-height' => false,
			'text-align' => false,
			'title'    => esc_html__('Dropdown Menu Links Typography', 'solicitor'),
			'output'   => array('.dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a, .dd-menu > li > ul > li > ul > ul > li > a')
		),
		array(
			'id'       => 'dd_item_link_color',
			'type'     => 'link_color',
			'title'    => esc_html__('Dropdown links color', 'solicitor'),
			'output'   => array('.dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a, .dd-menu > li > ul > li > ul > ul > li > a, .header-style2 .dd-menu > li > ul > li > a, .header-style2 .dd-menu > li > ul > li > ul > li > a, .header-style2 .dd-menu > li > ul > li > ul > ul > li > a, .header-style2 .dd-menu .megamenu-container ul li a')
		),
		array(
            'id' => 'mm_background',
            'type' => 'background',
			'background-image' => false,
			'background-repeat' => false,
			'background-size' => false,
			'background-position' => false,
			'background-attachment' => false,
			'preview' => false,
			'transparent' => false,
			'output' => array('.dd-menu > li.megamenu > ul, .header-style2 .dd-menu > li.megamenu ul'),
            'title' => esc_html__('Megamenu Background color', 'solicitor'),
        ),
		array(
			'id'       => 'mm_title_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'title'    => esc_html__('Megamenu Column Title Typography', 'solicitor'),
			'output'   => array('.dd-menu .megamenu-container .megamenu-sub-title, .dd-menu .megamenu-container .widget .widgettitle, .dd-menu .megamenu-container .widget .widget-title, .header-style2 .dd-menu .megamenu-container .megamenu-sub-title, .header-style2 .dd-menu .megamenu-container .widget .widgettitle, .header-style2 .dd-menu .megamenu-container .widget .widget-title')
		),
		array(
			'id'       => 'mm_content_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'title'    => esc_html__('Megamenu Content Typography', 'solicitor'),
			'output'   => array('.dd-menu .megamenu-container')
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Mobile Menu', 'solicitor'),
	'subsection' => true,
    'fields' => array(
		array(
			'id'       => 'menu_toggle_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'font-family' => true,
			'font-weight' => true,
			'font-style' => true,
			'line-height'=> false,
			'color' => false,
			'text-align' => false,
			'preview' => false,
			'title'    => esc_html__('Mobile Menu opener button typography', 'solicitor'),
			'output'   => array('#menu-toggle'),
		),
		array(
			'id'       => 'menu_toggle_bg_color',
			'type'     => 'background',
			'background-image' => false,
			'background-repeat' => false,
			'background-size' => false,
			'background-attachment' => false,
			'background-position' => false,
			'preview' => false,
			'title'    => esc_html__('Mobile Menu opener button bg color', 'solicitor'),
			'output'   => array('#menu-toggle')
		),
		array(
			'id'       => 'menu_toggle_color',
			'type'     => 'link_color',
			'title'    => esc_html__('Mobile Menu opener button color', 'solicitor'),
			'output'   => array('#menu-toggle')
		),
		array(
			'id'       => 'mobile_menu_drop_top_position',
			'type'     => 'text',
			'title'    => esc_html__('Mobile Menu space from top', 'solicitor'),
			'desc'    => esc_html__('DO NOT PUT px HERE.', 'solicitor'),
		),
		array(
            'id' => 'mobile_menu_background',
            'type' => 'background',
			'background-image' => false,
			'background-repeat' => false,
			'background-size' => false,
			'background-position' => false,
			'background-attachment' => false,
			'preview' => false,
			'transparent' => false,
            'title' => esc_html__('Background color for mobile menu', 'solicitor'),
            'desc' => esc_html__('Background color set for the mobile navigation.', 'solicitor'),
        ),
		array(
			'id'       => 'mobile_menu_color',
			'type'     => 'link_color',
			'title'    => esc_html__('Mobile Menu links color', 'solicitor'),
		),
		array(
			'id'       => 'mobile_menu_border',
			'type'     => 'border',
			'all'	   => false,
			'title'    => esc_html__('Mobile Menu links border bottom', 'solicitor'),
			'top' 	   => false,
			'left' 	   => false,
			'right' 	   => false,
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-chevron-down',
    'title' => esc_html__('Footer', 'solicitor'),
    'desc' => esc_html__('These are the options for the footer.', 'solicitor'),
    'fields' => array(
        array(
            'id' => 'full_width_footer',
            'type' => 'checkbox',
            'title' => esc_html__('100% Footer Width', 'solicitor'),
            'subtitle' => esc_html__('Check this box to set footer width to 100% of the browser width. Uncheck to follow site width. Only works with wide layout mode.', 'solicitor'),
            "default" => 0,
        ),
		array(  'id' => 'footer_background',
				'type' => 'background',
				'background-color'=> true,
				'output' => array('.footer-widgets-area'),
				'title' => esc_html__('Footer Background', 'solicitor'),
    			'subtitle' => esc_html__('Background color or image for the footer.', 'solicitor'),
		),
		array(
			'id'       => 'footer_top_spacing',
			'type'     => 'spacing',
			'left' => false,
			'right' => false,
			'title'    => esc_html__('Footer Top/Bottom padding', 'solicitor'),
            'desc' => esc_html__('Enter top and bottom spacing for the footer. DO NOT ENTER px HERE.', 'solicitor'),
			'mode' 	   => 'padding',
			'output' => array('.footer-widgets-area'),
			'units'    => array('px'),
		),
        array(
			'id'          => 'tfooter_border',
			'type'        => 'border',
			'title'       => esc_html__('Footer border top', 'solicitor'),
			'left' => false,
			'right' => false,
			'bottom' => false,
			'top' => true,
			'output'      => array('.footer-widgets-area'),
		),
        array(
            'id' => 'footer_top_sec',
            'type' => 'section',
			'indent' => true,
            'title' => esc_html__('Footer Widgets Area', 'solicitor'),
        ),
		array(
    		'id' => 'footer_layout',
    		'type' => 'image_select',
    		'compiler'=>true,
			'title' => esc_html__('Footer Layout', 'solicitor'), 
			'subtitle' => esc_html__('Select the footer widgeted area layout', 'solicitor'),
    			'options' => array(
					'12' => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-1.png'),
    				'6' => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-2.png'),
    				'4' => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-3.png'),
    				'3' => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-4.png'),
					'2' => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-5.png'),
    							),
    		'default' => '4'
    	),
        array(
			'id'          => 'widgettitle_typo',
			'type'        => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'title'       => esc_html__('Footer widgets title typography', 'solicitor'),
			'output'      => array('.footer_widget h4.widgettitle, .footer_widget h4.widget-title'),
		),
        array(
			'id'          => 'tfwidget_typo',
			'type'        => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'title'       => esc_html__('Footer widgets area text typography', 'solicitor'),
			'output'      => array('.site-footer .footer_widget'),
		),
        array(
			'id'          => 'tfooter_link_color',
			'type'        => 'link_color',
			'title'       => esc_html__('Footer widgets area links color', 'solicitor'),
			'output'      => array('.body .footer-widgets-area .footer_widget a'),
		),
        array(
            'id' => 'footer_bottom_sec',
            'type' => 'section',
			'indent' => true,
            'title' => esc_html__('Footer Copyrights Area', 'solicitor'),
        ),
        array(
            'id' => 'footer_bottom_enable',
            'type' => 'checkbox',
            'title' => esc_html__('Enable Footer copyrights area', 'solicitor'),
            'desc' => esc_html__('Uncheck to disable footer copyrights area that comes below the footer widgets area.', 'solicitor'),
			'default' => 1
        ),
        array(
            'id' => 'footer_copyright_text',
            'type' => 'text',
            'title' => esc_html__('Footer Copyright Text', 'solicitor'),
            'subtitle' => esc_html__(' Enter Copyright Text', 'solicitor'),
            'default' => esc_html__('All Rights Reserved', 'solicitor')
        ),
		array(
			'id' => 'footer_social_links',
			'type' => 'sortable',
			'label' => true,
			'compiler'=>true,
			'title' => esc_html__('Social Links', 'solicitor'),
			'desc' => esc_html__('Insert Social URL in their respective fields and sort as your desired order.', 'solicitor'),
			'options' => array(
				'fa-facebook' => 'facebook',
				'fa-twitter' => 'twitter',
				'fa-pinterest' => 'pinterest',
				'fa-google-plus' => 'google',
				'fa-youtube' => 'youtube',
				'fa-instagram' => 'instagram',
				'fa-vimeo-square' => 'vimeo',
				'fa-rss' => 'rss',
				'fa-dribbble' => 'dribbble',
				'fa-dropbox' => 'dropbox',
				'fa-bitbucket' => 'bitbucket',
				'fa-flickr' => 'flickr',
				'fa-foursquare' => 'foursquare',
				'fa-github' => 'github',
				'fa-gittip' => 'gittip',
				'fa-linkedin' => 'linkedin',
				'fa-pagelines' => 'pagelines',
				'fa-skype' => 'Enter Skype ID',
				'fa-tumblr' => 'tumblr',
				'fa-vk' => 'vk',
				'fa-envelope' => 'Enter Email Address'
			),
		),
        array(
            'id' => 'footer_logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Footer Logo', 'solicitor'),
            'subtitle' => esc_html__('Upload footer logo to display in footer.', 'solicitor'),
            'default' => array('url' => $footer_logo),
        ),	
		),	
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-lines',
    'title' => esc_html__('Sidebars', 'solicitor'),
    'fields' => array(
        array(
    		'id' => 'sidebar_position',
    		'type' => 'image_select',
    		'compiler'=>true,
			'title' => esc_html__('Sidebar position','solicitor'), 
			'subtitle' => esc_html__('Select the Global Sidebar Position. Can be overridden by page sidebar settings.', 'solicitor'),
    			'options' => array(
    				'2' => array('title' => 'Left', 'img' => ReduxFramework::$_url.'assets/img/2cl.png'),
					'1' => array('title' => 'Right', 'img' => ReduxFramework::$_url.'assets/img/2cr.png')
    				),
    		'default' => '1'
    	),
		array(
			'id'       => 'post_single_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Default single post Sidebar', 'solicitor'), 
			'desc'     => esc_html__('Select default sidebar for single page of Posts. Leave blank for no sidebar. This can be override from each post sidebar option.', 'solicitor'),
			'data'  => 'sidebars',
			'default'  => 'post-sidebar',
		),
		array(
			'id'       => 'page_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Default Page Sidebar', 'solicitor'), 
			'desc'     => esc_html__('Select default sidebar for pages. Leave blank for no sidebar. This can be override from each post sidebar option.', 'solicitor'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'post_category_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Post Archive Sidebar', 'solicitor'), 
			'desc'     => esc_html__('Select sidebar for archive page of Posts.', 'solicitor'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'search_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Search Page Sidebar', 'solicitor'), 
			'desc'     => esc_html__('Select sidebar for search page.', 'solicitor'),
			'data'  => 'sidebars',
			'default'  => 'post-sidebar',
		),
		array(
			'id'       => 'services_single_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Default services post Sidebar', 'solicitor'), 
			'desc'     => esc_html__('Select default sidebar for single page of Services. Leave blank for no sidebar. This can be override from each post sidebar option.', 'solicitor'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'events_single_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Default events post Sidebar', 'solicitor'), 
			'desc'     => esc_html__('Select default sidebar for single page of Events. Leave blank for no sidebar. This can be override from each post sidebar option.', 'solicitor'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'team_single_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Default team post Sidebar', 'solicitor'), 
			'desc'     => esc_html__('Select default sidebar for single page of Team. Leave blank for no sidebar. This can be override from each post sidebar option.', 'solicitor'),
			'data'  => 'sidebars',
			'default'  => 'page-sidebar',
		),
		array(
			'id'       => 'shop_term_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Shop Archive Sidebar', 'solicitor'), 
			'desc'     => esc_html__('Select sidebar for archive page of Shop.', 'solicitor'),
			'data'  => 'sidebars',
			'default'  => 'page-sidebar',
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-brush',
    'title' => esc_html__('Color Scheme', 'solicitor'),
    'fields' => array(
		 array(
			'id'=>'theme_color_type',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Color Scheme', 'solicitor'), 
			'subtitle' => esc_html__('Select the global color scheme type', 'solicitor'),
			'options' => array(
					'0' => esc_html__('Pre-Defined Color Schemes','solicitor'),
					'1' => esc_html__('Custom Color','solicitor')
				),
			'default' => '0',
			),
        array(
            'id' => 'theme_color_scheme',
            'type' => 'select',
			'required' => array('theme_color_type','equals','0'),
            'title' => esc_html__('Predefined Color Schemes', 'solicitor'),
            'subtitle' => esc_html__('Select your themes alternative color scheme.', 'solicitor'),
            'options' => array('color1.css' => 'color1.css', 'color2.css' => 'color2.css', 'color3.css' => 'color3.css', 'color4.css' => 'color4.css', 'color5.css' => 'color5.css', 'color6.css' => 'color6.css', 'color7.css' => 'color7.css', 'color8.css' => 'color8.css', 'color9.css' => 'color9.css', 'color10.css' => 'color10.css','color11.css' => 'color11.css','color12.css' => 'color12.css'),
            'default' => 'color1.css',
        ),	
		array(
			'id'=>'primary_theme_color',
			'type' => 'color',
			'required' => array('theme_color_type','equals','1'),
			'title' => esc_html__('Custom Theme Color', 'solicitor'), 
			'subtitle' => esc_html__('Pick a global custom color for the template.', 'solicitor'),
			'validate' => 'color',
			'transparent' => false,
			),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-font',
    'title' => esc_html__('Typography', 'solicitor'),
    'subtitle' => esc_html__('Global Font Family Sets', 'solicitor'),
	'desc' => esc_html__('These options are as per the design which consists of 3 fonts. For more advanced typography options see Sub Sections below this in Left Sidebar. Make sure you set these options only if you have knowledge about every property to avoid disturbing the whole layout. If something went wrong just reset this section to reset all fields in Typography Options or click the small cross signs in each select field/delete text from input fields to reset them.', 'solicitor'),
    'fields' => array(
        array(
            'id' => 'heading_font_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Heading font', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => false,
			'text-align'	  => false,
            'font-weight' => true,
            'font-style' => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'letter-spacing' => false,
			'output'      => array('h1,h2,h3,h4,h5,h6'),
			'units'       =>'px',
            'subtitle' => esc_html__('Choose font style Headings', 'solicitor'),
            'default' => array(
            	'font-family' => 'Playfair Display',
               ),
        ),
        array(
            'id' => 'body_font_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Body/Primary font', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => false,
			'text-align'	  => false,
            'font-weight' => true,
            'font-style' => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'letter-spacing' => false,
			'output'      => array('body, .dd-menu .megamenu-container .megamenu-sub-title, .featured-block-info .subtitle, .footer_widget h4.widgettitle, .icon-box h3, .widget_solicitor_recent_post ul li h5'),
			'units'       =>'px',
	    	'subtitle' => esc_html__('Choose font style Body text.', 'solicitor'),
            'default' => array(
             	'font-family' => 'Roboto',
             	'font-weight' => '400',
              ),
        ),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('More Options', 'solicitor'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'body_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Body', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('body'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for body text', 'solicitor'),
        ),
        array(
            'id' => 'h1_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H1 Title', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('h1'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H1 title', 'solicitor'),
        ),
        array(
            'id' => 'h2_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H2 Title', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('h2'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H2 title', 'solicitor'),
        ),
        array(
            'id' => 'h3_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H3 Title', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('h3'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H3 title', 'solicitor'),
        ),
        array(
            'id' => 'h4_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H4 Title', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('h4'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H4 title', 'solicitor'),
        ),
        array(
            'id' => 'h5_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H5 Title', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('h5'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H5 title', 'solicitor'),
        ),
        array(
            'id' => 'h6_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H6 Title', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('h6'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H6 title', 'solicitor'),
        ),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Additional Styles', 'solicitor'),
    'desc' => esc_html__('Choose and select font families and styles for Google Fonts that are not loaded with the primary typography options. For example add different weight and style for a same font family you choose for your Typography options above.', 'solicitor'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'nowhere_font1',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 1', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'font-weight' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'output'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Roboto',
				'font-weight' => '700',
               ),
        ),
        array(
            'id' => 'nowhere_font2',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 2', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'output'      => array('.nowhere-font'),
			'units'       =>'px',
        ),
        array(
            'id' => 'nowhere_font3',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 3', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'output'      => array('.nowhere-font'),
			'units'       =>'px',
        ),
        array(
            'id' => 'nowhere_font4',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 4', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'output'      => array('.nowhere-font'),
			'units'       =>'px',
        ),
        array(
            'id' => 'nowhere_font5',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 5', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'output'      => array('.nowhere-font'),
			'units'       =>'px',
        ),
        array(
            'id' => 'nowhere_font6',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 6', 'solicitor'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'output'      => array('.nowhere-font'),
			'units'       =>'px',
        ),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-share',
    'title' => esc_html__('Share Options', 'solicitor'),
    'fields' => array(
        array(
            'id' => 'switch_sharing',
            'type' => 'switch',
            'title' => esc_html__('Social Sharing', 'solicitor'),
            'subtitle' => esc_html__('Enable/Disable theme default social sharing buttons for posts/events/sermons single pages', 'solicitor'	
			),
            "default" => 1,
       		),
		 array(
			'id'=>'sharing_style',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Share Buttons Style', 'solicitor'), 
			'subtitle' => esc_html__('Choose the style of share button icons', 'solicitor'),
			'options' => array(
					'0' => esc_html__('Rounded','solicitor'),
					'1' => esc_html__('Squared','solicitor'),
				),
			'default' => '0',
			),
		 array(
			'id'=>'sharing_color',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Share Buttons Color', 'solicitor'), 
			'subtitle' => esc_html__('Choose the color scheme of the share button icons', 'solicitor'),
			'options' => array(
					'0' => esc_html__('Brand Colors','solicitor'),
					'1' => esc_html__('Theme Color','solicitor'),
					'2' => esc_html__('GrayScale','solicitor')
				),
			'default' => '0',
			),
		array(
			'id'       => 'share_icon',
			'type'     => 'checkbox',
			'required' => array('switch_sharing','equals','1'),
			'title'    => esc_html__('Social share options', 'solicitor'),
			'subtitle' => esc_html__('Click on the buttons to disable/enable share buttons', 'solicitor'),
			'options'  => array(
				'1' => 'Facebook',
				'2' => 'Twitter',
				'3' => 'Google',
				'4' => 'Tumblr',
				'5' => 'Pinterest',
				'6' => 'Reddit',
				'7' => 'Linkedin',
				'8' => 'Email',
				'9' => 'VKontakte',
				'10' => 'Whatsapp'
			),
			'default' => array(
				'1' => '1',
				'2' => '1',
				'3' => '1',
				'4' => '1',
				'5' => '1',
				'6' => '1',
				'7' => '1',
				'8' => '1',
				'9' => '0',
				'10' => '0'
			)
		),
		array(
			'id'       => 'share_post_types',
			'type'     => 'checkbox',
			'required' => array('switch_sharing','equals','1'),
			'title'    => esc_html__('Select share buttons for post types', 'solicitor'),
			'subtitle'     => esc_html__('Uncheck to disable for any type', 'solicitor'),
			'options'  => array(
				'1' => 'Posts',
				'2' => 'Pages',
				'3' => 'Events',
				'4' => 'Services',
				'5' => 'Team',
			),
			'default' => array(
				'1' => 1,
				'2' => 1,
				'3' => 1,
				'4' => 1,
				'5' => 1,
			)
		),
		array(
			'id'       => 'share_links_alt',
			'type'     => 'section',
			'indent' => true,
			'title'    => esc_html__('Sharing links alt/title text', 'solicitor'),
		),
		array(
            'id' => 'facebook_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Facebook share icon', 'solicitor'),
            'subtitle' => esc_html__('Text for the Facebook share icon browser tooltip.', 'solicitor'),
            'default' => 'Share on Facebook'
        ),
		array(
            'id' => 'twitter_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Twitter share icon', 'solicitor'),
            'subtitle' => esc_html__('Text for the Twitter share icon browser tooltip.', 'solicitor'),
            'default' => 'Tweet'
        ),
		array(
            'id' => 'google_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Google Plus share icon', 'solicitor'),
            'subtitle' => esc_html__('Text for the Google Plus share icon browser tooltip.', 'solicitor'),
            'default' => 'Share on Google+'
        ),
		array(
            'id' => 'tumblr_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Tumblr share icon', 'solicitor'),
            'subtitle' => esc_html__('Text for the Tumblr share icon browser tooltip.', 'solicitor'),
            'default' => 'Post to Tumblr'
        ),
		array(
            'id' => 'pinterest_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Pinterest share icon', 'solicitor'),
            'subtitle' => esc_html__('Text for the Pinterest share icon browser tooltip.', 'solicitor'),
            'default' => 'Pin it'
        ),
		array(
            'id' => 'reddit_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Reddit share icon', 'solicitor'),
            'subtitle' => esc_html__('Text for the Reddit share icon browser tooltip.', 'solicitor'),
            'default' => 'Submit to Reddit'
        ),
		array(
            'id' => 'linkedin_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Linkedin share icon', 'solicitor'),
            'subtitle' => esc_html__('Text for the Linkedin share icon browser tooltip.', 'solicitor'),
            'default' => 'Share on Linkedin'
        ),
		array(
            'id' => 'email_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Email share icon', 'solicitor'),
            'subtitle' => esc_html__('Text for the Email share icon browser tooltip.', 'solicitor'),
            'default' => 'Email'
        ),
		array(
            'id' => 'vk_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for vk share icon', 'solicitor'),
            'subtitle' => esc_html__('Text for the vk share icon browser tooltip.', 'solicitor'),
            'default' => 'Share on vk'
        ),
		array(
            'id' => 'whatsapp_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for whatsapp share icon', 'solicitor'),
            'subtitle' => esc_html__('Text for the whatsapp share icon browser tooltip.', 'solicitor'),
            'default' => 'Share on whatsapp'
        ),
		array(
			'id'       => 'share_before_icon',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show sharing icon before the sharing icons', 'solicitor'),
			'default' => 0
		),
		array(
			'id'       => 'share_before_text',
			'type'     => 'text',
			'title'    => esc_html__('Enter title to show before the sharing icons', 'solicitor'),
			'default' => 'Share'
		),
		array(
			'id'       => 'share_before_typo',
			'type'     => 'typography',
			'title'    => esc_html__('Share before text/icon typography', 'solicitor'),
			'output'   => array('.social-share-bar .share-title'),
			'default' => array(
				'line-height' => '30px'
			)
		),
		array(
			'id'       => 'share_icons_box_size',
			'type'     => 'dimensions',
			'title'    => esc_html__('Share icons box size', 'solicitor'),
			'output'   => array('.social-share-bar.social-icons-colored li a'),
			'default' => array(
				'height' => '30px',
				'width' => '30px'
			)
		),
		array(
			'id'       => 'share_icons_font_size',
			'type'     => 'typography',
			'title'    => esc_html__('Share icons font size', 'solicitor'),
			'desc'    => esc_html__('Keep line height same as height of icon boxes set above', 'solicitor'),
			'font-weight' => false,
			'font-family' => false,
			'font-style' => false,
			'text-align' => false,
			'preview' => false,
			'color' => false,
			'output'   => array('.social-share-bar.social-icons-colored li a'),
			'default' => array(
				'line-height' => '30px',
				'font-size' => '16px'
			)
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-folder',
	'id'   => 'post-types',
    'title' => esc_html__('Custom Post Types', 'solicitor'),
    'fields' => array(
		array(
			'id'    => 'info_post_types',
			'type'  => 'info',
			'title' => esc_html__('Sub sections here for each post type will help you change the permalinks slug for each post type. Also would be able to change the Title, Category, Tag title for menu on the left sidebar of WP Dashboard.', 'solicitor'),
			'style' => 'warning',
			'desc'  => esc_html__('Make sure you go to Settings > Permalinks page once you make any change to any post type here to flush the permalinks structure cache. You just need to go to that permalinks page, no need to save the options.', 'solicitor')
		),
		array(
			'id'    => 'info_post_types_slug',
			'type'  => 'info',
			'title' => esc_html__('If the slug is identical to an existing page WP will display the cpt posts as blog posts, not with their own style. (unless you can work your php magic and get around this issue).', 'solicitor'),
			'style' => 'critical',
		),
		
		
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Event', 'solicitor'),
    'desc' => esc_html__('From here you can change the slug for event post types, along with title of the post types, taxonomies that displays on the left sidebar of WP Dashboard', 'solicitor'),
    'fields' => array(
		array(
			'id'    => 'info_post_event',
			'type'  => 'info',
			'title' => esc_html__('Make sure you go to Settings > Permalinks page once you make any change here in order to flush the permalinks structure cache. You just need to go to that permalinks page, no need to save the options.', 'solicitor'),
			'style' => 'warning',
		),
		array(
            'id' => 'event_post_slug',
            'type' => 'text',
            'title' => esc_html__('Events permalink slug', 'solicitor'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'solicitor'),
        ),
		array(
            'id' => 'event_post_title',
            'type' => 'text',
            'title' => esc_html__('Events menu name', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
            'id' => 'event_post_all',
            'type' => 'text',
            'title' => esc_html__('Events all posts title', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
            'id' => 'event_post_categories',
            'type' => 'text',
            'title' => esc_html__('Events categories title', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
            'id' => 'event_category_slug',
            'type' => 'text',
            'title' => esc_html__('Event Category permalink slug', 'solicitor'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'solicitor'),
        ),
		array(
            'id' => 'event_post_registerants',
            'type' => 'text',
            'title' => esc_html__('Events registrants title', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
			'id'       => 'disable_event_archive',
			'type'     => 'checkbox',
			'title'    => esc_html__('Disable Event post type archive page.', 'solicitor'),
            'desc' => esc_html__('By default WordPress create a page for all post types which makes it impossible for you to create a new page with the same slug as of custom post type. Check this to disable the default cpt page.', 'solicitor'),
			'default' => 0
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Service', 'solicitor'),
    'desc' => esc_html__('From here you can change the slug for service post types, along with title of the post types, taxonomies that displays on the left sidebar of WP Dashboard', 'solicitor'),
    'fields' => array(
		array(
			'id'    => 'info_post_service',
			'type'  => 'info',
			'title' => esc_html__('Make sure you go to Settings > Permalinks page once you make any change here in order to flush the permalinks structure cache. You just need to go to that permalinks page, no need to save the options.', 'solicitor'),
			'style' => 'warning',
		),
		array(
            'id' => 'service_post_slug',
            'type' => 'text',
            'title' => esc_html__('Services permalink slug', 'solicitor'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'solicitor'),
        ),
		array(
            'id' => 'service_post_title',
            'type' => 'text',
            'title' => esc_html__('Services menu name', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
            'id' => 'service_post_all',
            'type' => 'text',
            'title' => esc_html__('Service all posts title', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
            'id' => 'service_post_categories',
            'type' => 'text',
            'title' => esc_html__('Service categories title', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
            'id' => 'service_category_slug',
            'type' => 'text',
            'title' => esc_html__('Service Category permalink slug', 'solicitor'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'solicitor'),
        ),
		array(
			'id'       => 'disable_service_archive',
			'type'     => 'checkbox',
			'title'    => esc_html__('Disable Service post type archive page.', 'solicitor'),
            'desc' => esc_html__('By default WordPress create a page for all post types which makes it impossible for you to create a new page with the same slug as of custom post type. Check this to disable the default cpt page.', 'solicitor'),
			'default' => 0
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Team', 'solicitor'),
    'desc' => esc_html__('From here you can change the slug for team post types, along with title of the post types, taxonomies that displays on the left sidebar of WP Dashboard', 'solicitor'),
    'fields' => array(
		array(
			'id'    => 'info_post_team',
			'type'  => 'info',
			'title' => esc_html__('Make sure you go to Settings > Permalinks page once you make any change here in order to flush the permalinks structure cache. You just need to go to that permalinks page, no need to save the options.', 'solicitor'),
			'style' => 'warning',
		),
		array(
            'id' => 'team_post_slug',
            'type' => 'text',
            'title' => esc_html__('Team permalink slug', 'solicitor'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'solicitor'),
        ),
		array(
            'id' => 'team_post_title',
            'type' => 'text',
            'title' => esc_html__('Team menu name', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
            'id' => 'team_post_all',
            'type' => 'text',
            'title' => esc_html__('Team all posts title', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
            'id' => 'team_post_categories',
            'type' => 'text',
            'title' => esc_html__('Team categories title', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
            'id' => 'team_category_slug',
            'type' => 'text',
            'title' => esc_html__('Team Category permalink slug', 'solicitor'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'solicitor'),
        ),
		array(
			'id'       => 'disable_team_archive',
			'type'     => 'checkbox',
			'title'    => esc_html__('Disable Team post type archive page.', 'solicitor'),
            'desc' => esc_html__('By default WordPress create a page for all post types which makes it impossible for you to create a new page with the same slug as of custom post type. Check this to disable the default cpt page.', 'solicitor'),
			'default' => 0
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Testimonial', 'solicitor'),
    'desc' => esc_html__('From here you can change the slug for testimonial post types, along with title of the post types, taxonomies that displays on the left sidebar of WP Dashboard', 'solicitor'),
    'fields' => array(
		array(
			'id'    => 'info_post_testimonial',
			'type'  => 'info',
			'title' => esc_html__('Make sure you go to Settings > Permalinks page once you make any change here in order to flush the permalinks structure cache. You just need to go to that permalinks page, no need to save the options.', 'solicitor'),
			'style' => 'warning',
		),
		array(
            'id' => 'testimonial_post_slug',
            'type' => 'text',
            'title' => esc_html__('Testimonials permalink slug', 'solicitor'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'solicitor'),
        ),
		array(
            'id' => 'testimonial_post_title',
            'type' => 'text',
            'title' => esc_html__('Testimonials menu name', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
            'id' => 'testimonial_post_all',
            'type' => 'text',
            'title' => esc_html__('Testimonial all posts title', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
            'id' => 'testimonial_post_categories',
            'type' => 'text',
            'title' => esc_html__('Testimonial categories title', 'solicitor'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'solicitor'),
        ),
		array(
            'id' => 'testimonial_category_slug',
            'type' => 'text',
            'title' => esc_html__('Testimonial Category permalink slug', 'solicitor'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'solicitor'),
        ),
		array(
			'id'       => 'disable_testimonial_archive',
			'type'     => 'checkbox',
			'title'    => esc_html__('Disable Testimonial post type archive page.', 'solicitor'),
            'desc' => esc_html__('By default WordPress create a page for all post types which makes it impossible for you to create a new page with the same slug as of custom post type. Check this to disable the default cpt page.', 'solicitor'),
			'default' => 0
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-calendar',
	'id'   => 'Events',
    'title' => esc_html__('Events', 'solicitor'),
    'fields' => array(
		array(
            'id' => 'countdown_timer',
            'type' => 'select',
            'title' => esc_html__('Events Display Time', 'solicitor'),
            'subtitle' => esc_html__('Select till what time events will be displayed on the site: End Time/Start Time', 'solicitor'),
            'options' => array('0' => 'Start Time', '1' => 'End Time'),
            'default' => '0',
        ),
		array(
            'id' => 'event_meta_date',
            'type' => 'select',
            'title' => esc_html__('Events date and time', 'solicitor'),
            'subtitle' => esc_html__('Show event date meta details', 'solicitor'),
            'options' => array('0' => 'Start Time and End Time', '1' => 'Start Time'),
            'default' => '0',
        ),
		array(
            'id' => 'event_multi_separator',
            'type' => 'text',
            'title' => esc_html__('Text/Separator to show before time of event.', 'solicitor'),
            'subtitle' => esc_html__('This will show just before the time of the event in listing and on single event page.', 'solicitor'),
			'desc' => esc_html__('Any icon can also be added here with code: <i class="fa fa-clock-o"></i>. Get more icon classes from http://fontawesome.io/cheatsheet/','solicitor'),
            'default' => ' - ',
        ),
		array(
            'id' => 'multi_date_separator',
            'type' => 'text',
            'title' => esc_html__('Separator for multiple date events.', 'solicitor'),
            'subtitle' => esc_html__('This will show up between the multiple dates on event listing and single event page.', 'solicitor'),
			'desc' => esc_html__('Any icon can also be added here with code: <i class="fa fa-clock-o"></i>. Get more icon classes from http://fontawesome.io/cheatsheet/','solicitor'),
            'default' => ' - ',
        ),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-credit-card',
    'icon_class' => 'icon-large',
    'title' => esc_html__('Paypal Configuration', 'solicitor'),
	'desc' => esc_html__('These settings are for the event tickets payment.', 'solicitor'),
    'fields' => array(
		array(
			'id'       => 'paypal_email',
			'type'     => 'text',
			'title'    => esc_html__('Paypal Email Address', 'solicitor'), 
			'desc'     => esc_html__('Enter Paypal Business Email Address, where you want to receive payments for the event tickets registration.', 'solicitor'),
			'default'  => '',
		),
		array(
			'id'       => 'paypal_token',
			'type'     => 'text',
			'title'    => esc_html__('Paypal Token', 'solicitor'), 
			'desc'     => esc_html__('Enter Paypal Token ID.', 'solicitor'),
			'default'  => '',
		),
		array(
            'id' => 'paypal_site',
            'type' => 'select',
            'title' => esc_html__('Paypal Site', 'solicitor'),
            'subtitle' => esc_html__('Select paypal site.', 'solicitor'),
            'options' => array('0' => 'Sandbox', '1' => 'Live'),
            'default' => '1',
        ),	
		array(
            'id' => 'paypal_currency',
            'type' => 'select',
            'title' => esc_html__('Payment Currency', 'solicitor'),
            'subtitle' => esc_html__('Select payment currency.', 'solicitor'),
            'options' => array('USD' => 'U.S. Dollar', 'AUD' => 'Australian Dollar', 'BRL' => 'Brazilian Real', 'CAD' => 'Canadian Dollar', 'CZK' => 'Czech Koruna', 'DKK' => 'Danish Krone', 'EUR' => 'Euro', 'HKD' => 'Hong Kong Dollar', 'HUF' => 'Hungarian Forint', 'ILS' => 'Israeli New Sheqel', 'JPY' => 'Japanese Yen', 'MYR' => 'Malaysian Ringgit', 'MXN' => 'Mexican Peso', 'NOK' => 'Norwegian Krone', 'NZD' => 'New Zealand Dollar', 'PHP' => 'Philippine Peso', 'PLN' => 'Polish Zloty', 'GBP' => 'Pound Sterling', 'SGD' => 'Singapore Dollar', 'SEK' => 'Swedish Krona', 'CHF' => 'Swiss Franc', 'TWD' => 'Taiwan New Dollar', 'THB' => 'Thai Baht', 'TRY' => 'Turkish Lira'),
            'default' => 'USD',
        ),	
    )
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-calendar-sign',
    'title' => esc_html__('Calendar', 'solicitor'),
    'fields' => array(
		array(
			'id'=>'calendar_header_view',
			'type' => 'image_select',
			'compiler'=>true,
			'title' => esc_html__('Calendar Header View','solicitor'), 
			'subtitle' => esc_html__('Select the view for your calendar header', 'solicitor'),
				'options' => array(
					1 => array('title' => '', 'img' => get_template_directory_uri().'/images/calendarheaderLayout/header-1.jpg'),
					2 => array('title' => '', 'img' => get_template_directory_uri().'/images/calendarheaderLayout/header-2.jpg'),
					),
			'default' => 1
		),
		array(
            'id' => 'calendar_event_limit',
            'type' => 'text',	
            'title' => esc_html__('Limit of Events', 'solicitor'),
            'desc' => esc_html__('Enter a number to limit number of events to show maximum in a single day block of calendar and remaining in a small popover(Default is 4)', 'solicitor'),
			'default' => '4',
        ),
		 array(
			'id'=>'default_calendar_view',
			'type' => 'radio',
			'title' => esc_html__('Default Calendar View', 'solicitor'), 
			'subtitle' => esc_html__('Choose default view of your events calendar', 'solicitor'),
			'options' => array(
					'month' => esc_html__('Month','solicitor'),
					'basicWeek' => esc_html__('Basic Week','solicitor'),
					'basicDay' => esc_html__('Basic Day','solicitor'),
					'agendaWeek' => esc_html__('Agenda Week','solicitor'),
					'agendaDay' => esc_html__('Agenda Day','solicitor')
				),
			'default' => 'month',
			),
		array(
            'id' => 'calendar_today',

            'type' => 'text',	
            'title' => esc_html__('Heading Today', 'solicitor'),
            'desc' => esc_html__('Translate Calendar Heading for Today Button', 'solicitor'),
			'default' => 'Today',
        ),
		array(
            'id' => 'calendar_month',
            'type' => 'text',	
            'title' => esc_html__('Heading Month', 'solicitor'),
            'desc' => esc_html__('Translate Calendar Heading for Month Button', 'solicitor'),
			'default' => 'Month',
        ),
		array(
            'id' => 'calendar_week',
            'type' => 'text',	
            'title' => esc_html__('Heading Week', 'solicitor'),
            'desc' => esc_html__('Translate Calendar Heading for Week Button', 'solicitor'),
			'default' => 'Week',
        ),
		array(
            'id' => 'calendar_day',
            'type' => 'text',	
            'title' => esc_html__('Heading Day', 'solicitor'),
            'desc' => esc_html__('Translate Calendar Heading for Day Button', 'solicitor'),
			'default' => 'Day',
        ),
        array(
            'id' => 'calendar_month_name',
            'type' => 'textarea',	
			'rows' => 2,
            'title' => esc_html__('Calendar Month Name', 'solicitor'),
            'desc' => esc_html__('Insert month name in local language by comma seperated to display on event calender like: January,February,March,April,May,June,July,August,September,October,November,December', 'solicitor'),
			'default' => 'January,February,March,April,May,June,July,August,September,October,November,December',
        ),
		array(
            'id' => 'calendar_month_name_short',
            'type' => 'textarea',	
			'rows' => 2,
            'title' => esc_html__('Calendar Month Name Short', 'solicitor'),
            'desc' => esc_html__('Insert month name short in local language by comma seperated to display on event calender like: Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec', 'solicitor'),
			'default' => 'Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec',
        ),
		array(
            'id' => 'calendar_day_name',
            'type' => 'textarea',	
			'rows' => 2,
            'title' => esc_html__('Calendar Day Name', 'solicitor'),
            'desc' => esc_html__('Insert day name in local language by comma seperated to display on event calender like: Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday', 'solicitor'),
			'default' => 'Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday',
        ),
		array(
            'id' => 'calendar_day_name_short',
            'type' => 'textarea',
			'rows' => 2,	
            'title' => esc_html__('Calendar Day Name Short', 'solicitor'),
            'desc' => esc_html__('Insert day name short in local language by comma seperated to display on event calender like: Sun,Mon,Tue,Wed,Thu,Fri,Sat', 'solicitor'),
			'default' => 'Sun,Mon,Tue,Wed,Thu,Fri,Sat',
        ),
		array(
    'id'       => 'event_feeds',
    'type'     => 'checkbox',
    'title'    => esc_html__('Show WP Events', 'solicitor'),
    'desc'     => esc_html__('Check if you wants to show WP Events in Calendar.', 'solicitor'),
    'default'  => '1'// 1 = on | 0 = off
),
		array(
            'id' => 'google_feed_key',
            'type' => 'text',	
            'title' => esc_html__('Google Calendar API Key', 'solicitor'),
            'desc' => esc_html__('Enter Google Calendar Feed API Key.', 'solicitor'),
			'default' => '',
        ),
		array(
            'id' => 'google_feed_id',
            'type' => 'text',	
            'title' => esc_html__('Google Calendar ID', 'solicitor'),
            'desc' => esc_html__('Enter Google Calendar ID.', 'solicitor'),
			'default' => '',
        ),
		array(
			'id'=>'event_default_color',
			'type' => 'color',
			'title' => esc_html__('Event Color', 'solicitor'), 
			'subtitle' => esc_html__('Pick a default color for Events.', 'solicitor'),
			'validate' => 'color',
			'transparent' => false,
			'default' => ''
			),
			array(
			'id'=>'recurring_event_color',
			'type' => 'color',
			'title' => esc_html__('Recurring Event Color', 'solicitor'), 
			'subtitle' => esc_html__('Pick a color for recurring Events.', 'solicitor'),
			'validate' => 'color',
			'transparent' => false,
			'default' => ''
			),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-map-marker',
    'title' => esc_html__('Map API', 'solicitor'),
    'fields' => array(
		array(
			'id'       => 'google_map_api',
			'type'     => 'text',
			'title'    => esc_html__('Google Maps API Key', 'solicitor'), 
			'desc'     => esc_html__('Enter your Google Maps API key in here. This will be used for all maps in the theme i.e. Event maps. <a href="https://support.imithemes.com/forums/topic/how-to-get-google-maps-api/" target="_blank">See Guide about how to get your API Key</a>', 'solicitor'),
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-error',
    'title' => esc_html__('404 Page', 'solicitor'),
    'fields' => array(
		array(
			'id'=>'page_404_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Page header image', 'solicitor'),
			'subtitle' => esc_html__('Upload image to show on the page header of the 404 error page.', 'solicitor'),
            'default' => array('url' => ''),
		),
		array(
			'id'       => 'page_404_banner_height',
			'type'     => 'dimensions',
			'title'    => esc_html__('Page header height', 'solicitor'),
			'output'   => array('.error404 .page-banner-text div'),
			'width' => false,
			'default' => array(
				'height' => '200px',
				'unit' => 'px',
			)
		),
		array(
            'id' => 'page_404_title',
            'type' => 'text',
            'title' => esc_html__('Page title', 'solicitor'),
            'desc' => esc_html__('Enter title for 404 error page. Default is 404 Error.', 'solicitor'),
        ),
		array(
            'id' => 'page_404_title_color',
            'type' => 'color',
			'output' => array('.error404 .page-banner-text h1'),
            'title' => esc_html__('Page title color', 'solicitor'),
        ),
		array(
            'id' => 'page_404_content',
            'type' => 'editor',
            'title' => esc_html__('Page content', 'solicitor'),
            'desc' => esc_html__('Enter text/html content for 404 error page.', 'solicitor'),
        ),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-css',
    'title' => esc_html__('Custom CSS/JS', 'solicitor'),
    'fields' => array(
        array(
            'id' => 'custom_css',
            'type' => 'ace_editor',	
            'title' => esc_html__('CSS Code', 'solicitor'),
            'subtitle' => esc_html__('Paste your CSS code here.', 'solicitor'),
            'mode' => 'css',
            'theme' => 'monokai',
            'desc' => '',
            'default' => "#header{\nmargin: 0 auto;\n}"
        ),
        array(
            'id' => 'custom_js',
            'type' => 'ace_editor',	
            'title' => esc_html__('JS Code', 'solicitor'),
            'subtitle' => esc_html__('Paste your JS code here.', 'solicitor'),
            'mode' => 'javascript',
            'theme' => 'chrome',
            'desc' => '',
            'default' => "jQuery(document).ready(function(){\n\n});"
        )
    ),
));
Redux::setSection( $opt_name, array(
		'title' => esc_html__('Import / Export', 'solicitor'),
		'desc' => esc_html__('Import and Export your Theme Framework settings from file, text or URL.', 'solicitor'),
		'icon' => 'el-icon-download',
		'fields' => array(
			array(
				'id' => 'opt-import-export',
				'type' => 'import_export',
			   'title' => esc_html__('Import Export','solicitor'),
				'subtitle' => esc_html__('Save and restore your Theme options','solicitor'),
				'full_width' => false,
			),
		),
));

    /*
     * <--- END SECTIONS
     */
