<?php 
get_header();
$options = get_option('solicitor_options');
solicitor_sidebar_position_module();
$theme_info = wp_get_theme();
$tickets_type = get_post_meta(get_the_ID(), 'tickets_type', true);
$multiple_tickets = (!empty($tickets_type))?1:'';
$invalid_name = esc_html__('You must enter your name','solicitor');
$invalid_email = esc_html__('You must enter your email','solicitor');
$process = esc_html__('Sending Information to Event Manager...', 'solicitor');
$tickets_empty = esc_html__('Please select tickets', 'solicitor');
wp_enqueue_script('solicitor-event-register-validation', SOLICITOR_THEME_PATH . '/js/event-register-validation.js', array('jquery'), $theme_info->get( 'Version' ), true);
wp_localize_script('solicitor-event-register-validation', 'event_registration', array('url' => admin_url('admin-ajax.php'),'name'=>$invalid_name,'emails'=>$invalid_email, 'process'=>$process, 'tickets'=>$tickets_empty, 'multiple'=>$multiple_tickets));
if(get_query_var('reg')==1||get_query_var('reg')==2||get_query_var('reg')==3)
{
	wp_enqueue_script('solicitor-event-pay',SOLICITOR_THEME_PATH . '/js/event_pay.js',array('jquery'),'',true);
	wp_localize_script('solicitor-event-pay', 'event_payment', array('name'=>get_query_var('reg')));
}
$pageSidebarGet = get_post_meta(get_the_ID(),'solicitor_select_sidebar_from_list', true);
$pageSidebarStrictNo = get_post_meta(get_the_ID(),'solicitor_strict_no_sidebar', true);
$pageSidebarOpt = $options['events_single_sidebar'];
if($pageSidebarGet != ''){
	$pageSidebar = $pageSidebarGet;
}elseif($pageSidebarOpt != ''){
	$pageSidebar = $pageSidebarOpt;
}else{
	$pageSidebar = '';
}
if($pageSidebarStrictNo == 1){
	$pageSidebar = '';
}
$sidebar_column = get_post_meta(get_the_ID(),'solicitor_sidebar_columns_layout',true);
$sidebar_column = ($sidebar_column=='')?4:$sidebar_column;
if(!empty($pageSidebar)&&is_active_sidebar($pageSidebar)) {
$left_col = 12-$sidebar_column;
$class = $left_col;  
}else{
$class = 12;  
}
$page_header = get_post_meta(get_the_ID(),'solicitor_pages_Choose_slider_display',true);
if($page_header==3||$page_header==4) {
	get_template_part( 'pages', 'flex' );
}
elseif($page_header==5) {
	get_template_part( 'pages', 'revolution' );
} else {
	get_template_part( 'pages', 'banner' );
}
$event_start_time = strtotime(get_post_meta(get_the_ID(), 'solicitor_event_start_dt', true));
$event_end_time = strtotime(get_post_meta(get_the_ID(), 'solicitor_event_end_dt', true));
if(get_query_var('event_date'))
{
$this_date = get_query_var('event_date');
}
else
{
	$events = solicitor_recur_events("future", "", "","", "");
	ksort($events);
	foreach($events as $key=>$value)
	{
		if($value==get_the_ID())
		{
			$this_date = date('Y-m-d', $key);
			break;
		}
		else
		{
			$this_date = date('Y-m-d', $event_start_time);
		}
	}
}
update_post_meta(get_query_var('registrant'), 'solicitor_registrant_event_date', get_query_var('event_date'));
$this_date = strtotime($this_date);
$event_url = solicitor_event_arg(date('Y-m-d', $this_date), get_the_ID());
$paid = '';
if(!empty($tickets_type))
{
	foreach($tickets_type as $ticket_one)
	{
		if(is_numeric($ticket_one[3]))
		{
			$paid = 1;
			break;
		}
	}
}
//Verify Paypal Payment
$transaction_id=isset($_REQUEST['tx'])?esc_attr($_REQUEST['tx']):'';
$st = '';
	if($transaction_id!='') 
	{
			$st = isset($_REQUEST['st'])?esc_attr($_REQUEST['st']):'';
			$payment_gross = isset($_REQUEST['amt'])?esc_attr($_REQUEST['amt']):'';
			update_post_meta(get_query_var('registrant'), 'solicitor_registrant_payment_status', $st);
			update_post_meta(get_query_var('registrant'), 'solicitor_registrant_paid_amount', $payment_gross);
			update_post_meta(get_query_var('registrant'), 'solicitor_registrant_transaction', $transaction_id);
	}
$attendees = get_post_meta(get_the_ID(), 'solicitor_event_attendees', true);
$manager_name = get_post_meta(get_the_ID(), 'solicitor_event_manager_name', true);
$manager_name_email = get_post_meta(get_the_ID(), 'solicitor_event_manager', true);
$event_address = get_post_meta(get_the_ID(), 'solicitor_event_address', true);
$registrationswitch = get_post_meta(get_the_ID(),'solicitor_event_registration', true);
$registrationcurl = get_post_meta(get_the_ID(),'solicitor_custom_event_registration', true);
$registrationcurltarget = get_post_meta(get_the_ID(),'solicitor_custom_event_registration_target', true);
if($registrationcurltarget == 1){
	$rurltar = ' target="_blank"';
} else {
	$rurltar = '';	
}
$paypal_payment = (isset($options['paypal_site']))?$options['paypal_site']:'';
$paypal_payment = ($paypal_payment=="1")?"https://www.paypal.com/cgi-bin/webscr":"https://www.sandbox.paypal.com/cgi-bin/webscr";
$paypal_src = (!empty($tickets_type)&&$paid==1)?$paypal_payment:'';
$business_email = (isset($options['paypal_email']))?$options['paypal_email']:'';
$paypal_currency = (isset($options['paypal_currency']))?$options['paypal_currency']:'USD';
?>
<!-- Main Content -->
    <div id="main-container">
    	<div class="content">
        	<div class="container">
            	<div class="row">
                	<div class="col-md-<?php echo esc_attr($class); ?>" id="content-col"> 
                    	<div class="single-event">
                        	<div class="row">
                            	<div class="col-lg-4 col-md-5 col-sm-5">
                                    <div class="single-event-left dgray-bg">
									  	<?php if(has_post_thumbnail(get_the_ID())) { ?>
									  		<?php echo get_the_post_thumbnail(get_the_ID()); ?>
										<?php } ?>
                            			<div class="spacer-20"></div>
                            			<div class="event-details-list">
                            				<?php if($manager_name != '' || $manager_name_email != ''){ ?>
												<?php if($manager_name_email != ''){ ?><a href="mailto:<?php echo esc_attr($manager_name_email); ?>" class="btn pull-right btn-primary"><i class="fa fa-envelope"></i></a><?php } ?>
												<h6><?php esc_html__('Event Manager','solicitor'); ?></h6>
											<?php } ?>
											<?php if($manager_name != ''){ ?><span><?php echo esc_attr($manager_name); ?></span><?php } ?>
											
											<?php if($tickets_type != ''){ ?>
												<div class="spacer-30"></div>
												<h6><?php esc_html__('Ticket Info','solicitor'); ?></h6>
												<ul class="list-group event-ticket-info-list">
													<?php 
													foreach($tickets_type as $tickets)
													{
														$available_ticket = intval($tickets[1])-intval($tickets[2]);
														$available_ticket = ($available_ticket>=0)?$available_ticket:0;
														echo '<li class="list-group-item">'.esc_attr($tickets[0]).'<br><span class="label label-default">'.esc_attr($available_ticket).esc_html__(' available', 'solicitor').'</span><span class="badge accent-bg">';
														if(is_numeric($tickets[3]))
														{
															echo esc_attr($paypal_currency).' '.esc_attr($tickets[3]);
														}
														elseif($tickets[3]=='')
														{
															echo esc_html__('Free', 'solicitor').'</span>';
														}
														else
														{
															echo esc_attr($tickets[3]).'</span>';
														}
														echo '</li>';
													} ?>
												</ul>
											<?php } ?>
										</div>
                            			<?php if($registrationswitch != 0){
										if($registrationcurl != ''){ ?>
												<a href="<?php echo esc_url($registrationcurl); ?>"<?php echo esc_attr($rurltar); ?> class="btn btn-default btn-ghost btn-light btn-block"><?php esc_html_e('Book Tickets','solicitor'); ?></a><?php }
										else { ?>
											 <a href="#" data-target="#event_register" data-toggle="modal" class="btn btn-default btn-ghost btn-light btn-block"><?php esc_html_e('Book Tickets','solicitor'); ?></a>
										<?php } } ?>
                                    </div>
                                    <div class="spacer-30"></div>
                                    </div>
                                	<div class="col-lg-8 col-md-7 col-sm-7">
                                	<div class="single-event-right">
                                    <?php 
									$event_start_date = get_post_meta(get_the_ID(), 'solicitor_event_start_dt', true);
									$event_end_date = get_post_meta(get_the_ID(), 'solicitor_event_end_dt', true);
									$event_start_date_unix = strtotime($event_start_date);
									$event_end_date_unix = strtotime($event_end_date); ?>
											<span class="label label-primary"><?php echo esc_attr(date_i18n(get_option('date_format'), $event_start_date_unix)) ?></span>
                                        <span class="label label-default"><?php echo esc_attr(date_i18n('l,', $this_date)),esc_attr(date_i18n('g:i A', $this_date))?></span>
                                    	<h2><?php the_title(); ?></h2>
										<?php 
										if(have_posts()):while(have_posts()):the_post();
										if (isset($options['switch_sharing']) && $options['switch_sharing'] == 1 && $options['share_post_types']['3'] == '1') { ?>
											<?php solicitor_share_buttons(); ?>
										<?php } ?>
                                        <div class="spacer-30"></div>
                                        <?php if($event_address != ''){ ?>
										<div class="alert alert-warning"><?php echo esc_attr($event_address); ?> <a href="https://www.google.com/maps/dir//<?php echo esc_attr($event_address); ?>" target="_blank" class="event-get-directions-link"><?php esc_html_e('Get Directions','solicitor'); ?></a></div>
                                        <?php } ?>
                                        <?php the_content();
										endwhile; endif; ?>
                                    </div>
                                </div>
                          	</div>
                        </div>                
                 	</div> 
                    <?php if(is_active_sidebar($pageSidebar)) { ?>
                    <div class="col-md-<?php echo esc_attr($sidebar_column); ?> sidebar right-sidebar" id="sidebar-col">
                    <?php dynamic_sidebar($pageSidebar); ?>
                    </div>
                    <?php } ?>
               	</div>
            </div>
        </div>
  	</div>
                                        
                                        
                    	
    <!--Event Registration Popup Start-->
    <?php
		wp_localize_script('solicitor-event-register-validation', 'event_registration_new', array('paypal_src'=>$paypal_src, 'reg'=>esc_html__('Register', 'solicitor'), 'pays'=>esc_html__('Proceed to Paypal', 'solicitor'), 'event_url'=>get_permalink()));
		?>
<div class="modal fade" id="event_register" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="event_registerLabel" aria-hidden="true">
                        <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                            	<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            	<h4 class="modal-title" id="myModalLabel"><?php esc_html_e('Register for Event: ','solicitor'); ?><span class="accent-color payment-to-cause"><?php echo esc_attr(get_the_title()); ?></span></h4>
                            </div>
                            <div class="modal-body">
                            <form id="event_register_form" class="" name="" class="" action="<?php echo esc_url($paypal_src); ?>" method="post">
                    	<div class="row">
                        	<div class="col-md-6">
                        		<input type="text" value="" id="username" name="fname" class="form-control" placeholder="<?php esc_html_e('First name', 'solicitor'); ?> (Required)">
                                <input type="hidden" value="<?php echo esc_attr(get_the_ID()); ?>" id="event_id">
                                <input type="hidden" value="<?php echo esc_attr(date_i18n(get_option('date_format'), $this_date)); ?>" id="event_date">
                            </div>
                        	<div class="col-md-6">
                        		<input id="lastname" type="text" value="" name="lname" class="form-control" placeholder="<?php esc_html_e('Last name', 'solicitor'); ?>">
                            </div>
                      	</div>
                    	<div class="row">
                        	<div class="col-md-6">
                        		<input type="text" value="" name="email" id="email" class="form-control" placeholder="<?php esc_html_e('Your email', 'solicitor'); ?> (Required)">
                            </div>
                        	<div class="col-md-6">
                        		<input id="phone" type="phone" name="phone" class="form-control" placeholder="<?php esc_html_e('Your phone', 'solicitor'); ?>">
                            </div>
                       	</div>
                    	<div class="row">
                        	<div class="col-md-6">
                        		<textarea id="address" rows="3" cols="5" class="form-control" placeholder="<?php esc_html_e('Your Address', 'solicitor'); ?>"></textarea>
                            </div>
                        	<div class="col-md-6">
                        		<textarea id="notes" rows="3" cols="5" class="form-control" placeholder="<?php esc_html_e('Additional Notes', 'solicitor'); ?>"></textarea>
                            </div>
                       	</div>
                        <?php
						$book_number = 1;
						if(!empty($tickets_type))
						{
                        echo '<table width="100%" class="table-tickets">';
						echo '<tr class="head-table-tickets">';
							echo '<td>'.esc_html__('Type', 'solicitor').'</td>';
							echo '<td>'.esc_html__('Available ', 'solicitor').'</td>';
							echo '<td>'.esc_html__('Price', 'solicitor').'</td>';
							echo '<td>'.esc_html__('Quantity', 'solicitor').'</td>';
							echo '<td>'.esc_html__('Total', 'solicitor').'</td>';
						echo '</tr>';
						foreach($tickets_type as $tickets)
						{
							$available_ticket = intval($tickets[1])-intval($tickets[2]);
							$available_ticket = ($available_ticket>=0)?$available_ticket:0;
							$field_tickets_available = ($available_ticket>10)?10:$available_ticket;
								echo '<tr>';
									echo '<td>'.esc_attr($tickets[0]).'</td>';
									echo '<td>'.esc_attr($available_ticket).'</td>';
									if(is_numeric($tickets[3]))
									{
										echo '<td>'.esc_attr($paypal_currency).' '.esc_attr($tickets[3]).'</td>';
									}
									elseif($tickets[3]=='')
									{
										echo '<td>'.esc_html__('Free', 'solicitor').'</td>';
									}
									else
									{
										echo '<td>'.esc_attr($tickets[3]).'</td>';
									}
									echo '<td>';
									if($available_ticket>0)
									{
										echo '<select data-title="'.esc_attr($tickets[0]).'" data-price="'.esc_attr($tickets[3]).'" class="event-tickets selectpicker">';
										for($x=0; $x<=$field_tickets_available; $x++)
										{
											echo '<option value="'.esc_attr($x).'">'.esc_attr($x).'</option>';
										}
										echo '</select>';
									}
									else
									{
										echo '<label>'.esc_html__('All Tickets Booked', 'solicitor').'</label>';
									}
									echo '</td>';
									echo '<td>';
									if($available_ticket>0&&$tickets[3]>0)
									{
										//Tickets Total Price
										echo esc_attr($paypal_currency).' <span class="total-cost-event"></span></label>';
									}
									echo '</td>';
								echo '</tr>';
									
							$book_number++;
						}
						echo '<input type="hidden" name="rm" value="2">';
						echo '<input type="hidden" name="amount" value="">';	
						echo '<input type="hidden" name="cmd" value="_xclick">';
						echo '<input type="hidden" name="business" value="'.esc_attr($business_email).'">';
						echo '<input type="hidden" name="currency_code" value="'.esc_attr($paypal_currency).'">';
						echo '<input type="hidden" name="item_name" value="'.stripslashes(get_the_title(get_the_ID())).'">';
						echo '<input type="hidden" name="item_number" value="'.get_the_ID().'">';
						echo '<input type="hidden" name="return" value="'.esc_url($event_url).'" />';
						}
							echo '</table>';
						?>	
                        <?php wp_nonce_field( 'ajax-exhibition-nonce', 'security' );
						if(empty($tickets_type)||$paid==0)
												{ ?>
                        <input id="submit-registration" type="submit" name="donate" class="btn btn-primary btn-lg btn-block" value="<?php esc_html_e('Register', 'solicitor'); ?>">
                        <?php } elseif($available_ticket>0&&$paid==1) { ?>
                        <input id="submit-registration" type="submit" name="donate" class="btn btn-primary btn-lg btn-block" value="<?php esc_html_e('Proceed to Paypal', 'solicitor'); ?>">
                        <?php } ?><br/>
						<div class="message"></div>
                    </form>
                            </div>
                            <div class="modal-footer">
                            	<p class="small short"><?php esc_html_e('Make sure to copy Registration number after successful submission.', 'solicitor'); ?></p>
                            </div>
                        </div>
                        </div>
                    </div>
<!--Event Registration Popup End-->
<!--Event Payment Thanks Popup-->
<div class="modal fade" id="event_register_thanks" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="event_register_thanksLabel" aria-hidden="true">
                        <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                            	<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            	<h4 class="modal-title"><?php esc_html_e('Registered Successfully','solicitor'); ?></h4>
                            </div>
                            <div class="modal-body">
                            <div class="text-align-center error-404">
                                <h1 class="huge"><?php esc_html_e('Thanks','solicitor'); ?></h1>
                                  <hr class="sm">
                                  <p><strong><?php esc_html_e('Thank you for payment.','solicitor'); ?></strong></p>
                          					<p><?php esc_html_e('Your payment is verified online.', 'solicitor');
                          					echo '<br>';
                          					esc_html_e('Your payment status showing payment ','solicitor'); echo '<strong>'.esc_attr($st).'</strong>'; ?></p>
                          	</div>
                            </div>
                            <div class="modal-footer">
                            	<a href="" id="find-ticket" class="btn btn-primary btn-lg btn-block"><?php echo esc_html__('Find Ticket', 'solicitor'); ?></a>
                            </div>
                        </div>
                        </div>
                    </div>
<?php get_footer(); ?>