<?php 
$solicitor_options = get_option('solicitor_options');
if(is_home()) { $id = get_option('page_for_posts'); }
else { $id = get_the_ID(); }
$parent_id = wp_get_post_parent_id( $id );
$sb = ($parent_id!=0)?$parent_id:$id;
$this_page = $id;
$type = get_post_meta($id,'solicitor_pages_Choose_slider_display',true);
$pagination = get_post_meta($id,'solicitor_pages_slider_pagination',true);
$autoplay = get_post_meta($id,'solicitor_pages_slider_auto_slide',true);
$arrows = get_post_meta($id,'solicitor_pages_slider_direction_arrows',true);
$effects = get_post_meta($id,'solicitor_pages_slider_effects',true);
if($type==1 || $type==2 || $type==4) {
	$height = get_post_meta($id,'solicitor_pages_slider_height',true);
} else {
	$height = '';
}
$images = get_post_meta($id,'solicitor_pages_slider_image',false);
if(!empty($images)) { ?>
<div class="hero-area">
    	<div class="hero-slider flexslider heroflex" data-autoplay="<?php echo esc_attr($autoplay); ?>" data-pagination="<?php echo esc_attr($pagination); ?>" data-arrows="<?php echo esc_attr($arrows); ?>" data-style="<?php echo esc_attr($effects); ?>" data-pause="yes" style="height:<?php echo esc_attr($height); ?>px">
            <ul class="slides">
            <?php foreach($images as $image) {
									$image_data = solicitor_wp_get_attachment($image);
									$image_src = wp_get_attachment_image_src( $image, 'full', '', array() ); ?>
                <li class="parallax" style="background-image: url(<?php echo esc_url($image_src[0]); ?>); height:<?php echo esc_attr($height);?>px;">
                	<?php global $allowed_tags;
					echo wp_kses($image_data['description'], $allowed_tags); ?>
                </li>
             <?php } ?>
          	</ul>
       	</div>
    </div>
    <?php } ?>
    <!-- End Page Header -->
  <?php $banner_menu = get_post_meta($id, 'solicitor_pages_banner_menu', false);?>
    <?php if(!empty($banner_menu)) { ?>
    <div class="utility-bar">
    	<div class="container">
        	<ul class="template-submenu">
            <?php if($id!=$sb) { ?>
           <li><a href="<?php echo esc_url(get_permalink($sb)); ?>"><?php echo esc_attr(get_the_title($sb)); ?></a></li>
           <?php } else { ?>
           <li class="current_page_item"><a><?php echo esc_attr(get_the_title($sb)); ?></a></li>
            <?php }
				$args_subpages = array('post_type' => 'page', 'posts_per_page' => -1, 'post_parent' => $sb, 'order' => 'ASC', 'orderby' => 'menu_order');
				$subpages_list = new WP_Query($args_subpages);
				if($subpages_list->have_posts()):while($subpages_list->have_posts()):$subpages_list->the_post();
				if(get_the_ID() == $this_page){ ?>
					<li class="current_page_item"><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_attr(get_the_title()); ?></a></li>
				<?php } else { ?>
           <li><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_attr(get_the_title()); ?></a></li>
        <?php } 
				endwhile; endif; wp_reset_postdata(); ?>
            </ul>
        </div>
    </div>
    <?php } ?>