<?php 
$options = get_option('solicitor_options');
if(is_home()){
	$id = get_option('page_for_posts');
} else {
	$id = get_the_ID();
}
$parent_id = wp_get_post_parent_id( $id );
$sb = ($parent_id!=0)?$parent_id:$id;
$this_page = $id;
$post_type = get_post_type($id);
$default_event_banner = (isset($options['default_event_banner']))?$options['default_event_banner']['url']:'';
$default_post_banner = (isset($options['default_post_banner']))?$options['default_post_banner']['url']:'';
$default_service_banner = (isset($options['default_service_banner']))?$options['default_service_banner']['url']:'';
$default_team_banner = (isset($options['default_team_banner']))?$options['default_team_banner']['url']:'';
$default_product_banner = (isset($options['default_product_banner']))?$options['default_product_banner']['url']:'';

if($post_type=='event' && $default_event_banner != '')
{
	$image_default = $default_event_banner;
}
elseif($post_type=='post' && $default_post_banner != '')
{
	$image_default = $default_post_banner;
}
elseif($post_type=='service' && $default_service_banner != '')
{
	$image_default = $default_service_banner;
}
elseif($post_type=='team' && $default_team_banner != '')
{
	$image_default = $default_team_banner;
}
elseif($post_type=='product' && $default_product_banner != '')
{
	$image_default = $default_product_banner;
}
else{
	$image_default = (isset($options['solicitor_default_banner']))?$options['solicitor_default_banner']['url']:'';
}

$image = $banner_type = '';
$fimagebanner = get_post_meta($id,'solicitor_featured_image_banner',true);
$height = get_post_meta($id,'solicitor_pages_slider_height',true);
$PageBannerMinHeight = (isset($options['inner_page_header_min_height']))?$options['inner_page_header_min_height']:'';
$color = get_post_meta($id,'solicitor_pages_banner_color',true);
$banner_right = get_post_meta($id,'solicitor_page_header_right',true);
$banner_menu = get_post_meta($sb,'solicitor_banner_menu_switch', true);
$color = ($color!='' && $color!='#')?$color:'';
$post_image = get_post_meta($id,'solicitor_header_image',true);
$image_src = wp_get_attachment_image_src( $post_image, 'full', '', array() );
$post_thumbnail_id = get_post_thumbnail_id( $id );
$post_thumbnail_url = wp_get_attachment_image_src($post_thumbnail_id,'full', true);
if(is_tax() || is_category()){
	$term_id = get_queried_object()->term_id;
	$term_banner = get_term_meta( $term_id, 'solicitor_term_banner_image', true );
	$term_banner_image = RWMB_Image_Field::file_info( $term_banner, array( 'size' => 'full' ) );
} else {
	$term_banner_image['url'] = '';
}


if(has_post_thumbnail($id) && $fimagebanner == 1){$image = $post_thumbnail_url[0];}elseif(is_array($image_src)) { $image = $image_src[0]; }elseif($term_banner_image['url'] != ''){ $image = $term_banner_image['url']; } else { $image = $image_default; }
$event_archive_title = (isset($options['$event_archive_title']))?$options['$event_archive_title']:esc_html__('Events', 'solicitor');
$blog_archive_title = (isset($options['blog_archive_title']))?$options['blog_archive_title']:esc_html__('Blog', 'solicitor');
$service_archive_title = (isset($options['service_archive_title']))?$options['service_archive_title']:esc_html__('Services', 'solicitor');
$team_archive_title = (isset($options['team_archive_title']))?$options['team_archive_title']:esc_html__('Team', 'solicitor');
$shop_archive_title = (isset($options['shop_archive_title']))?$options['shop_archive_title']:esc_html__('Shop', 'solicitor');

if($post_type=='event')
{
	if(is_single()){
		$blog_title = $event_archive_title;
	}
	elseif (is_tax('event-category')){
		$blog_title = single_term_title("", false);
	}
	else {
		$blog_title = $event_archive_title;
	}
	$banner_title = $blog_title;
}
elseif($post_type=='post')
{
	if(is_single()){
		$blog_title = get_the_title(get_the_ID());
	}
	elseif (is_category() || is_tag()){
		$blog_title = single_term_title("", false);
	}
	elseif (is_author()){
		global $author;
        $userdata = get_userdata($author);
		$blog_title = $userdata->display_name;
	} else {
		$blog_title = $blog_archive_title;
	}
	$banner_title = $blog_title;
}
elseif($post_type=='service')
{
	if(is_single()){
		$blog_title = get_the_title(get_the_ID());
	}
	elseif (is_tax('service-category')){
		$blog_title = single_term_title("", false);
	}
	else {
		$blog_title = $service_archive_title;
	}
	$banner_title = $blog_title;
}
elseif($post_type=='team')
{
	if(is_single()){
		$blog_title = get_the_title(get_the_ID());
	}
	elseif (is_tax('team-category')){
		$blog_title = single_term_title("", false);
	}
	else {
		$blog_title = $team_archive_title;
	}
	$banner_title = $blog_title;
}
elseif($post_type=='product')
{
	if(is_single()){
		$blog_title = get_the_title(get_the_ID());
	}
	elseif (is_tax('product_cat')){
		$blog_title = single_term_title("", false);
	}
	else {
		$blog_title = $shop_archive_title;
	}
	$banner_title = $blog_title;
}
else
{
	$banner_title = get_the_title($id);
}
$menu_class = ($banner_menu==1)?'have-submenu':'';
?>

<!-- Start Hero Area -->
<div class="hero-area">
<?php if($image!='') {
  if($height != ''){$rheight = $height;} elseif($PageBannerMinHeight != ''){$rheight = $PageBannerMinHeight;} else {$rheight = '';}
	 echo '<div class="page-header '.esc_attr($menu_class).' page-header-image parallax" style="background-image:url('.esc_url($image).'); background-color:'.esc_attr($color).'; height:'.esc_attr($rheight).'px'.';">
	 <div class="container">
            	<div class="page-header-text"><div style="height:'. esc_attr($rheight).'px;"><div>';
 }
 else
 {
	 echo '<div class="page-header '.esc_attr($menu_class).'" style="background-color:'.esc_attr($color).'; height:'.esc_attr($height).'px'.';">
	 	<div class="container">
           <div class="page-header-text"><div style="height:'. esc_attr($height).'px;"><div>';
 } ?>
        
    	<?php if($banner_right=='3') { ?>
         	<?php wp_enqueue_script('countdown', SOLICITOR_THEME_PATH . '/vendor/countdown/js/jquery.countdown.min.js', array('jquery'), wp_get_theme()->get( 'Version' ), true);
         	wp_enqueue_script('countdown-init', SOLICITOR_THEME_PATH . '/vendor/countdown/js/counter.init.js', array('jquery'), wp_get_theme()->get( 'Version' ), true);
			wp_localize_script('countdown', 'upcoming_data', array('c_time' =>time()));
				$next_event_time="";
			    $next_event_post_id="";
				$events = solicitor_recur_events('future'); 
				ksort($events); 
				foreach($events as $key=>$value)
				{ 
					$next_event_time = $key;
					$next_event_post_id = $value;
					break;
				}
			?>
            <?php if(!empty($next_event_time))
				{ ?>
            	<div class="header-counter">
            		<div class="accent-bg upcoming-event-counter"><?php echo esc_html__('Upcoming Event','solicitor');?></div>
                    <div class="clearfix"></div>
                    <div id="counter" class="event-counter" data-date="<?php echo esc_attr($next_event_time); ?>">
                        <div class="timer-col count-days"> <span id="days"></span> <span class="timer-type"><?php esc_html_e('days','solicitor'); ?></span> </div>
                        <div class="timer-col"> <span id="hours"></span> <span class="timer-type"><?php esc_html_e('hrs','solicitor'); ?></span> </div>
                        <div class="timer-col"> <span id="minutes"></span> <span class="timer-type"><?php esc_html_e('mins','solicitor'); ?></span> </div>
                        <div class="timer-col"> <span id="seconds"></span> <span class="timer-type"><?php esc_html_e('secs','solicitor'); ?></span> </div>
                    </div>
               	</div>
            <?php }?>
        	<?php } elseif ($banner_right=='2') {
				$button_url = get_post_meta($id,'solicitor_pages_banner_btn_url',true);
				$button_text = get_post_meta($id,'solicitor_pages_banner_btn_text',true);
		?>
            	<a href="<?php echo esc_url($button_url); ?>" class="btn btn-primary btn-dark btn-ghost pull-right"><?php echo esc_attr($button_text); ?></a>
        <?php } ?>
        <h1><?php echo esc_attr($banner_title); ?></h1>
		 <?php 
			if(function_exists('bcn_display')){?>	
				<ol class="breadcrumb">
					<?php bcn_display(); ?>
				</ol>
			<?php } ?>
            </div>
        </div>
    </div>
    </div>
    </div>
</div>
    <?php if($banner_menu==1) { ?>
    <div class="utility-bar">
    	<div class="container">
        	<ul class="template-submenu">
          <?php if($id!=$sb) { ?>
           <li><a href="<?php echo esc_url(get_permalink($sb)); ?>"><?php echo esc_attr(get_the_title($sb)); ?></a></li>
           <?php } else { ?>
           <li class="current_page_item"><a><?php echo esc_attr(get_the_title($sb)); ?></a></li>
            <?php }
				$args_subpages = array('post_type' => 'page', 'posts_per_page' => -1, 'post_parent' => $sb, 'order' => 'ASC', 'orderby' => 'menu_order');
				$subpages_list = new WP_Query($args_subpages);
				if($subpages_list->have_posts()):while($subpages_list->have_posts()):$subpages_list->the_post();
				if(get_the_ID() == $this_page){ ?>
					<li class="current_page_item"><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_attr(get_the_title()); ?></a></li>
				<?php } else { ?>
           <li><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_attr(get_the_title()); ?></a></li>
        <?php } 
				endwhile; endif; wp_reset_postdata(); ?>
            </ul>
        </div>
    </div>
    <?php } ?>