<!DOCTYPE html>
<!--// OPEN HTML //-->
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <?php
	global $allowed_tags;
    $options = get_option('solicitor_options');
	$header_text = (isset($options['header_text_left']))?$options['header_text_left']:'';
	$header_text_url = (isset($options['header_text_url']))?$options['header_text_url']:'';
	$topbar_switch = (isset($options['enable_topbar']))?$options['enable_topbar']:'';
    ?>
    <!-- Mobile Specific Metas
    ================================================== -->
	<?php $switch_responsive = (isset($options['switch-responsive']))?$options['switch-responsive']:'';
	$switch_zoom_pinch = (isset($options['switch-zoom-pinch']))?$options['switch-zoom-pinch']:'';
	if ($switch_responsive == 1){ ?>
        <?php if ($switch_zoom_pinch == 1){ ?>
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <?php } else { ?>
                <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0">
        <?php } ?>
    <?php } ?>
    	<!--// PINGBACK //-->
    	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
    <?php //  WORDPRESS HEAD HOOK 
   wp_head(); ?>
</head>
<!--// CLOSE HEAD //-->
<body <?php body_class(); ?>>
<?php
	$id = '';
	if(is_home()) { $id = get_option('page_for_posts'); }
	else { $id = get_the_ID(); }
	if(is_tax() || is_category() || is_tag() || is_archive()){
		echo '';
	} else {
	$content_top_padding = get_post_meta($id,'solicitor_content_padding_top',true);
	$content_bottom_padding = get_post_meta($id,'solicitor_content_padding_bottom',true);
	$content_width = get_post_meta($id,'solicitor_content_width',true);
	$page_title_show = get_post_meta($id,'solicitor_pages_title_show',true);
	$pages_banner_text_color = get_post_meta($id,'solicitor_pages_banner_text_color',true);
	$pages_title_alignment = get_post_meta($id,'solicitor_pages_title_alignment',true);
	$page_header_show = get_post_meta($id,'solicitor_page_header_show',true);
	$page_social_show = get_post_meta($id,'solicitor_page_social_share',true);
	$page_body_bg_color = get_post_meta($id,'solicitor_pages_body_bg_color',true);
	$page_body_bg_image = get_post_meta($id,'solicitor_pages_body_bg_image',true);
	$page_body_bg_image_src = wp_get_attachment_image_src( $page_body_bg_image, 'full', '', array() );
	$page_body_bg_size = get_post_meta($id,'solicitor_pages_body_bg_wide',true);
	if($page_body_bg_size==0){
		$page_body_bg_size_result = 'auto';
		$page_body_bg_size_attachment = 'scroll';
	}else{
		$page_body_bg_size_result = 'cover';
		$page_body_bg_size_attachment = 'fixed';
	}
	$page_body_bg_repeat = get_post_meta($id,'solicitor_pages_body_bg_repeat',true);
	$page_content_bg_color = get_post_meta($id,'solicitor_pages_content_bg_color',true);
	$page_content_bg_image = get_post_meta($id,'solicitor_pages_content_bg_image',true);
	$page_content_bg_image_src = wp_get_attachment_image_src( $page_content_bg_image, 'full', '', array() );
	$page_content_bg_size = get_post_meta($id,'solicitor_pages_content_bg_wide',true);
	if($page_content_bg_size==0){
		$page_content_bg_size_result = 'auto';
		$page_content_bg_size_attachment = 'scroll';
	}else{
		$page_content_bg_size_result = 'cover';
		$page_content_bg_size_attachment = 'fixed';
	}
	$page_content_bg_repeat = get_post_meta($id,'solicitor_pages_content_bg_repeat',true);
	
	echo '<style type="text/css">';
		if($page_header_show == 0 && $page_header_show != ''){
			echo' .hero-area,.page-header{display:none;}';	
		}
		if($page_social_show == 0 && $page_social_show != ''){
			echo'.social-share-bar{display:none;}';	
		}
		echo '.content{';
			if($content_top_padding != ''){ echo 'padding-top:'.esc_attr($content_top_padding).'px;'; }
			if($content_bottom_padding != ''){ echo 'padding-bottom:'.esc_attr($content_bottom_padding).'px;'; }
		echo '}';
		if($content_width != ''){
		echo '
		.content .container{
			width:'.esc_attr($content_width).';
		}';
		}
		echo 'body{';
			if($page_body_bg_color != ''){ echo 'background-color:'.esc_attr($page_body_bg_color).';';}
			if($page_body_bg_image != ''){ echo 'background-image:url('.esc_attr($page_body_bg_image_src[0]).');';}
			if($page_body_bg_image != ''){ echo 'background-size:'.esc_attr($page_body_bg_size_result).';';}
			if($page_body_bg_image != ''){ echo 'background-repeat:'.esc_attr($page_body_bg_repeat).';';}
			if($page_body_bg_image != ''){ echo 'background-attachment:'.esc_attr($page_body_bg_size_attachment).';';}
		echo '}
		.content{';
			if($page_content_bg_color != ''){ echo 'background-color:'.esc_attr($page_content_bg_color).';';}
			if($page_content_bg_image != ''){ echo 'background-image:url('.esc_attr($page_content_bg_image_src[0]).');';}
			if($page_content_bg_image != ''){ echo 'background-size:'.esc_attr($page_content_bg_size_result).';';}
			if($page_content_bg_image != ''){ echo 'background-repeat:'.esc_attr($page_content_bg_repeat).';';}
			if($page_content_bg_image != ''){ echo 'background-attachment:'.esc_attr($page_content_bg_size_attachment).';';}
		echo '}';
		if($page_title_show == 0 && $page_title_show != ''){
			echo'.page-header h1{display:none;}';	
		}else{
			echo'.page-header h1{display:block;}';		
		}
		if($pages_banner_text_color != ''){
			echo'.page-header h1{color:'.$pages_banner_text_color.';}';	
		}
		if($pages_title_alignment != ''){
			echo'.page-header h1, .page-header .breadcrumb{text-align:'.$pages_title_alignment.';}';	
		}
	echo '</style>';
	}
?>

<div class="body">
    <div class="header-wrapper">
    <?php if($topbar_switch=="1") { ?>
        <div class="topbar">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-sm-6">
                    <?php if($header_text_url=='') { ?>
                        <p><?php echo esc_attr($header_text); ?></p>
                   	<?php } else { ?>
                    	<p><a href="<?php echo esc_url($header_text_url); ?>"><?php echo wp_kses($header_text, $allowed_tags); ?></a></p>
                    <?php } ?>
                    </div>
                    <div class="col-md-6 col-sm-6">
                        <ul class="pull-right social-icons">
                            <?php
								$socialSites = $options['header_social_links'];
								foreach ($socialSites as $key => $value) {
								  $string = substr($key, 3);
								  if (filter_var($value, FILTER_VALIDATE_EMAIL)) {
									  echo '<li class="'.esc_attr($string).'"><a href="mailto:' . esc_attr($value) . '"><i class="fa fa-lg ' . esc_attr($key) . '"></i></a></li>';
								  }
								  if (filter_var($value, FILTER_VALIDATE_URL)) {
									  echo '<li class="'.esc_attr($string).'"><a href="' . esc_url($value) . '" target="_blank"><i class="fa fa-lg ' . esc_attr($key) . '"></i></a></li>';
								  }
								  elseif($key == 'fa-skype' && $value != '' && $value != 'Enter Skype ID') {
									  echo '<li class="'.esc_attr($string).'"><a href="skype:' . esc_attr($value) . '?call"><i class="fa fa-lg ' . esc_attr($key) . '"></i></a></li>';
								}
							} ?>
                        </ul>
                        
                        <?php get_search_form(); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php } ?>
		<?php
	  	if(is_home()){
			$id = get_option('page_for_posts');
		} else {
			$id = get_the_ID();
		}
	  	$page_header_layout = get_post_meta($id,'solicitor_page_header_style', true);
		if($page_header_layout != ''){
			$header_style = $page_header_layout;
		} else {
			$header_style = (isset($options['header_layout']))?$options['header_layout']:'1';
		}
		get_template_part('header-style', $header_style);
	  ?>