<?php
/* -----------------------------------------------------------------------------------
  Here we have all the custom functions for the theme
  Please be extremely cautious editing this file,
  When things go wrong, they tend to go wrong in a big way.
  You have been warned!
  ----------------------------------------------------------------------------------- */
/*
 * When using a child theme you can override certain functions (those wrapped
 * in a function_exists() call) by defining them first in your child theme's
 * functions.php file. The child theme's functions.php file is included before
 * the parent theme's file, so the child theme functions would be used.
 *
 * @link http://codex.wordpress.org/Theme_Development
 * @link http://codex.wordpress.org/Child_Themes
  ----------------------------------------------------------------------------------- */
define('SOLICITOR_THEME_PATH', get_template_directory_uri());
define('SOLICITOR_FILEPATH', get_template_directory());
/* -------------------------------------------------------------------------------------
  Load Translation Text Domain
  ----------------------------------------------------------------------------------- */
add_action('after_setup_theme', 'solicitor_theme_setup');
function solicitor_theme_setup() {
    load_theme_textdomain('solicitor', SOLICITOR_FILEPATH . '/language');
}
/* -------------------------------------------------------------------------------------
  Menu option
  ----------------------------------------------------------------------------------- */
function solicitor_register_menu() {
    register_nav_menu('primary-menu', esc_html__('Primary Menu', 'solicitor'));
		register_nav_menu('footer-menu', esc_html__('Footer Menu', 'solicitor'));
}
add_action('init', 'solicitor_register_menu');
/* -------------------------------------------------------------------------------------
  Set Max Content Width (use in conjuction with ".entry-content img" css)
  ----------------------------------------------------------------------------------- */
if (!isset($content_width))
    $content_width = 680;
/* -------------------------------------------------------------------------------------
  Configure WP2.9+ Thumbnails & gets the current post type in the WordPress Admin
  ----------------------------------------------------------------------------------- */
add_action( 'after_setup_theme', 'solicitor_theme_support_setup' );
if ( !function_exists( 'solicitor_theme_support_setup' ) ) {
	function solicitor_theme_support_setup() {
		add_theme_support('post-thumbnails');
		add_theme_support( 'title-tag' );
		add_theme_support('automatic-feed-links');
		set_post_thumbnail_size(958, 9999);
		//Mandatory
		add_image_size('solicitor-177x177','177','177',true);
		add_image_size('solicitor-458x384','458','384',true);
		add_image_size('solicitor-263x263','263','263',true);
		add_image_size('solicitor-482x314','482','314',true);
		add_image_size('solicitor-600x400','600','400',true);
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );
	}
}
/* -------------------------------------------------------------------------------------
  Custom Gravatar Support
  ----------------------------------------------------------------------------------- */
if (!function_exists('solicitor_custom_gravatar')) {
    function solicitor_custom_gravatar($avatar_defaults) {
        $solicitor_avatar = get_template_directory_uri() . '/images/img_avatar.png';
        $avatar_defaults[$solicitor_avatar] = 'Custom Gravatar (/images/img_avatar.png)';
        return $avatar_defaults;
    }
    add_filter('avatar_defaults', 'solicitor_custom_gravatar');
}
/* -------------------------------------------------------------------------------------
  Load Theme Options
  ----------------------------------------------------------------------------------- */
require_once(SOLICITOR_FILEPATH . '/solicitor-framework/solicitor-includes.php');
require_once (get_template_directory() . '/solicitor-framework/barebones-config.php');
/* -------------------------------------------------------------------------------------
  Excerpt More and  length
  ----------------------------------------------------------------------------------- */
if (!function_exists('solicitor_custom_read_more')) {
    function solicitor_custom_read_more() {
        return '';
    }
}
if (!function_exists('solicitor_excerpt')) {
    function solicitor_excerpt($limit = 50) {
        return '<p>' . wp_trim_words(get_the_excerpt(), $limit, solicitor_custom_read_more()) . '</p>';
    }
}
/* 	Comment Styling
  /*----------------------------------------------------------------------------------- */
if (!function_exists('solicitor_comment')) {
    function solicitor_comment($comment, $args, $depth) {
        $isByAuthor = false;
        if ($comment->comment_author_email == get_the_author_meta('email')) {
            $isByAuthor = true;
        }
        $GLOBALS['comment'] = $comment;
        ?>
        <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
            <div class="post-comment-block">
                <div id="comment-<?php comment_ID(); ?>">
                    <?php echo get_avatar($comment, $size = '80','', '',  array('class'=>'img-thumbnail')); ?>
                    <div class="post-comment-content">
						<?php
						 echo preg_replace('/comment-reply-link/', 'comment-reply-link pull-right btn btn-default btn-xs', get_comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth'], 'reply_text' => 'Reply'))), 1);
					   echo '<h6><span class="comment-type">'.get_comment_type('', 'trackback', 'pingback').' </span><a href="'.get_comment_author_url().'">' . get_comment_author() .'<span class="comment-author">'.esc_html__(' says','solicitor').'</span></a></h6>';
						?>            
						<span class="meta-data">
							<?php
							echo get_comment_date();
							esc_html_e(' at ', 'solicitor');
							echo get_comment_time();
							?>
						</span>
						<?php if ($comment->comment_approved == '0') : ?>
							<em class="moderation"><?php esc_html_e('Your comment is awaiting moderation.', 'solicitor') ?></em>
							<br />
						<?php endif; ?>
						<div class="comment-text post-content">
							<?php comment_text() ?>
						</div>
                	</div>
            	</div>
			</div>
            <?php
        }
    }
/* -------------------------------------------------------------------------------------
  For Pagination
  ----------------------------------------------------------------------------------- */
if (!function_exists('solicitor_pagination')) {
    function solicitor_pagination() {
		$pages = get_the_posts_pagination( array(
		'prev_text'	=> '<i class="fa fa-chevron-left"></i>',
		'next_text'	=> '<i class="fa fa-chevron-right"></i>',
		'type'      => 'list',
    ));
   	echo '<div class="pagination-wrap">'; 
	echo $pages;
    echo '</div>';
    }
}

//Add custom class on body tag
function solicitor_add_body_class( $classes ) {
	$options = get_option('solicitor_options');
    /** Theme layout design * */
	if(is_home()){
		$id = get_option('page_for_posts');
	} else {
		$id = get_the_ID();
	}
	$page_layout = get_post_meta($id,'solicitor_page_layout', true);
	if($page_layout != ''){
		$bodyClass = $page_layout;
	} else {
		$bodyClass = (isset($options['site_layout'])&&$options['site_layout'] == 'boxed') ? ' boxed' : '';
	}
	$page_header_layout = get_post_meta($id,'solicitor_page_header_style', true);
	if($page_header_layout != ''){
		$header_style = $page_header_layout;
	} else {
		$header_style = (isset($options['header_layout']))?$options['header_layout']:'1';
	}
    $classes[] = $bodyClass;
	$classes[] = 'header-style'.$header_style;
    return $classes;
}
add_filter( 'body_class', 'solicitor_add_body_class', 10, 3 );

//Add inline style for theme styling
function solictor_styles_method() {
    wp_enqueue_style(
        'custom-style',
        get_template_directory_uri() . '/css/custom.css'
		, array( '' )
    );
	$options = get_option('solicitor_options');
	$style ='';
    /** Boxed layout custom css * */
   	if(isset($options['site_layout'])&&$options['site_layout'] == 'boxed'){
        if (!empty($options['upload-repeatable-bg-image']['id'])) {
        $style = 'body{background-image:url(' . $options['upload-repeatable-bg-image']['url'] . '); background-repeat:repeat; background-size:auto;}';
    } else if (!empty($options['full-screen-bg-image']['id'])) {
        $style = 'body{background-image:url(' . $options['full-screen-bg-image']['url'] . '); background-repeat: no-repeat; background-size:cover;}';
    }
       else if(!empty($options['repeatable-bg-image'])) {
        $style = 'body{background-image:url(' . get_template_directory_uri() . '/images/patterns/' . $options['repeatable-bg-image'] . '); background-repeat:repeat; background-size:auto;}';
    }
    }
	
   	wp_add_inline_style( 'custom-style', $style );
}
add_action( 'wp_enqueue_scripts', 'solictor_styles_method' );


// Permalink Structure Options
$options = get_option('solicitor_options');
// Event
$event_post_slug = (isset($options['event_post_slug']))?$options['event_post_slug']:'';
if($event_post_slug == ''){
	$event_post_slug = 'event';
}
$event_post_title = (isset($options['event_post_title']))?$options['event_post_title']:'';
if($event_post_title == ''){
	$event_post_title = esc_html__('Events','solicitor');
}
$event_post_all = (isset($options['event_post_all']))?$options['event_post_all']:'';
if($event_post_all == ''){
	$event_post_all = esc_html__('Events','solicitor');
}
$event_post_categories = (isset($options['event_post_categories']))?$options['event_post_categories']:'';
if($event_post_categories == ''){
	$event_post_categories = esc_html__('Event Categories','solicitor');
}
$event_category_slug = (isset($options['event_category_slug']))?$options['event_category_slug']:'';
if($event_category_slug == ''){
	$event_category_slug = 'event-category';
}
$event_post_registerants = (isset($options['event_post_registerants']))?$options['event_post_registerants']:'';
if($event_post_registerants == ''){
	$event_post_registerants = esc_html__('Registrants','solicitor');
}
$disable_event_archive = (isset($options['disable_event_archive']))?$options['disable_event_archive']:0;
$event_archive = $disable_event_archive ? false : true;
// Service
$service_post_slug = (isset($options['service_post_slug']))?$options['service_post_slug']:'';
if($service_post_slug == ''){
	$service_post_slug = 'service';
}
$service_post_title = (isset($options['service_post_title']))?$options['service_post_title']:'';
if($service_post_title == ''){
	$service_post_title = esc_html__('Services','solicitor');
}
$service_post_all = (isset($options['service_post_all']))?$options['service_post_all']:'';
if($service_post_all == ''){
	$service_post_all = esc_html__('Services','solicitor');
}
$service_post_categories = (isset($options['service_post_categories']))?$options['service_post_categories']:'';
if($service_post_categories == ''){
	$service_post_categories = esc_html__('Service Categories','solicitor');
}
$service_category_slug = (isset($options['service_category_slug']))?$options['service_category_slug']:'';
if($service_category_slug == ''){
	$service_category_slug = 'service-category';
}
$disable_service_archive = (isset($options['disable_service_archive']))?$options['disable_service_archive']:0;
$service_archive = $disable_service_archive ? false : true;
// Team
$team_post_slug = (isset($options['team_post_slug']))?$options['team_post_slug']:'';
if($team_post_slug == ''){
	$team_post_slug = 'team';
}
$team_post_title = (isset($options['team_post_title']))?$options['team_post_title']:'';
if($team_post_title == ''){
	$team_post_title = esc_html__('Team','solicitor');
}
$team_post_all = (isset($options['team_post_all']))?$options['team_post_all']:'';
if($team_post_all == ''){
	$team_post_all = esc_html__('Team','solicitor');
}
$team_post_categories = (isset($options['team_post_categories']))?$options['team_post_categories']:'';
if($team_post_categories == ''){
	$team_post_categories = esc_html__('Team Categories','solicitor');
}
$team_category_slug = (isset($options['team_category_slug']))?$options['team_category_slug']:'';
if($team_category_slug == ''){
	$team_category_slug = 'team-category';
}
$disable_team_archive = (isset($options['disable_team_archive']))?$options['disable_team_archive']:0;
$team_archive = $disable_team_archive ? false : true;
// Testimonials
$testimonial_post_slug = (isset($options['testimonial_post_slug']))?$options['testimonial_post_slug']:'';
if($testimonial_post_slug == ''){
	$testimonial_post_slug = 'testimonial';
}
$testimonial_post_title = (isset($options['testimonial_post_title']))?$options['testimonial_post_title']:'';
if($testimonial_post_title == ''){
	$testimonial_post_title = esc_html__('Testimonials','solicitor');
}
$testimonial_post_all = (isset($options['testimonial_post_all']))?$options['testimonial_post_all']:'';
if($testimonial_post_all == ''){
	$testimonial_post_all = esc_html__('Testimonials','solicitor');
}
$testimonial_post_categories = (isset($options['testimonial_post_categories']))?$options['testimonial_post_categories']:'';
if($testimonial_post_categories == ''){
	$testimonial_post_categories = esc_html__('Testimonial Categories','solicitor');
}
$testimonial_category_slug = (isset($options['testimonial_category_slug']))?$options['testimonial_category_slug']:'';
if($testimonial_category_slug == ''){
	$testimonial_category_slug = 'testimonial-category';
}
$disable_testimonial_archive = (isset($options['disable_testimonial_archive']))?$options['disable_testimonial_archive']:0;
$testimonial_archive = $disable_testimonial_archive ? false : true;


function solicitor_paginate_links() {
global $wp_query;
$big = 999999999;
$pages = paginate_links( array(
        'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
        'format' => '?paged=%#%',
        'current' => max( 1, get_query_var('paged') ),
        'total' => $wp_query->max_num_pages,
        'type'  => 'array',
				'prev_text'	=> '<i class="fa fa-chevron-left"></i>',
				'next_text'	=> '<i class="fa fa-chevron-right"></i>',
    ) );
    if( is_array( $pages ) ) {
        $paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
        echo '<div class="pagination-wrap"><ul class="pagination">';
        foreach ( $pages as $page ) {
                echo "<li>$page</li>";
        }
       echo '</ul></div>';
        }
}
?>