<?php
global $allowed_tags;
$menu_locations = get_nav_menu_locations();
$options = get_option('solicitor_options');
$footer_logo = (isset($options['footer_logo_upload']))?$options['footer_logo_upload']:'';
$footer_logo_url = (isset($footer_logo['url']))?$footer_logo['url']:'';
$socialSites = (isset($options['footer_social_links']))?$options['footer_social_links']:array(); ?>
<!-- Site Footer -->


    <!-- Site Footer -->
    <div class="site-footer">
    	<div class="container">
         <?php
      if ( is_active_sidebar( 'footer-sidebar' ) ) : ?>
        	<div class="footer-widgets-area"><div class="row">
                    	<?php dynamic_sidebar('footer-sidebar'); ?>
            </div></div>
            <?php endif; ?>
            <?php if(!empty($socialSites)||!empty($menu_locations['footer-menu'])) { ?>
            <div class="footer-row2">
                <ul class="pull-right social-icons social-icons-colored social-icons-inverted">
					<?php
						if(isset($options['footer_social_links'])) {
							foreach ($socialSites as $key => $value) {
								$string = substr($key, 3);
							  	if (filter_var($value, FILTER_VALIDATE_EMAIL)) {
								  	echo '<li class="'.esc_attr($string).'"><a href="mailto:' . esc_attr($value) . '"><i class="fa fa-lg ' . esc_attr($key) . '"></i></a></li>';
							  	}
							  	if (filter_var($value, FILTER_VALIDATE_URL)) {
								  	echo '<li class="'.esc_attr($string).'"><a href="' . esc_url($value) . '" target="_blank"><i class="fa fa-lg ' . esc_attr($key) . '"></i></a></li>';
							  	}
							  	elseif($key == 'fa-skype' && $value != '' && $value != 'Enter Skype ID') {
								  	echo '<li class="'.esc_attr($string).'"><a href="skype:' . esc_attr($value) . '?call"><i class="fa fa-lg ' . esc_attr($key) . '"></i></a></li>';
								}
							}
						}
					?>
                </ul>
                <?php if (!empty($menu_locations['footer-menu'])) { 
					wp_nav_menu(array('theme_location' => 'footer-menu', 'depth' => 1, 'container' => '','items_wrap' => '<ul id="%1$s" class="footer-menu">%3$s</ul>'));
				} ?>
            </div>
            <?php } ?>
            <?php if($footer_logo_url!=''||$options['footer_copyright_text']!='') { ?>
            <div class="footer-row3">
            <?php if($footer_logo_url!='') { ?>
            	<a href="<?php echo esc_url( home_url('/') ); ?>"><img src="<?php echo esc_url($footer_logo_url ); ?>" alt="" width="130" class="site-footer-logo"></a>
                <?php } ?>
                    	<p><?php echo wp_kses($options['footer_copyright_text'], $allowed_tags); ?></p>
                 	</div>
                    <?php } ?>
        </div>
    </div>
  <?php 
		$enable_backtotop = (isset($options['enable_backtotop']))?$options['enable_backtotop']:'';
		if ($enable_backtotop == 1) { 
echo'<a id="back-to-top"><i class="fa fa-angle-double-up"></i></a> ';
 } ?>
</div>
<?php $SpaceBeforeBody = (isset($options['space-before-body']))?$options['space-before-body']:'';
    echo esc_html($SpaceBeforeBody);
 $payment_gross = '';
if(get_post_type(get_the_ID())=="event")
{
 $registrant_id = get_query_var('registrant');
 $solicitor_reg_user = $solicitor_reg_id = $solicitor_event_time = $solicitor_event_date = $venue_title = '';
if($registrant_id!='')
{
	$transaction_id=isset($_REQUEST['tx'])?esc_attr($_REQUEST['tx']):'';
	if($transaction_id!='') 
	{
			$payment_gross = isset($_REQUEST['amt'])?esc_attr($_REQUEST['amt']):'';
	}
	$solicitor_reg_user = get_the_title($registrant_id);
	$solicitor_reg_id = get_post_meta($registrant_id, 'solicitor_registrant_registration_number', true);
	$solicitor_event_time = get_post_meta(get_the_ID(), 'solicitor_event_start_dt', true);
	$solicitor_event_time = strtotime($solicitor_event_time);
	$solicitor_event_time = date(get_option('time_format'), $solicitor_event_time);
}
else
{
		$solicitor_event_time = get_post_meta(get_the_ID(), 'solicitor_event_start_dt', true);
		$solicitor_event_time = strtotime($solicitor_event_time);
		$solicitor_event_time = date(get_option('time_format'), $solicitor_event_time);
}
	
$venue_title = get_post_meta( get_the_ID(), 'solicitor_event_address', true );
$paypal_currency = (isset($options['paypal_currency']))?$options['paypal_currency']:'USD';
 ?>
 <!--Ticket Modal-->
<div class="modal fade" id="ticketModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
						<h4 class="modal-title" id="myModalLabel"><?php esc_html_e('Your ticket for the: ','solicitor'); echo get_the_title(); ?></h4>
					</div>
					<div class="modal-body">
						<!-- Event Register Tickets -->
						<div class="ticket-booking-wrapper">
							<div class="ticket-booking">
								<div class="event-ticket ticket-form">
									<div class="event-ticket-left">
										<div class="ticket-id"><?php echo esc_attr($solicitor_reg_id); ?></div>
										<div class="ticket-handle"></div>
										<div class="ticket-cuts ticket-cuts-top"></div>
										<div class="ticket-cuts ticket-cuts-bottom"></div>
									</div>
									<div class="event-ticket-right">
										<div class="event-ticket-right-inner">
											<div class="row">
												<div class="col-md-9 col-sm-9">
													<span class="registerant-info">
                          								<?php echo esc_attr($solicitor_reg_user); ?>
													</span>
													 <span class="meta-data"><?php esc_html_e('Event','solicitor'); ?></span>
													 <h4 id="dy-event-title"><?php echo get_the_title(); ?></h4>
												</div>
												<div class="col-md-3 col-sm-3">
													<span class="ticket-cost"><?php echo esc_attr($paypal_currency); echo esc_attr($payment_gross); ?></span>
												</div>
											</div>
											<div class="event-ticket-info">
												<div class="row">
													<div class="col">
														<p class="ticket-col" id="dy-event-date"><?php echo esc_attr($solicitor_event_date); ?></p>
													</div>
													<div class="col">
														<p class="ticket-col event-location" id="dy-event-location"><?php echo esc_attr($venue_title); ?></p>
													</div>
													<div class="col">
														<p id="dy-event-time"><?php echo esc_attr($solicitor_event_time); ?></p>
													</div>
												</div>
											</div>
											<span class="event-area"></span>
											<div class="row">
												<div class="col-md-12">
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default inverted" data-dismiss="modal"><?php esc_html_e('Close', 'solicitor'); ?></button>
						<button type="button" class="btn btn-primary" onClick="window.print()"><?php esc_html_e('Print', 'solicitor'); ?></button>
					</div>
				</div>
			</div>
		</div>
<?php
} wp_footer(); ?>
</body>
</html>