<?php
get_header();
$options = get_option('solicitor_options');
$page_title = (isset($options['page_404_title']))?$options['page_404_title']:'';
$page_content = (isset($options['page_404_content']))?$options['page_404_content']:'';
$page_404_banner = (isset($options['page_404_banner']['url']))?$options['page_404_banner']['url']:'';
if($page_404_banner != ''){
	$page_404_banner = $page_404_banner;
} else {
	$default_header = (isset($options['solicitor_default_banner']['url']))?$options['solicitor_default_banner']['url']:'';
}
?>
<div class="hero-area">
    	<div class="page-header" style="background-image:url(<?php echo esc_url($default_header); ?>);">
        	<div class="container">
            	<div class="page-header-text"><div><div>
        			<h1><?php if($page_title != '') { echo esc_attr($page_title); } else { echo esc_html__('404 Error!', 'solicitor'); } ?></h1>
                </div></div></div>
            </div>
        </div>
    </div>
    <!-- Start Body Content -->
  	<div class="main" role="main">
    	<div id="content" class="content full">
    		<div class="container">
            	<div class="row">
                	<!-- Posts List -->
                    <div class="col-md-8 col-md-offset-2 col-sm-8 col-sm-offset-2">
                    	<!-- Post -->
                        <article class="page-404">
                        	<?php if($page_content != ''){
								global $allowed_tags;
								echo wp_kses($page_content, $allowed_tags);
							} else { ?>
                          	<div class="text-align-center">
                               	<strong><?php echo esc_html__('Sorry - Page Not Found!', 'solicitor'); ?></strong></p>
								<?php echo esc_html__('The page you are looking for was moved, removed, renamed', 'solicitor'); ?><br><?php echo esc_html__('or might never existed. You stumbled upon a broken link.', 'solicitor'); ?>
                      		</div>
                            <?php } ?>
                        </article>
                    </div>
                </div>
            </div>
        </div>
   	</div>
    <!-- End Body Content -->
<?php get_footer(); ?>