jQuery.fn.matemoji = function(icon_folder) {
    /* emoticons is the folder where the emoticons are stored*/
    var icon_folder = icon_folder || "emoji";
    //var settings = jQuery.extend({emoticons: "emoticons"}, options);
    /* keys are the emoticons
     * values are the ways of writing the emoticon
     *
     * for each emoticons should be an image with filename
     * 'face-emoticon.png'
     * so for example, if we want to add a cow emoticon
     * we add "cow" : Array("(C)") to emotes
     * and an image called 'face-cow.png' under the emoticons folder   
     */
    var emojis = {"smile": Array(":-)",":)","=]","=)"),
                  "sad": Array(":-(","=(",":[",":&lt;"),
                  "wink": Array(";-)",";)",";]","*)"),
                  "grin": Array(":D","=D","XD","BD","8D","xD"),
                  "surprise": Array(":O","=O",":-O","=-O"),
                  "devilish": Array("(6)"),
                  "angel": Array("(A)"),
                  "crying": Array(":'(",":'-("),
                  "plain": Array(":|"),
                  "smile-big": Array(":o)"),
                  "glasses": Array("8)","8-)"),
                  "kiss": Array("(K)",":-*"),
				  "heart": Array("(H)"),
                  "monkey": Array("(M)")};
                  
    /* Replaces all ocurrences of emoticons in the given html with images
     */
    function matemoji(html){
        for(var emoji in emojis){
            for(var i = 0; i < emojis[emoji].length; i++){
                /* css class of images is emoticonimg for styling them*/
                html = html.replace(emojis[emoji][i],"<img src=\""+icon_folder+"/face-"+emoji+".png\" class=\"emoticonimg\" alt=\""+emojis[emoji][i]+"\"/>","g");
            }
        }
        return html;
    }
    return this.each(function(){
        $(this).html(matemoji($(this).html()));
    });
};
