<?php

function htmlcode($orimessage) {
	$base_url='http://localhost:8888/';
	// convert to unix new lines
	$message= preg_replace("/\r\n|\r|\n/", ' ', $orimessage);
	$s = array ("<", ">");
	$z = array ("&lt;","&gt;");
	$message = str_replace($s, $z, $message);
	$message=trim(str_replace("\\n", "<br/>", $message));

	// Collapse many <br> to one
	$message = preg_replace('/(<br\s*\/?\s*>\s*)*(<br\s*\/?\s*>)/', '<br>', $message); 

	// hashtag replacement is last
	$regex = "/#+([a-zA-Z0-9_]+)/";
	// mention replacement is last
	$regex_mention = "/@+([a-zA-Z0-9_]+)/";
	// hashtag link
	$message = preg_replace($regex, '<a href="hashtag.php?tag=$1">$0</a>', $message);
	// mention link
    $message = preg_replace($regex_mention, '<a href="'.$base_url.'$1">$0</a>', $message);
	return htmlspecialchars(stripslashes($message), ENT_QUOTES, "UTF-8");
}

function htmlcode_nolink($orimessage){
	// Remove link and other tags first
	$message = strip_tags($orimessage, '<br><br/>');
    // Convert the bad \\n to \n
    $message = str_replace("\\n","\n",$message);

	$message = preg_replace('/(<br\s*\/?\s*>\s*)*(<br\s*\/?\s*>)/', '<br>', $message); 

	return htmlspecialchars(stripslashes($message), ENT_QUOTES, "UTF-8");
}
function htmlcodecomment($orimessage) {
	$base_url='http://localhost:8888/';
	// convert to unix new lines
	$message= preg_replace("/\r\n|\r|\n/", ' ', $orimessage);
	$s = array ("<", ">");
	$z = array ("&lt;","&gt;");
	$message = str_replace($s, $z, $message);
	$message=trim(str_replace("\\n", "<br/>", $message));
    
	// Collapse many <br> to one
	$message = preg_replace('/(<br\s*\/?\s*>\s*)*(<br\s*\/?\s*>)/', ' ', $message); 
	$regex_mention = "/@+([a-zA-Z0-9_]+)/";
    $message = preg_replace($regex_mention, '<a href="'.$base_url.'$1">$0</a>', $message);
	return htmlspecialchars(stripslashes($message), ENT_QUOTES, "UTF-8");
}
 function hashtag($orimessage){
  //filter the hastag
  preg_match_all('/(^|[^a-z0-9_])#([a-z0-9_]+)/i', $orimessage, $matched_hashtag);
  $hashtag = '';
  //if hashtag found
  if(!empty($matched_hashtag[0])){
   //fetch hastag from the array
   foreach ($matched_hashtag[0] as $matched) {
    //append every hastag to a string
    //remove the # by preg_replace function
    $hashtag .= preg_replace('/[^a-z0-9]+/i', '', $matched).',';
    //append and , after every hashtag
   }
  }
  //remove , from the last hashtag
  return rtrim($hashtag, ',');
 }
 
 function mention($orimessage){
  //filter the mention
  preg_match_all('/(^|[^a-z0-9_])@([a-z0-9_]+)/i', $orimessage, $matched_mention);
  $p_mentions = '';
  //if mention found
  if(!empty($matched_mention[0])){
   //fetch mention from the array
   foreach ($matched_mention[0] as $p_mention) {
    //append every mention to a string
    //remove the @ by preg_replace function
    $p_mentions .= preg_replace('/[^a-z0-9]+/i', '', $p_mention).',';
    //append and , after every mention
   }
  }
  //remove , from the last mention
  return rtrim($p_mentions, ',');
 }
 

?>