<?php

  include ("$www_dir/classes/users.class.php");
  $SBBUsers = new SBBUsers;

  $SBBUsers->UserList();

  $NAV_PAGES = array();
  
  //Template Variables
  $HEADLINE = lang("userlist");
  $DESCR_JOININGDATE = lang("joingdate");
  $DESCR_CONTACT = lang("contact_member");
  $DESCR_POSTS = lang("posts");
  $IMG_EMAILTITLE = lang("btn_email");
  $IMG_PM_TITLE = lang("btn_pm");
  
  for ($i=0;$i<$SBBUsers->count;$i++) {
    $row = $SBBUsers->users[$i];
    $USERS[] = array("USER_ID" => $row->id,
                     "USER_LINK" => ($board_config->seo ? "$main_path/sbb-user" . $row->id . adddescr2link($row->user) . ".html" : "$main_script?todo=showprofile&amp;uid=" . $row->id),
                     "USER_LINK_WEBSITE" => $row->website,
                     "USER_LINK_SENDMAIL" => ($board_config->seo ? "$main_path/sbb-sendmail" . $row->id . ".html" : "$main_script?todo=sendmail&amp;uid=" . $row->id), 
                     "USER_LINK_PM" => ($board_config->seo ? "$main_path/sbb-sendpm" . $row->id . ".html" : "$main_script?todo=sendpm&amp;uid=" . $row->id), 
                     "USER_NAME" => $row->user,
                     "USER_STAT_CLASS" => (!$row->status ? "offline" : ""),
                     "USER_CLASS" => nick_class($row->is_admin, $row->is_mod),
                     "USER_JOININGDATE" => date($date_format, strtotime($row->created)),
                     "USER_POSTS" => intval($row->userposts),
                     "USER_STATUS" => $row->status,
                     "IMG_CONTROL_ADD2" => ($row->status ? "stop" : "play"),
                     "USER_CONTACT" => $row->usermail ? true : false,
                     );
  }

  //OrderBy-LinkPrefixes
  $LINK_ORDERBY_PREFIX = ($board_config->seo ? "$main_path/sbb-users.html?orderby=" : "$main_script?todo=showusers&amp;orderby=");
  //OrderBy-Indicator
  $IMG_ORDERBY_NICKNAME_SRC = ($SBBUsers->orderbyusers == "nickname" ? "$template_path/images/icons/orderby_" . $SBBUsers->orderbydir . ".png" : "$rel_path/images/spacer.png");
  $IMG_ORDERBY_JOINED_SRC = (!$SBBUsers->orderbyusers ? "$template_path/images/icons/orderby_" . $SBBUsers->orderbydir . ".png" : "$rel_path/images/spacer.png");

  //pagination
  $LINK_PAGE_PREFIX = ($board_config->seo ? "$main_path/sbb-users.html?p=" : "$main_script?todo=showusers&amp;p=");
  $NAV_PAGES = pagination2ndGen($SBBUsers->pages,$SBBUsers->p);
  
  /************
   * initiate template and assign variables
   ************/ 

  $showusersVARS = array('HEADLINE' => $HEADLINE,
                        'DESCR_JOININGDATE' => $DESCR_JOININGDATE,
                        'DESCR_POSTS' => $DESCR_POSTS,
                        'IMG_EMAILTITLE' => $IMG_EMAILTITLE,
                        'IMG_CONTROLTITLE' => $IMG_CONTROLTITLE,
                        'LINK_PAGE_PREFIX' => $LINK_PAGE_PREFIX,
                        'IMG_PM_TITLE' => $IMG_PM_TITLE,
                        'DESCR_CONTACT' => $DESCR_CONTACT,
                        'LINK_ORDERBY_PREFIX' => $LINK_ORDERBY_PREFIX,
                        'IMG_ORDERBY_NICKNAME_SRC' => $IMG_ORDERBY_NICKNAME_SRC,
                        'IMG_ORDERBY_JOINED_SRC' => $IMG_ORDERBY_JOINED_SRC,
                        'ORDERBY_NICKNAME' => $SBBUsers->orderbyusers == "nickname",
                        'ORDERBY_JOINED' => !$SBBUsers->orderbyusers,
                        'ORDERBY_ASC' => $SBBUsers->orderbydir == "asc",

                        'CONF' => $GLOBAL_TEMPLATE_VARS,
                        'FLAGS' => $TEMPLATE_FLAGS,
                        'NAV_PAGES' => $NAV_PAGES,
                        'USERS' => $USERS
                        );

    $QuickSkin = new QuickSkin("showusers.html");
    $QuickSkin->assign($showusersVARS);
    $content .= $QuickSkin->result();
    unset($QuickSkin);

?>