<?php
  // used for registering and for profile selfediting
  if ($forum_user && (!$action)) {
    $fuser = $forum_user->user;
    $femail = $forum_user->email;
    $fusermail = $forum_user->usermail;
    $fforummail = $forum_user->forummail;
    $signature = $forum_user->signature;
    $website = $forum_user->website;
    $interests = $forum_user->interests;
    $occupation = $forum_user->occupation;
    $location = $forum_user->location;
    $birthday = $forum_user->birthday;
    $gravatar = $forum_user->gravatar;
  }

  if (!$forum_user) {
  
    if ($board_config->en_registering) {
      $TEMPLATE_FLAGS["SHOWFORM"] = true;
    }
  
    //Template Variables
    $TABLE_HEADLINE = lang("createaccount");
    $DESCR_SUBMIT = lang("createaccount");

    if ($show_login && !$hide_login_form) {
      //if the login_form should be displayed on the registering page too
      $loginVARS = array('DESCR_PASS' => lang("password"),
                   'LOGIN_INTROTEXT' => lang("login_intro"),
                   'REGISTER_LINKING' => $REGISTER_LINKING,
                   'FORM_VAL_FUSER' => he($fuser),
                   'DESCR_LOGIN' => lang("login"),
                   'DESCR_NICKNAME' => lang("nickname"));
       
      $QuickSkin = new QuickSkin("login.html");
      $QuickSkin->assign(array_merge($loginVARS,array("CONF" => $GLOBAL_TEMPLATE_VARS)));
      $LOGIN_FORM = $QuickSkin->result();
      unset($QuickSkin);
    }

  } else {

    $TEMPLATE_FLAGS["SHOWFORM"] = true;
  
    //Template Variables
    $TABLE_HEADLINE = lang("editaccount");
    $DESCR_SUBMIT = lang("updateaccount");
  
    if ($birthday && $birthday != "0000-00-00") {
      list ($by,$bm,$bd) = explode("-",$birthday);
    }
    //months
    $month_options = "<option value=''>MM</option>\n";
    for ($i=1;$i<13;$i++) {
      $month_options .= "<option value='" . add0($i) . "'>" . add0($i) . "</option>\n";
    }
    //days
    $day_options = "<option value=''>DD</option>\n";
    for ($i=1;$i<32;$i++) {
      $day_options .= "<option value='" . add0($i) . "'>" . add0($i) . "</option>\n";
    }
    $bd_options = str_replace("value='$bd'","value='$bd' selected='selected'",$day_options);
    $bm_options = str_replace("value='$bm'","value='$bm' selected='selected'",$month_options);
    
    //SBB Avatars
    $avatars = avatars();
    if ($avatars) {
      $sbb_avcat_options = "<option value=''>" . lang("please_select") . "</option>\n";
      $cat_cnt = count($avatars);
      for ($i=0;$i<$cat_cnt;$i++) {
        $sbb_avcat_options .= "<option value='" . $avatars[$i]["cat"] . "'>" . $avatars[$i]["cat"] . "</option>\n";
      }
      $TEMPLATE_FLAGS["SBBAVATARS"] = true;
    }
    
  }
  
  //The Form
  
  //Template Variables
  $FORM_VAL_FUSER = he($fuser);
  if ($forum_user) $FORM_DISABLED_FUSER = "disabled='disabled'";
  $FORM_VAL_FEMAIL = $femail;
  $FORM_CHECKED_FUSERMAIL = ($fusermail ? "checked='checked'" : "");
  $FORM_CHECKED_FFORUMMAIL = ($fforummail ? "checked='checked'" : "");
  
  $FORM_VAL_SIGNATURE = $signature;
  $IMG_AVATAR_SRC = ($forum_user->avatar ? $conf_data_dir . "/" . $forum_user->id . "/avatar/" . $forum_user->avatar : "$rel_path/images/spacer.png");
  $FORM_CHECKED_DELAVATAR = ($delavatar ? "checked='checked'" : "");
  
  $FORM_CHECKED_GRAVATAR = ($gravatar ? "checked='checked'" : "");
  
  $IMG_SBBAVATAR_SRC = ($forum_user->sbb_avatar ? "$rel_path/images/avatars/" . $forum_user->sbb_avatar : "$rel_path/images/spacer.png");  
  $IMG_SBBAVATAR_VAL = ($forum_user->sbb_avatar ? "$rel_path/images/avatars/" . $forum_user->sbb_avatar : "");  
  
  $FORM_OPTIONS_SBBAVCATS = $sbb_avcat_options;
    
  $FORM_VAL_WEBSITE = $website;
  $FORM_VAL_INTERESTS = $interests;
  $FORM_VAL_OCCUPATION = $occupation;
  $FORM_VAL_LOCATION = $location;
  $FORM_OPTIONS_BD = $bd_options;
  $FORM_OPTIONS_BM = $bm_options;
  $FORM_VAL_BY = ($by==1900||!$by?"YYYY":$by);  
  
  $IMG_RELOADTITLE = lang("reloadimage");
  
  $fusermail = $forum_user->usermail;
  $fforummail = $forum_user->forummail;

  //prevent from auto registering
  //only if use_captcha is enabled and user is about to register
  if (($todo == "register" || ($action && !$forum_user)) || (!$forum_user && !$board_config->en_guest_viewing)) { 
    if ($board_config->use_cap) {
      $TEMPLATE_FLAGS["CAPTCHA"] = true;

      //Template Variables
      $DESCR_CAPTCHA = lang("captcha_descr");
      $DESCR_CAPTCHAINFOS = lang("captcha_info");
      $DESCR_CAPTCHACODE = lang("captcha_code");
      $FORM_VAL_SID = md5(uniqid(time()));
      
      $TEMPLATE_FLAGS["CAP" . $board_config->use_cap] = true;

      //recaptcha
      if ($board_config->use_cap == 3) {
        $RECAPTCHA_OUTPUT = "<script type='text/javascript'>var RecaptchaOptions = {theme:'" . $board_config->recaptcha_style . "'};</script>";
        require_once('recaptchalib.php');
        $RECAPTCHA_OUTPUT .= recaptcha_get_html($board_config->recaptcha_pubkey);
      } else {
        $TEMPLATE_FLAGS["SHOWCAPCODE"] = true;
      }   
      
    }
  }

  //more setting while registering
  if ($f_auth_uid) $TEMPLATE_FLAGS["MORESETTINGS"] = true;
  //avatar part if enabled
  if ($board_config->en_avatar) $TEMPLATE_FLAGS["AVATARSETTINGS"] = true;
  //gravatar part if enabled
  if ($board_config->en_gravatar) $TEMPLATE_FLAGS["GRAVATAR"] = true;

  /************
   * initiate template and assign variables
   ************/
  $editaccountVARS = array('REGISTER_INTRO_TEXT' => !$forum_user ? lang("join_intro") : "",
                          'TABLE_HEADLINE' => $TABLE_HEADLINE,
                          'LOGIN_FORM' => $LOGIN_FORM,
                          'DESCR_PASS' => lang("password"),
                          'DESCR_PASSCONF' => lang("confpassword"),
                          'DESCR_SETTINGS' => lang("moresettings"),
                          'DESCR_FUSERMAIL' => lang("acceptumails"),
                          'DESCR_FFORUMMAIL' => lang("acceptbmails"),
                          'DESCR_SUBMIT' => $DESCR_SUBMIT,
                          'DESCR_CAPTCHA' => $DESCR_CAPTCHA,
                          'DESCR_CAPTCHAINFOS' => $DESCR_CAPTCHAINFOS,
                          'DESCR_CAPTCHACODE' => $DESCR_CAPTCHACODE,
                          'DESCR_SIGNATURE' => lang("signature"),
                          'DESCR_AVATAR' => lang("avatar"),
                          'DESCR_AVATARINFOS' => sprintf(lang("avatar_dimensions"), $board_config->avatar_width, $board_config->avatar_height),
                          'DESCR_SBBAVATAR' => lang("sbbavatar"),
                          'DESCR_SBBAVATARINFOS' => lang("sbbavatar_infos"),
                          'DESCR_DELAVATAR' => lang("delavatar"),
                          'IMG_RELOADTITLE' => $IMG_RELOADTITLE,
                          'DESCR_WEBSITE' => lang("website"),
                          'DESCR_INTERESTS' => lang("interests"),
                          'DESCR_OCCUPATION' => lang("occupation"),
                          'DESCR_LOCATION' => lang("location"),
                          'DESCR_BIRTHDAY' => lang("birthday"),
                          'DESCR_YEAR' => lang("year"),
                          'DESCR_MONTH' => lang("month"),
                          'DESCR_DAY' => lang("day"),
                          'DESCR_SBBAVATARGAL' => lang("descr_avatargal"),
                          'DESCR_NICKNAME' => lang("nickname"),
                          'DESCR_LOGIN' => lang("login"),
                          'FORGOTTEN_LINKING' => sprintf(lang("login_forgotten"), "$main_script?todo=reset_password"),
                          'DESCR_GRAVATAR' => lang("descr_gravatar"),
                          'DESCR_EN_GRAVATAR' => lang("descr_en_gravatar"),
                          'FORM_OPTIONS_BD' => $FORM_OPTIONS_BD,
                          'FORM_OPTIONS_BM' => $FORM_OPTIONS_BM,
                          'FORM_VAL_BY' => $FORM_VAL_BY,
                          'FORM_VAL_WEBSITE' => $FORM_VAL_WEBSITE,
                          'FORM_VAL_INTERESTS' => $FORM_VAL_INTERESTS,
                          'FORM_VAL_OCCUPATION' => $FORM_VAL_OCCUPATION,
                          'FORM_VAL_LOCATION' => $FORM_VAL_LOCATION,
                          'FORM_CHECKED_GRAVATAR' => $FORM_CHECKED_GRAVATAR,
                          'FORM_OPTIONS_SBBAVCATS' => $FORM_OPTIONS_SBBAVCATS,
                          'IMG_SBBAVATAR_VAL' => $IMG_SBBAVATAR_VAL,
                          'FORM_VAL_FUSER' => $FORM_VAL_FUSER,
                          'FORM_VAL_FEMAIL' => $FORM_VAL_FEMAIL,
                          'FORM_CHECKED_FUSERMAIL' => $FORM_CHECKED_FUSERMAIL,
                          'FORM_CHECKED_FFORUMMAIL' => $FORM_CHECKED_FFORUMMAIL,
                          'FORM_VAL_SID' => $FORM_VAL_SID,
                          'FORM_VAL_SIGNATURE' => $FORM_VAL_SIGNATURE,
                          'FORM_CHECKED_DELAVATAR' => $FORM_CHECKED_DELAVATAR,
                          'IMG_AVATAR_SRC' => $IMG_AVATAR_SRC,
                          'IMG_SBBAVATAR_SRC' => $IMG_SBBAVATAR_SRC,
                          'FORM_DISABLED_FUSER' => $FORM_DISABLED_FUSER,
                          'DESCR_EMAIL' => lang("email"),
                          'RECAPTCHA_OUTPUT' => $RECAPTCHA_OUTPUT
                          );

          $QuickSkin = new QuickSkin("edit_account.html");
          $QuickSkin->assign(array_merge($editaccountVARS,array("CONF" => $GLOBAL_TEMPLATE_VARS),array("FLAGS" => $TEMPLATE_FLAGS)));
          $content .= $QuickSkin->result();
          unset($QuickSkin);

?>