<?php

  include ("$www_dir/classes/users.class.php");
  $SBBUsers = new SBBUsers;

  $TABLE_HEADLINE = lang("tab_adminboard");
  $FORUMS_HEADLINE = lang("tab_adminforums");
  $USERS_HEADLINE = lang("tab_adminusers");
  $USERRANKS_HEADLINE = lang("tab_adminuserranks");
  
  $LINK_BOARD = ($board_config->seo ? "$main_path/sbb-admin.html" : "$main_script?todo=admin");
  $LINK_FORUMS = ($board_config->seo ? "$main_path/sbb-admin-forums.html" : "$main_script?todo=adminforums");
  $LINK_USERS = ($board_config->seo ? "$main_path/sbb-admin-users.html" : "$main_script?todo=adminusers");
  $LINK_USERRANKS = ($board_config->seo ? "$main_path/sbb-admin-userranks.html" : "$main_script?todo=adminuserranks");

  $sbb_add2title .= " - " . he(lang("tab_adminusers"));
  
  
  //Template Variables
  $HEADLINE = lang("userlist");
  $DESCR_JOININGDATE = lang("joingdate");
  $DESCR_LASTLOGIN = lang("lastlogin");
  $DESCR_POSTS = lang("posts");
  $DESCR_CONTACT_MEMBER = lang("contact_member");
  $IMG_EMAILTITLE = lang("btn_email");
  $IMG_CONTROLTITLE = lang("chgstat");  
  $IMG_PM_TITLE = lang("btn_pm");
  
  $BACK = lang("back");
  
  /**********
   * List all users [+]
   **********/
    if (!$section) {
      $TEMPLATE_FLAGS["SHOWUSERS"] = true;
      
      $SENDMAIL2ALL = lang("sendtoall");
      $ADDUSER = lang("adduser");
    
      //$SBBUsers->uper_page = 35;
      $SBBUsers->UserList();
       
      $REGISTERED_USERS_HEADLINE =lang("regusers");
      
      $CONFIRM_DELFORUM = lang("conf_delforum");
      
      if ($board_config->en_user_mess) $TEMPLATE_FLAGS["MAILCOL"] = true;
    
      for ($i=0;$i<$SBBUsers->count;$i++) {
        $row = $SBBUsers->users[$i];
        $USERS[] = array("USER_ID" => $row->id,
                         "USER_LINK" => ($board_config->seo ? "$main_path/sbb-user" . $row->id . adddescr2link($row->user) . ".html" : "$main_script?todo=showprofile&amp;uid=" . $row->id),
                         "USER_LINK_SENDMAIL" => ($board_config->seo ? "$main_path/sbb-sendmail" . $row->id . ".html" : "$main_script?todo=sendmail&amp;uid=" . $row->id), 
                         "USER_LINK_PM" => ($board_config->seo ? "$main_path/sbb-sendpm" . $row->id . ".html" : "$main_script?todo=sendpm&amp;uid=" . $row->id), 
                         "USER_NAME" => $row->user,
                         "USER_STAT_CLASS" => (!$row->status ? "offline" : ""),
                         "USER_CLASS" => nick_class($row->is_admin, $row->is_mod),
                         "USER_JOININGDATE" => date($date_format, strtotime($row->created)),
                         "USER_LASTLOGIN" => ($row->last_login ? date($date_format, strtotime($row->last_login)) : "-"),
                         "USER_POSTS" => intval($row->userposts),
                         "USER_STATUS" => $row->status,
                         "IMG_CONTROL_ADD2" => ($row->status ? "stop" : "play"),
                         "USER_CONTACT" => $row->usermail ? true : false,
                         "USER_DELETEABLE" => $row->deleteable ? true : false,
                         );
      }
      
      //OrderBy-LinkPrefixes
      $LINK_ORDERBY_PREFIX = "$main_script?todo=adminusers&amp;orderby=";
      //OrderBy-Indicator
      $IMG_ORDERBY_NICKNAME_SRC = ($SBBUsers->orderbyusers == "nickname" ? "$template_path/images/icons/orderby_" . $SBBUsers->orderbydir . ".png" : "$rel_path/images/spacer.png");
      $IMG_ORDERBY_JOINED_SRC = (!$SBBUsers->orderbyusers ? "$template_path/images/icons/orderby_" . $SBBUsers->orderbydir . ".png" : "$rel_path/images/spacer.png");
      $IMG_ORDERBY_LASTLOGIN_SRC = ($SBBUsers->orderbyusers == "lastlogin" ? "$template_path/images/icons/orderby_" . $SBBUsers->orderbydir . ".png" : "$rel_path/images/spacer.png");
      
      //pagination
      $LINK_PAGE_PREFIX = "$main_script?todo=adminusers&amp;p=";
      $NAV_PAGES = pagination2ndGen($SBBUsers->pages,$SBBUsers->p);

    }
  /**********
   * List all users [-]
   **********/     
  
  
  /**********
   * Send message to all users [+]
   **********/     
    if ($section == "sendmail2all") {
      $TEMPLATE_FLAGS["SENDMAIL2ALL"] = true;
      //get usernames
      $sql = "select * from " . $ftable_prefix . "users where status = '1' order by id;";
      $res = dbquery($sql);
      while ($row = mysql_fetch_object($res)) {
        $users[] = $row->user;
      }
          
      $SENDMAIL2ALL_HEADLINE = lang("hl_sendtoall");
  
      //Template Vars
      $USER_NAMES = implode(", ",$users);
      
      $FORM_HEADLINE = sprintf(lang("send_mail_to"), "...");
      $DESCR_RCPT = lang("rcpt");
      $DESCR_SUBJECT = lang("subject");
      $DESCR_MESSAGE = lang("your_message");
      $DESCR_MESSAGEINFOS = lang("messageinfo");
      $DESCR_SUBMIT = lang("send_message");
      
      $FORM_VAL_SUBJECT = $subject;
      $FORM_VAL_MESSAGE = $message;
    }
  /**********
   * Send message to all users [-]
   **********/     
  
  
  /**********
   * Edit single user [+]
   **********/     
    if ($section == "edit") {
      $TEMPLATE_FLAGS["EDITUSER"] = true;
      $uid = intval($_REQUEST["uid"]);
      $this_user = forum_user($uid);
      
      if ($uid && !$this_user) {
      
        //Template Variables
        $USER_NOT_FOUND = lang("usernotfound");
      
      } else {

        $TEMPLATE_FLAGS["SHOWEDITFORM"] = true;
      
        if ($uid && !$action) {
          $fuser = $this_user->user;
          $femail = $this_user->email;
          $fusermail = $this_user->usermail;
          $fforummail = $this_user->forummail;
          $fis_mod = $this_user->is_mod;
          $fis_admin = $this_user->is_admin;
          $fstatus = $this_user->status;
          if ($fis_admin) $userlevel = "is_admin";
          elseif ($fis_mod) $userlevel = "is_mod";
          else $userlevel = "is_default";
          $signature = $this_user->signature;
          $website = $this_user->website;
          $interests = $this_user->interests;
          $occupation = $this_user->occupation;
          $location = $this_user->location;
          $birthday = $this_user->birthday;
          $rank_id = $this_user->rank_id;
        }
        if (!$userlevel) $userlevel = "is_default";
        $age = $this_user->age;
        $fstatus_checked[intval($fstatus)] = "checked='checked'";
        $userlevel_checked[$userlevel] = "checked='checked'";
        
        if ($birthday && $birthday != "0000-00-00") {
          list ($by,$bm,$bd) = explode("-",$birthday);
          if (!$age) $by = "1900";
        }
        //months
        $month_options = "<option value=''>MM</option>\n";
        for ($i=1;$i<13;$i++) {
          $month_options .= "<option value='" . add0($i) . "'>" . add0($i) . "</option>\n";
        }
        //days
        $day_options = "<option value=''>DD</option>\n";
        for ($i=1;$i<32;$i++) {
          $day_options .= "<option value='" . add0($i) . "'>" . add0($i) . "</option>\n";
        }
        $bd_options = str_replace("value='$bd'","value='$bd' selected='selected'",$day_options);
        $bm_options = str_replace("value='$bm'","value='$bm' selected='selected'",$month_options);
        
        //ranks
        if (!$userrank) {
          $NO_RANKS_DEFINED = lang("no_ranks_defined");
        } else {
          $rank_options = "<option value='0'>" . lang("no_rank") . "</option>\n";
          while (list($key, $val) = each($userrank)) {
            $rank_options .= "<option value='$key'>" . $val->descr . "</option>\n";
          }
        }
        $rank_options = str_replace("value='$rank_id'","value='$rank_id' selected='selected'",$rank_options);
        
        //Template Variables
        $EDIT_USER_HEADLINE = sprintf(lang("hl_edituser"), $this_user->user);

        $USER_ID = $uid;
        $USER_NAME = $this_user->user;
        $FORM_VAL_FUSER = he($fuser);
        $FORM_VAL_FEMAIL = $femail;
        $DESCR_PASS = lang("password");
        $DESCR_PASSCONF = lang("confpassword");    
        $DESCR_SETTINGS = lang("moresettings");
        $DESCR_FUSERMAIL = lang("acceptumails");
        $DESCR_FFORUMMAIL = lang("acceptbmails");
        $DESCR_MORESETTINGS = lang("morefunctions");
        $DESCR_DELUSER = lang("deluser");
        $DESCR_KEEPPOSTS = lang("keepposts");
        $DESCR_DELPOSTS = lang("delposts");
        $DESCR_SIGNATURE = lang("signature");
        $DESCR_AVATAR = lang("avatar");
        $DESCR_DELAVATAR = lang("delavatar");
        
        $DESCR_WEBSITE = lang("website");
        $DESCR_INTERESTS = lang("interests");
        $DESCR_OCCUPATION = lang("occupation");
        $DESCR_LOCATION = lang("location");
        $DESCR_BIRTHDAY = lang("birthday");
        $DESCR_YEAR = lang("year");
        $DESCR_MONTH = lang("month");
        $DESCR_DAY = lang("day");
        
        $DESCR_USERRANK = lang("user_rank");
        $FORM_OPTIONS_RANK_ID = $rank_options;
        
        $FORM_CHECKED_FFORUMMAIL = ($fforummail ? "checked='checked'" : "");
        $FORM_CHECKED_FUSERMAIL = ($fusermail ? "checked='checked'" : "");
        $FORM_CHECKED_STATON = $fstatus_checked[1];
        $FORM_CHECKED_STATOFF = $fstatus_checked[0];
        $FORM_CHECKED_LVLADM = $userlevel_checked["is_admin"];
        $FORM_CHECKED_LVLMOD = $userlevel_checked["is_mod"];
        $FORM_CHECKED_LVLDEF = $userlevel_checked["is_default"];
        
        $FORM_VAL_SIGNATURE = $signature;
        $IMG_AVATAR_SRC = ($this_user->avatar ? $conf_data_dir . "/" . $this_user->id . "/avatar/" . $this_user->avatar : "$rel_path/images/spacer.png");
        $FORM_CHECKED_DELAVATAR = ($delavatar ? "checked='checked'" : "");
        $FORM_VAL_AVATAR = $this_user->avatar;
        
        $FORM_VAL_WEBSITE = $website;
        $FORM_VAL_INTERESTS = $interests;
        $FORM_VAL_OCCUPATION = $occupation;
        $FORM_VAL_LOCATION = $location;
        $FORM_OPTIONS_BD = $bd_options;
        $FORM_OPTIONS_BM = $bm_options;
        $FORM_VAL_BY = ($by==1900||!$by?"YYYY":$by);
        
        $USER_DELETEABLE = true;
        if (!$this_user->deleteable && $uid) {
          //user cannot be deleted, disable fields, hide deletingblock
          $FORM_DISABLE = "disabled='disabled'";
          $USER_DELETEABLE = false;
        }
        if (!$uid) $USER_DELETEABLE = false;
        
        $USERFORMBUTTON = lang($uid ? "updateuser" : "adduser");
    
      }
    }
  /**********
   * Edit single user [-]
   **********/     
  
 
  /************
   * initiate template and assign variables
   ************/      

   $adminusersVARS = array('TABLE_HEADLINE' => $TABLE_HEADLINE,
                          'FORUMS_HEADLINE' => $FORUMS_HEADLINE,
                          'LINK_BOARD' => $LINK_BOARD,
                          'USERS_HEADLINE' => $USERS_HEADLINE,
                          'LINK_USERS' => $LINK_USERS,
                          'REGISTERED_USERS_HEADLINE' => $REGISTERED_USERS_HEADLINE,
                          'LINK_FORUMS' => $LINK_FORUMS,
                          'BACK' => $BACK,
                          'LINK_PAGE_PREFIX' => $LINK_PAGE_PREFIX,
                          'LINK_USERRANKS' => $LINK_USERRANKS,
                          'USERRANKS_HEADLINE' => $USERRANKS_HEADLINE,
                          'NO_RANKS_DEFINED' => $NO_RANKS_DEFINED,
                          'DESCR_USERRANK' => $DESCR_USERRANK,
                          'FORM_OPTIONS_RANK_ID' => $FORM_OPTIONS_RANK_ID,

                          //listing
                          'DESCR_JOININGDATE' => $DESCR_JOININGDATE,
                          'DESCR_LASTLOGIN' => $DESCR_LASTLOGIN,
                          'DESCR_POSTS' => $DESCR_POSTS,
                          'IMG_EMAILTITLE' => $IMG_EMAILTITLE,
                          'IMG_CONTROLTITLE' => $IMG_CONTROLTITLE,
                          'SENDMAIL2ALL' => $SENDMAIL2ALL,
                          'ADDUSER' => $ADDUSER,
                          'USERFORMBUTTON' => $USERFORMBUTTON,
                          'DESCR_CONTACT_MEMBER' => $DESCR_CONTACT_MEMBER,
                          'IMG_PM_TITLE' => $IMG_PM_TITLE,
                          'LINK_ORDERBY_PREFIX' => $LINK_ORDERBY_PREFIX,
                          'IMG_ORDERBY_NICKNAME_SRC' => $IMG_ORDERBY_NICKNAME_SRC,
                          'IMG_ORDERBY_JOINED_SRC' => $IMG_ORDERBY_JOINED_SRC,
                          'IMG_ORDERBY_LASTLOGIN_SRC' => $IMG_ORDERBY_LASTLOGIN_SRC,
                          'ORDERBY_NICKNAME' => $SBBUsers->orderbyusers == "nickname",
                          'ORDERBY_LASTLOGIN' => $SBBUsers->orderbyusers == "lastlogin",
                          'ORDERBY_JOINED' => !$SBBUsers->orderbyusers,
                          'ORDERBY_ASC' => $SBBUsers->orderbydir == "asc",

                          //modification
                          'EDIT_USER_HEADLINE' => $EDIT_USER_HEADLINE,
                          'USER_NOT_FOUND' => $USER_NOT_FOUND,
                          'DESCR_PASS' => $DESCR_PASS,
                          'DESCR_PASSCONF' => $DESCR_PASSCONF,
                          'DESCR_SETTINGS' => $DESCR_SETTINGS,
                          'DESCR_FUSERMAIL' => $DESCR_FUSERMAIL,
                          'DESCR_FFORUMMAIL' => $DESCR_FFORUMMAIL,
                          'DESCR_MORESETTINGS' => $DESCR_MORESETTINGS,
                          'DESCR_DELUSER' => $DESCR_DELUSER,
                          'DESCR_KEEPPOSTS' => $DESCR_KEEPPOSTS,
                          'DESCR_DELPOSTS' => $DESCR_DELPOSTS,
                          'DESCR_SIGNATURE' => $DESCR_SIGNATURE,
                          'DESCR_AVATAR' => $DESCR_AVATAR,
                          'DESCR_DELAVATAR' => $DESCR_DELAVATAR,
                          'DESCR_WEBSITE' => $DESCR_WEBSITE,
                          'DESCR_INTERESTS' => $DESCR_INTERESTS,
                          'DESCR_OCCUPATION' => $DESCR_OCCUPATION,
                          'DESCR_LOCATION' => $DESCR_LOCATION,
                          'DESCR_BIRTHDAY' => $DESCR_BIRTHDAY,
                          'DESCR_YEAR' => $DESCR_YEAR,
                          'DESCR_MONTH' => $DESCR_MONTH,
                          'DESCR_DAY' => $DESCR_DAY,
                          'FORM_OPTIONS_BD' => $FORM_OPTIONS_BD,
                          'FORM_OPTIONS_BM' => $FORM_OPTIONS_BM,
                          'FORM_VAL_BY' => $FORM_VAL_BY,
                          'FORM_VAL_WEBSITE' => $FORM_VAL_WEBSITE,
                          'FORM_VAL_INTERESTS' => $FORM_VAL_INTERESTS,
                          'FORM_VAL_OCCUPATION' => $FORM_VAL_OCCUPATION,
                          'FORM_VAL_LOCATION' => $FORM_VAL_LOCATION,
                          'USER_ID' => $USER_ID,
                          'USER_NAME' => $USER_NAME,
                          'FORM_VAL_FUSER' => $FORM_VAL_FUSER,
                          'FORM_VAL_FEMAIL' => $FORM_VAL_FEMAIL,
                          'FORM_CHECKED_FUSERMAIL' => $FORM_CHECKED_FUSERMAIL,
                          'FORM_CHECKED_FFORUMMAIL' => $FORM_CHECKED_FFORUMMAIL,
                          'FORM_CHECKED_STATON' => $FORM_CHECKED_STATON,
                          'FORM_CHECKED_STATOFF' => $FORM_CHECKED_STATOFF,
                          'FORM_DISABLE' => $FORM_DISABLE,
                          'FORM_CHECKED_LVLADM' => $FORM_CHECKED_LVLADM,
                          'FORM_CHECKED_LVLMOD' => $FORM_CHECKED_LVLMOD,
                          'FORM_CHECKED_LVLDEF' => $FORM_CHECKED_LVLDEF,
                          'FORM_VAL_SIGNATURE' => $FORM_VAL_SIGNATURE,
                          'FORM_CHECKED_DELAVATAR' => $FORM_CHECKED_DELAVATAR,
                          'IMG_AVATAR_SRC' => $IMG_AVATAR_SRC,
                          'FORM_VAL_AVATAR' => $FORM_VAL_AVATAR,
                          'USER_DELETEABLE' => $USER_DELETEABLE,

                          //send message
                          'SENDMAIL2ALL_HEADLINE' => $SENDMAIL2ALL_HEADLINE,
                          'FORM_HEADLINE' => $FORM_HEADLINE,
                          'DESCR_RCPT' => $DESCR_RCPT,
                          'DESCR_SUBJECT' => $DESCR_SUBJECT,
                          'DESCR_MESSAGE' => $DESCR_MESSAGE,
                          'DESCR_MESSAGEINFOS' => $DESCR_MESSAGEINFOS,
                          'DESCR_SUBMIT' => $DESCR_SUBMIT,
                          'USER_NAMES' => $USER_NAMES,
                          'FORM_VAL_SUBJECT' => $FORM_VAL_SUBJECT,
                          'FORM_VAL_MESSAGE' => $FORM_VAL_MESSAGE,

                          //arrays
                          'CONF' => $GLOBAL_TEMPLATE_VARS,
                          'FLAGS' => $TEMPLATE_FLAGS,
                          'USERS' => $USERS,
                          'NAV_PAGES' => $NAV_PAGES
                          );

  $QuickSkin = new QuickSkin("admin-users.html");
  $QuickSkin->assign($adminusersVARS);
  $content .= $QuickSkin->result();
  unset($QuickSkin);

?>