<?php

$www_dir = realpath(dirname(__FILE__));
include_once ("$www_dir/functions.php");
include_once ("$www_dir/conf.php");

$_CONFIG['quickskin_compiled'] = $www_data_dir . "/qx_temp/";
$_CONFIG['template_dir'] = $template_path . "/";

require_once("$www_dir/classes/quickskin.class.php");

if (!$board_config->lang) $board_config->lang = "en";

include ("$www_dir/lang/" . $board_config->lang . "/common.lang.php");
include ("$www_dir/lang/" . $board_config->lang . "/messages.lang.php");
include ("$www_dir/classes/auth.class.php");
include ("$www_dir/classes/forums.class.php");
include ("$www_dir/classes/userranks.class.php");

$SBBAuth = new SBBAuth;

$SBBForums = new SBBForums;
$SBBUserranks = new SBBUserranks;

//IMPORTANT and EVERYWHERE USED Template VARIABLES
$CONF_RELPATH = $rel_path;
$CONF_MAINSCRIPT = $main_script;
$CONF_MAINPATH = $main_path;
$CONF_LANG = $f_lang;
$CONF_TEMPLATE_PATH = $template_path;
$CONF_FORUMTITLE = $f_title;
$CONF_DATAPATH = $conf_data_dir;  

$GLOBAL_TEMPLATE_VARS = array('RELPATH' => $rel_path,
                              'TEMPLATE_PATH' => $template_path,
                              'MAINSCRIPT' => $main_script, 
                              'MAINPATH' => $main_path,
                              'LANG' => $f_lang, 
                              'FORUMTITLE' => $f_title, 
                              'DATAPATH' => $conf_data_dir);
$TEMPLATE_FLAGS = array();

if (file_exists("$rel_path/setup.php")) {
  exit ("<b>The setup-file is still existing.<br /><br />
    To setup your database click <a href='$rel_path/setup.php'>here</a><br /><br/>
    If you finished your setup you have to delete or rename setup.php</b>");
}



$todo = $_REQUEST["todo"];        //handle link-wishes :)
$action = $_REQUEST["action"];    //handle actions
$section = $_REQUEST["section"];    //handle subtodos
$p = intval($_REQUEST["p"]);      //for the pages
$fid = intval($_REQUEST["fid"]);      //the forum id
$tid = intval($_REQUEST["tid"]);    //the topic id

//activations
if ($_REQUEST["ua"] || $_REQUEST["aa"]) {
  $action = "activate";
}

if ($action == "login") {
  $SBBAuth->login();
  if ($SBBAuth->error) $error[] = $SBBAuth->error;
}
if ($action == "logout") {
  $SBBAuth->logout();
}

//the forums
list ($forum,$forums) = $SBBForums->GetForumList();
//the categories
list ($category,$categories) = $SBBForums->GetCatList();
//the user ranks
$userrank = $SBBUserranks->GetRankList();


//initiate title modifications
$sbb_add2title = $f_title;
if ($forum[$fid]) $sbb_add2title .= " - " . he($forum[$fid]->title);

//update whois online infos
$SBBAuth->UpdateWIO();

$f_auth = $SBBAuth->auth;
$f_auth_uid = $SBBAuth->uid;

if (!$board_config->en_guest_viewing && !$f_auth) {
  if ($todo == "register") {
    $todo = "edit_account";
    $hide_login_form = true;
  }
  if ($todo != "login" && $todo != "reset_password") { 
    $todo = "edit_account";
    $show_login = true;
  }
}


if ($f_auth) {
  $forum_user = $SBBAuth->forum_user();
  if (!$forum_user) {
    $todo = "edit_account";
    unset ($f_auth);
    session_destroy();
    } else {
      if ($forum_user->is_admin) {
        $is_mod = $is_admin = true;
        if (!$forum_user->deleteable) $is_board_admin = true;
      }
      if ($forum_user->is_mod) $is_mod = true;
  }
}

include ("includes/actions.php");


//error and success block
if ($error || $success || $info) {
  if ($error) $ERROR = implode("<br />",$error);
  if ($success) $SUCCESS = $success;
  if ($info) $INFO = $info;
    /************
     * initiate template and assign variables
     ************/         
    $QuickSkin = new QuickSkin("status_messages.html");
    $QuickSkin->assign(array("SUCCESS" => $SUCCESS, "ERROR" => $ERROR, "INFO" => $INFO));
    $content .= $QuickSkin->result();
    unset($QuickSkin);
}



if ($f_auth) {
  $TEMPLATE_FLAGS["LOGGEDIN"] = true;
  $DESCR_PRIVATE_MESSAGES = lang("priv_messages");
  $USER_NAME = $forum_user->user;
  $PM_COUNT = $forum_user->pm_count;
  if ($is_mod) $TEMPLATE_FLAGS["ISMOD"] = true;
  if ($is_admin) $TEMPLATE_FLAGS["ISADMIN"] = true;
} else {
  $TEMPLATE_FLAGS["LOGGEDIN"] = false;
  $DESCR_REGISTER = lang("register");
}
if ($board_config->en_registering) {
  $TEMPLATE_FLAGS["ENREGISTER"] = true;
}  




if (!$todo) $todo = "show_forums";

if (!$f_auth) {
  //get fid of tid
  if ($tid) $fid = $SBBForums->GetFid($tid);
  if (in_array($todo, array("sendmail", "showpms", "sendpm", "showpm")) ||
    ($todo == "add_topic" && ((!$tid && !$forum[$fid]->allowed2post) || ($tid && !$forum[$fid]->allowed2reply)))) $todo = "login";
}

//filling the breadcrumps
$breadcrumps[] = array("link" => $main_script, "descr" => $f_title);



/****
 * forgotten password form [+]
 ****/ 
if ($todo == "reset_password" && !$f_auth) {
  include("includes/reset_password.php");
  unset($todo);
}
/****
 * forgotten password form [-]
 ****/ 


/****
 * login form [+]
 ****/
if (($action == "login" && $error) || ($todo == "login")) {
  unset($todo);
  include("includes/login.php");
}  
/****
 * login form [-]
 ****/



 
/****
 * edit/create user including loginform [+]
 ****/
if ($todo == "edit_account" || $todo == "register") {
  if (!$board_config->en_registering && !$forum_user && $_REQUEST["todo"] == "register") {
    $ERROR = "Registration disabled";
    include("includes/permission_denied.php");
  } else include("includes/edit_account.php");
}
/****
 * edit/create user including loginform [-]
 ****/
 
 
/****
 * edit user ADMINS and MODS only [+]
 ****/
if ($todo == "edituseraccount") {
  if ($is_mod) include("includes/edituseraccount.php");
  else include("includes/permission_denied.php");
}
/****
 * edit user ADMINS and MODS only [-]
 ****/

/****
 * move topic ADMINS and MODS only [+]
 ****/
if ($todo == "movetopic") {
  if ($is_mod) include("includes/move_topic.php");
  else include("includes/permission_denied.php");
}
/****
 * move topic ADMINS and MODS only [-]
 ****/


/****
 * configure board - board admin only [+]
 ****/
if ($todo == "admin") {
  if ($is_board_admin) include("includes/admin.php");
  else include("includes/permission_denied.php");
}
if ($todo == "adminforums") {
  if ($is_board_admin) include("includes/admin-forums.php");
  else include("includes/permission_denied.php");
}
if ($todo == "adminusers") {
  if ($is_board_admin) include("includes/admin-users.php");
  else include("includes/permission_denied.php");
}
if ($todo == "adminuserranks") {
  if ($is_board_admin) include("includes/admin-userranks.php");
  else include("includes/permission_denied.php");
}
/****
 * configure board - board admin only [-]
 ****/


/****
 * edit single Posts, currently only MODS and ADMINS [+]
 ****/
if ($todo == "edit_post") {
  if (has_edit_permission(intval($_REQUEST["tid"]),intval($_REQUEST["pid"]))) include("includes/edit_post.php");
  else include("includes/permission_denied.php");
}
/****
 * edit single Posts, currently only MODS and ADMINS [-]
 ****/

/****
 * view profile [+]
 ****/
if ($todo == "showprofile") {
  include("includes/showprofile.php"); 
}
/****
 * view profile [-]
 ****/

/****
 * view userlist [+]
 ****/
if ($todo == "showusers") {
  include("includes/showusers.php"); 
}
/****
 * view userlist [-]
 ****/
  
/****
 * view private messages or single private message [+]
 ****/
if ($todo == "showpms" || $todo == "showpm") {
  include("includes/private_messages.php"); 
}
/****
 * view private messages or single private message [-]
 ****/


/****
 * send mailmessage [+]
 ****/
if ($todo == "sendmail") {
  if (!$board_config->en_user_mess) {
    $ERROR = "User messaging disabled";
    include("includes/permission_denied.php");
  } else include("includes/sendmail.php"); 
}
/****
 * send mailmessage [-]
 ****/
 
 /****
 * send private message [+]
 ****/
if ($todo == "sendpm") {
  include("includes/sendpm.php"); 
}
/****
 * send private message [-]
 ****/


/****
 * view userposts [+]
 ****/
if ($todo == "search") {
  include("includes/search.php"); 
}
/****
 * view userposts  [-]
 ****/


/****
 * create posts and topics [+]
 ****/
if ($todo == "add_topic") {
  include("includes/add_topic.php");   
}
/****
 * create posts and topics [-]
 ****/
 
/****
 * view forums [+]
 ****/
if ($todo == "show_forums") {
  include("includes/show_forums.php");   
}
/****
 * view forums [-]
 ****/


/****
 * view topics [+]
 ****/
if ($todo == "show_topics") {
  include("includes/show_topics.php");   
}
/****
 * view topics [-]
 ****/


/****
 * view topic [+]
 ****/
if ($todo == "viewtopic") {
  include("includes/viewtopic.php");   
}
/****
 * view topic [-]
 ****/

//Header modifications
//maximum image width
if ($board_config->max_img_width) {
  $sbb_add2head .= "<script type='text/javascript'>
    $(window).load(function() {
      $('#sbb img').each(function() {
        if ($(this).prop('width') > " . $board_config->max_img_width . ") {
          $(this).prop('width','" . $board_config->max_img_width . "');
        }
      });
    })
    </script>";
      
}

if ($breadcrumps) {
  
  //Template Variables
  // $BREADCRUMPS = implode(" &raquo; ",$breadcrumps);
  $LINK_EDIT = ($board_config->seo ? "$main_path/sbb-edit-account.html" : "$main_script?todo=edit_account");
  $LINK_USERS = ($board_config->seo ? "$main_path/sbb-users.html" : "$main_script?todo=showusers");
  $LINK_LOGIN = ($board_config->seo ? "$main_path/sbb-login.html" : "$main_script?todo=login");
  $LINK_REGISTER = ($board_config->seo ? "$main_path/sbb-register.html" : "$main_script?todo=register");
  $LINK_LOGOUT = ($board_config->seo ? "$main_path/sbb-logout.html" : "$main_script?action=logout");
  $LINK_PM = ($board_config->seo ? "$main_path/sbb-pm.html" : "$main_script?todo=showpms");

  
  /************
   * initiate template and assign variables
   ************/
  $breadcrumpsVARS = array('BREADCRUMPS' => $breadcrumps,
                           'DESCR_SETTINGS' => lang("your_profile"),
                           'DESCR_PRIVATE_MESSAGES' => $DESCR_PRIVATE_MESSAGES,
                           'USER_NAME' => $forum_user->user,
                           'PM_COUNT' => $PM_COUNT,
                           'DESCR_REGISTER' => $DESCR_REGISTER,
                           'LINK_EDIT' => $LINK_EDIT,
                           'LINK_USERS' => $LINK_USERS,
                           'LINK_LOGIN' => $LINK_LOGIN,
                           'LINK_REGISTER' => $LINK_REGISTER,
                           'LINK_LOGOUT' => $LINK_LOGOUT,
                           'LINK_PM' => $LINK_PM);
// print_r($TEMPLATE_FLAGS);
  $QuickSkin = new QuickSkin("breadcrumps.html");
  $QuickSkin->assign(array_merge($breadcrumpsVARS,array("CONF" => $GLOBAL_TEMPLATE_VARS),array("FLAGS" => $TEMPLATE_FLAGS)));
  $breadcrupms_line = $QuickSkin->result();
  unset($QuickSkin);
}

//footer_line
/************
 * initiate template and assign variables
 ************/
$footerVARS = array('SBB_VERSION' => $version,
                    'ADMIN_LINK' => $board_config->seo ? "$main_path/sbb-admin.html" : "$main_script?todo=admin"
                   );
$QuickSkin = new QuickSkin("footer.html");
$QuickSkin->assign(array_merge($footerVARS,array("CONF" => $GLOBAL_TEMPLATE_VARS),array("FLAGS" => $TEMPLATE_FLAGS)));
$footer_line = $QuickSkin->result();
unset($QuickSkin);


//the forum wrapper starts
$sbb_forum = "<div id='sbb'>";
//the header (breadcrumps) 
$sbb_forum .= $breadcrupms_line;
//the forum itself
$sbb_forum .= $content;
//the footerline
$sbb_forum .= $footer_line;
//the end of the wrapper
$sbb_forum .= "</div>";


if ($deblang) deblang();
?>