<?php

  include ("$www_dir/classes/users.class.php");
  $SBBUsers = new SBBUsers;

  $SBBUsers->UserList();
  
  //Template Variables
  $HEADLINE = lang("userlist");
  $DESCR_JOININGDATE = lang("joingdate");
  $DESCR_CONTACT = lang("contact_member");
  $DESCR_POSTS = lang("posts");
  $IMG_EMAILTITLE = lang("send_message");
  $IMG_PM_TITLE = lang("send_pm");
  
  if (!$board_config->en_user_mess) $hide_blocks[] = "MAILCOL";
  
  for ($i=0;$i<$SBBUsers->count;$i++) {
    $row = $SBBUsers->users[$i];
    $USERS[] = array("USER_ID" => $row->id,
                     "USER_LINK" => ($board_config->seo ? "$main_path/sbb-user" . $row->id . adddescr2link($row->user) . ".html" : "$main_script?todo=showprofile&amp;uid=" . $row->id),
                     "USER_LINK_WEBSITE" => $row->website,
                     "USER_LINK_SENDMAIL" => ($board_config->seo ? "$main_path/sbb-sendmail" . $row->id . ".html" : "$main_script?todo=sendmail&amp;uid=" . $row->id), 
                     "USER_LINK_PM" => ($board_config->seo ? "$main_path/sbb-sendpm" . $row->id . ".html" : "$main_script?todo=sendpm&amp;uid=" . $row->id), 
                     "USER_NAME" => $row->user,
                     "USER_STAT_CLASS" => (!$row->status ? "offline" : ""),
                     "USER_CLASS" => nick_class($row->is_admin, $row->is_mod),
                     "USER_JOININGDATE" => date($date_format, strtotime($row->created)),
                     "USER_POSTS" => intval($row->userposts),
                     "USER_STATUS" => $row->status,
                     "IMG_CONTROL_ADD2" => ($row->status ? "stop" : "play"),
                     );
    //allow usercontacts or not
    if ($row->usermail) $hide_blocks[] = "USER_NOCONTACT" . $row->id;
    else $hide_blocks[] = "USER_CONTACT" . $row->id;
    //user urls
    if ($row->website) $hide_blocks[] = "USER_NOWEBSITE" . $row->id;
    else $hide_blocks[] = "USER_WEBSITE" . $row->id;
  }

  //OrderBy-LinkPrefixes
  $LINK_ORDERBY_PREFIX = ($board_config->seo ? "$main_path/sbb-users.html?orderby=" : "$main_script?todo=showusers&amp;orderby=");
  //OrderBy-Indicator
  $IMG_ORDERBY_NICKNAME_SRC = ($SBBUsers->orderbyusers == "nickname" ? "$template_path/images/icons/orderby_" . $SBBUsers->orderbydir . ".png" : "$rel_path/images/spacer.png");
  $IMG_ORDERBY_JOINED_SRC = (!$SBBUsers->orderbyusers ? "$template_path/images/icons/orderby_" . $SBBUsers->orderbydir . ".png" : "$rel_path/images/spacer.png");

  //pagination
  $LINK_PAGE_PREFIX = ($board_config->seo ? "$main_path/sbb-users.html?p=" : "$main_script?todo=showusers&amp;p=");
  $NAV_PAGES = pagination($SBBUsers->pages,$SBBUsers->p);
  
  //hide navblock if empty
  if (!$NAV_PAGES) $hide_blocks[] = "NAV_PAGES";


        /************
         * initiate template and assign variables
         ************/ 
        $tpl->load_file("showusers", "$template_path/showusers.html");
        $tpl->parse_loop('showusers', 'USERS');
        if ($NAV_PAGES) $tpl->parse_loop('showusers', 'NAV_PAGES');
        if ($hide_blocks) $tpl->parse_hide('showusers', $hide_blocks);
        $content .= $tpl->pget('showusers', array('CONF_MAINSCRIPT', 'CONF_RELPATH', 'CONF_LANG', 'CONF_TEMPLATE_PATH', 'CONF_FORUMTITLE',
          'HEADLINE', 'DESCR_JOININGDATE', 'DESCR_POSTS', 'IMG_EMAILTITLE', 'IMG_CONTROLTITLE', 'LINK_PAGE_PREFIX', 'IMG_PM_TITLE', 'DESCR_CONTACT', 'LINK_ORDERBY_PREFIX', 'IMG_ORDERBY_NICKNAME_SRC', 'IMG_ORDERBY_JOINED_SRC'
          ));


?>