<?php

  $uid = intval($_REQUEST["uid"]);
  $this_user = forum_user($uid);
  if (!$this_user) {
  
    //Template Variables
    $USER_NOT_FOUND = lang("usernotfound");
    $hide_blocks[] = "USERFOUND";

  } else {
    
    $this_user_post_count = forum_user_post_count($this_user->id);
    
    //Template Variables
    $hide_blocks[] = "USERNOTFOUND";
    
    if (!$is_mod) $hide_blocks[] = "ISMOD";
    //if (!$board_config->en_user_mess) $hide_blocks[] = "MAILROW";
    
    $DESCR_SHOWPROFILE = lang("showprofile") . ":";
    $DESCR_USERLEVEL =  lang("userlevel");
    $DESCR_USERMESS = lang("contact_member");
    $IMG_EMAIL_TITLE = lang("send_message");
    $IMG_PM_TITLE = lang("send_pm");
    $DESCR_JOININGDATE = lang("joingdate");
    $DESCR_POSTS = lang("posts");
    $DESCR_SHOWPOSTS = sprintf(lang("showpostsof"), $this_user->user);
    $DESCR_NOUSERMESS = lang("notification_dis");
    
    $DESCR_BIRTHDAY = lang("birthday");
    $DESCR_LOCATION = lang("location");
    $DESCR_INTERESTS = lang("interests");
    $DESCR_WEBSITE = lang("website");
    $DESCR_OCCUPATION = lang("occupation");
    $DESCR_USERRANK = lang("user_rank");
    
    $USER_NAME = $this_user->user;
    
    if ($board_config->en_avatar) {
      if ($this_user->sbb_avatar) {
        $USER_AVATAR = "$rel_path/images/avatars/" . $this_user->sbb_avatar;
      } elseif ($this_user->gravatar) {
        $USER_AVATAR = gravatar($this_user->email);
      } elseif ($this_user->avatar) {
        $USER_AVATAR = $conf_data_dir . "/" . $this_user->id . "/avatar/" . $this_user->avatar;
      } elseif ($board_config->default_avatar) {
        $USER_AVATAR = $template_path . "/images/anonymous.png";
      } else {
        $this_avatar = "$rel_path/images/spacer.png";
      }
    } else {
      $hide_blocks[] = "AVATAR";
    }
    
    if ($this_user->rank_id) {
      $USER_RANK_IMG_SRC = "$rel_path/images/ranks/" . $userrank[$this_user->rank_id]->img;
      $USER_RANK = he($userrank[$this_user->rank_id]->descr);
    } else $hide_blocks[] = "USERRANK";
            
    $USER_ID = $uid;
    $USER_CLASS = nick_class($this_user->is_admin, $this_user->is_mod);
    $USER_JOININGDATE = date($date_format, strtotime($this_user->created));
    $USER_POSTS = $this_user_post_count;
    if ($this_user->birthday) {
      $USER_BIRTHDAY = ($this_user->age ? date($board_config->date_format,strtotime($this_user->birthday)) . " (" . $this_user->age . ")" : date($board_config->date_md_format,strtotime($this_user->birthday)));
    }
    $USER_LOCATION = $this_user->location;
    if ($this_user->website) {
      $USER_WEBSITE = "<a href='" . $this_user->website . "' onclick='javascript:window.open(this.href); return false;'>" . $this_user->website . "</a>";
    }
    $USER_INTERESTS = $this_user->interests;
    $USER_OCCUPATION = $this_user->occupation;
    
    if ($this_user->is_admin) $USER_LEVEL = lang("administrator");
    elseif ($this_user->is_mod) $USER_LEVEL = lang("moderator");
    else $USER_LEVEL = lang("defaultuser");
    
    if ($this_user->usermail && $board_config->en_user_mess) {
      $hide_blocks[] = "USERNOMESS";
    } else {
      $hide_blocks[] = "USERMESS";
    }
    
    $LINK_SENDMAIL = ($board_config->seo ? "$main_path/sbb-sendmail" . $uid . ".html" : "$main_script?todo=sendmail&amp;uid=$uid");
    $LINK_USERPOSTS = ($board_config->seo ? "$main_path/sbb-userposts" . $uid . ".html" : "$main_script?todo=search&amp;w=userposts&amp;uid=$uid");
    $LINK_PM = ($board_config->seo ? "$main_path/sbb-sendpm" . $uid . ".html" : "$main_script?todo=sendpm&amp;uid=$uid");
    
    if (!$this_user_post_count) $hide_blocks[] = "USERPOSTSLINK";
  }
  
        /************
         * initiate template and assign variables
         ************/ 
        $tpl->load_file("showprofile", "$template_path/showprofile.html");
        if ($hide_blocks) $tpl->parse_hide('showprofile', $hide_blocks);
        $content .= $tpl->pget('showprofile', array('CONF_MAINSCRIPT', 'CONF_RELPATH', 'CONF_LANG', 'CONF_TEMPLATE_PATH', 'CONF_FORUMTITLE',
          'USER_NOT_FOUND', 'DESCR_SHOWPROFILE', 'DESCR_USERLEVEL', 'DESCR_USERMESS', 'IMG_EMAIL_TITLE', 'DESCR_JOININGDATE', 'DESCR_POSTS', 'DESCR_SHOWPOSTS', 'DESCR_NOUSERMESS', 'DESCR_BIRTHDAY', 'DESCR_LOCATION', 'DESCR_INTERESTS', 'DESCR_WEBSITE', 'DESCR_OCCUPATION', 'IMG_PM_TITLE', 'LINK_PM',
          'USER_ID', 'USER_NAME', 'USER_CLASS', 'USER_JOININGDATE', 'USER_POSTS', 'USER_LEVEL', 'USER_AVATAR', 'USER_BIRTHDAY', 'USER_LOCATION', 'USER_INTERESTS', 'USER_WEBSITE', 'USER_OCCUPATION',
          'LINK_SENDMAIL', 'LINK_USERPOSTS', 'DESCR_USERRANK', 'USER_RANK_IMG_SRC', 'USER_RANK'
          ));


?>