<?php

class SBBAuth {

  var $auth = false;
  var $user;
  var $uid;
  var $gid;
  var $last_login;
  var $last_visit;
  var $error;
  var $is_admin = false;
  var $watchlist = array();
  var $whoisonlineseconds = 300;  //5 minutes
  var $new_tids = array();
  
  function SBBAuth() {
    global $board_config;
    $this->board_config = $board_config;
    $this->auth = $_SESSION["SBBauth"];
    $this->user = $_SESSION["user"];
    $this->uid = $_SESSION["SBBuid"];
    $this->gid = $_SESSION["gid"];
    $this->last_login = $_SESSION["last_login"];
    $this->is_mod = $_SESSION["is_mod"];
    $this->is_admin = $_SESSION["is_admin"];
    $this->is_board_admin = $_SESSION["is_board_admin"];
    $this->new_tids = $_SESSION["new_tids"];
    $this->last_visit = $_SESSION["last_visit"];
  }
  
  function login() {
    if (!$_REQUEST["fuser"] || !$_REQUEST["fpwd"]) {
      $this->error = lang("error_nouserpass");
    } else {
      $fuser = $_REQUEST["fuser"];
      $fpwd = $_REQUEST["fpwd"];
      $sql = "select * from `" . $this->board_config->prefix . "users` where user = " . dbquote($fuser) . " and pwd = password(" . dbquote($fpwd) . ") and status = '1'";
      $res = dbquery($sql);
      if (!mysql_num_rows($res)) $this->error = lang("error_login_failed");
      else {
        $row = mysql_fetch_object($res);
        $this->auth = $_SESSION["SBBauth"] = true;
        $this->user = $_SESSION["user"] = $row->user;
        $this->uid = $_SESSION["SBBuid"] = $row->id;
        $this->last_login = $_SESSION["last_login"] = $row->last_login;
        if ($row->is_admin) {
          $this->is_mod = $_SESSION["is_mod"] = $this->is_admin = $_SESSION["is_admin"] = true;
          if (!$row->deleteable) $this->is_board_admin = $_SESSION["is_board_admin"] = true;
        }
        if ($row->is_mod) $this->is_mod = $_SESSION["is_mod"] = true;
        //set last login
        dbquery("update `" . $this->board_config->prefix . "users` set last_login = now() where id = '" . $row->id . "'");
        
        if ($row->last_visit) {
          $this->last_visit = $_SESSION["last_visit"] = $row->last_visit;
          //collect new topic ids and write them into a session array after last known appearance
          $sql = "select id from `" . $this->board_config->prefix . "question` where a_datetime > '" . $row->last_visit . "'";
          $res = dbquery($sql);
          while ($row = mysql_fetch_object($res)) {
            $new_tids[] = $row->id;
          }
          if ($new_tids) $this->new_tids = $_SESSION["new_tids"] = $new_tids;
        }
      }
    }
  }
  
  function logout() {
    session_destroy();
    $this->auth = false;
  }
  
  //update whoisonline
  function UpdateWIO() {
    //delete old entries
    $sql = "delete from `" . $this->board_config->prefix . "whoisonline` where timestampdiff(SECOND,ts,now()) > " . $this->whoisonlineseconds;
    dbquery($sql);
    $key = md5(session_id());
    //update or create new entries
    dbquery("update `" . $this->board_config->prefix . "whoisonline` set uid = '" . intval($this->uid) . "', ts = now() where `key` = '$key'");
    if (!mysql_affected_rows()) {
      dbquery("insert into `" . $this->board_config->prefix . "whoisonline` set uid = '" . intval($this->uid) . "', ts = now(), `key` = '$key'");
    }
  }
  
  //infos of the logged-in user
  function forum_user() {
    if ($this->auth) {
      $sql = "select * from `" . $this->board_config->prefix . "users` where id = '" . $this->uid . "'";
      $res = dbquery($sql);
      if (!mysql_num_rows($res)) {
        $this->auth = false;
        return false;
      } else {
        $forum_user = mysql_fetch_object($res);
        
        //count private messages
        $forum_user->pm_count = $this->pm_count();
        
        return $forum_user;
      }
    }
  }
  
  //count unread messages of logged-in user
  function pm_count() {
    $sql = "select count(id) as pm_count from `" . $this->board_config->prefix . "pm` where to_uid = '" . $this->uid . "' and seen = '0'";
    $res = dbquery($sql);
    $row = mysql_fetch_object($res);
    return intval($row->pm_count);
  }
  
  //update user's last visit in forum (for the new topics) called on forum pages (show_topics.php)
  function update_last_visit() {
    if ($this->uid) {
      $sql = "update `" . $this->board_config->prefix . "users` set last_visit = now() where id = '" . $this->uid . "'";
      dbquery($sql);
    }
  }
  
}

?>