SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

CREATE TABLE IF NOT EXISTS `servers` (
  `server_id` int(11) NOT NULL AUTO_INCREMENT,
  `server_name` varchar(255) NULL DEFAULT NULL,
  `server_desc` varchar(255) NULL DEFAULT NULL,
  `server_ip` int(10) unsigned NULL DEFAULT NULL,
  `server_script_address` varchar(255) NULL DEFAULT NULL,
  `server_added` datetime NULL DEFAULT NULL,
  `server_active` tinyint(1) NOT NULL DEFAULT '1',
  `server_last_status` text NULL DEFAULT NULL,
  `server_traffic_interface` varchar(20) NOT NULL DEFAULT 'eth0',
  PRIMARY KEY (`server_id`),
  UNIQUE KEY `server_ip_2` (`server_ip`),
  KEY `server_ip` (`server_ip`),
  KEY `server_added` (`server_added`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `servers_services`
--

CREATE TABLE IF NOT EXISTS `servers_services` (
  `lnk_id` int(11) NOT NULL AUTO_INCREMENT,
  `lnk_server_id` int(11) NULL DEFAULT NULL,
  `lnk_service_id` int(11) NULL DEFAULT NULL,
  `lnk_service_port` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`lnk_id`),
  KEY `lnk_server_id` (`lnk_server_id`),
  KEY `lnk_service_id` (`lnk_service_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
-- --------------------------------------------------------

--
-- Table structure for table `server_responses`
--

CREATE TABLE IF NOT EXISTS `server_responses` (
  `res_id` int(11) NOT NULL AUTO_INCREMENT,
  `res_time` int(11) NULL DEFAULT NULL,
  `res_server_id` int(11) NULL DEFAULT NULL,
  `res_http_code` int(11) NULL DEFAULT NULL,
  `res_ping_time` int(11) NULL DEFAULT NULL,
  `res_uptime` varchar(100) NULL DEFAULT NULL,
  `res_load` varchar(40) NULL DEFAULT NULL,
  `res_model` varchar(60) NULL DEFAULT NULL,
  `res_processes` int(11) NULL DEFAULT NULL,
  `res_memory` varchar(60) NULL DEFAULT NULL,
  `res_ethernet_speed` varchar(60) NULL DEFAULT NULL,
  `res_tx` int(11) NULL DEFAULT NULL,
  `res_rx` int(11) NULL DEFAULT NULL,
  `res_services` text,
  PRIMARY KEY (`res_id`),
  KEY `res_time` (`res_time`),
  KEY `res_server_id` (`res_server_id`),
  KEY `res_tx` (`res_tx`),
  KEY `res_rx` (`res_rx`),
  KEY `res_time_2` (`res_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `services`
--

CREATE TABLE IF NOT EXISTS `services` (
  `service_id` int(11) NOT NULL AUTO_INCREMENT,
  `service_name` varchar(255) NULL DEFAULT NULL,
  `service_default_port` int(11) NULL DEFAULT NULL,
  `service_active` tinyint(4) NOT NULL DEFAULT '1',
  `service_order` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`service_id`),
  KEY `service_active` (`service_active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `services`
--

INSERT INTO `services` (`service_id`, `service_name`, `service_default_port`, `service_active`, `service_order`) VALUES
(1, 'Apache', 80, 1, 0),
(2, 'Nginx', 80, 1, 0),
(3, 'MySQL', 3306, 1, 0),
(4, 'Memcache', 11211, 1, 0),
(5, 'Plex Media Server', 32400, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE IF NOT EXISTS `settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_unique` varchar(40) NULL DEFAULT NULL,
  `setting_display_public` tinyint(1) NOT NULL DEFAULT '1',
  `setting_save_credentials` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Save username and password for ftp-ing into remote servers',
  `setting_heartbeat_interval` int(11) NOT NULL DEFAULT '300',
  `setting_last_server_check` int(11) NULL DEFAULT NULL,
  `setting_last_cron_check` int(11) NULL DEFAULT NULL,
  `setting_high_load` int(11) NOT NULL DEFAULT '20',
  `setting_high_load_win` int(11) NOT NULL DEFAULT '20',
  `setting_cron_attempt` tinyint(4) NOT NULL DEFAULT '0',
  `setting_first_install` tinyint(1) NOT NULL DEFAULT '0',
  `setting_email_notification` varchar(255) NULL DEFAULT NULL,
  PRIMARY KEY (`setting_id`),
  KEY `setting_last_server_check` (`setting_last_server_check`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`setting_id`, `setting_unique`, `setting_display_public`, `setting_save_credentials`, `setting_heartbeat_interval`, `setting_last_server_check`, `setting_last_cron_check`, `setting_high_load`, `setting_high_load_win`, `setting_cron_attempt`, `setting_first_install`, `setting_email_notification`) VALUES
(1, '220926bec9f73cb18e534f02c7f2b8ca36ab3819', 0, 1, 0, NULL, NULL, 5, 50, 0, 0, NULL);

-- -------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_login` varchar(255) NULL DEFAULT NULL,
  `user_name` varchar(255) NULL DEFAULT NULL,
  `user_password` varchar(255) NULL DEFAULT NULL,
  `user_email` varchar(255) NULL DEFAULT NULL,
  `user_master` tinyint(4) NOT NULL DEFAULT '0',
  `user_added` datetime NULL DEFAULT NULL,
  `user_active` tinyint(4) NOT NULL DEFAULT '1',
  `last_login` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  KEY `user_active` (`user_active`),
  KEY `user_login` (`user_login`),
  KEY `user_password` (`user_password`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
