<?php
define("ET_UPDATE_PATH",    "http://www.enginethemes.com/forums/?do=product-update");
define("ET_VERSION", '1.2.1');

if(!defined('ET_URL'))
 define('ET_URL', 'http://www.enginethemes.com/');

if(!defined('ET_CONTENT_DIR'))
 define('ET_CONTENT_DIR', WP_CONTENT_DIR.'/et-content/');

define( 'TEMPLATEURL', get_template_directory_uri() );
define( 'THEME_NAME' , 'qaengine');
define( 'ET_DOMAIN'  , 'enginetheme');

if(!defined('THEME_CONTENT_DIR ')) 	define('THEME_CONTENT_DIR', WP_CONTENT_DIR . '/et-content' . '/qaengine' );
if(!defined('THEME_CONTENT_URL'))	define('THEME_CONTENT_URL', content_url() . '/et-content' . '/qaengine' );

// theme language path
if(!defined('THEME_LANGUAGE_PATH') ) define('THEME_LANGUAGE_PATH', THEME_CONTENT_DIR.'/lang/');

if(!defined('ET_LANGUAGE_PATH') )
 define('ET_LANGUAGE_PATH', THEME_CONTENT_DIR . '/lang');

if(!defined('ET_CSS_PATH') )
 define('ET_CSS_PATH', THEME_CONTENT_DIR . '/css');

require_once TEMPLATEPATH.'/includes/index.php';
require_once TEMPLATEPATH.'/mobile/functions.php';

try {
	if ( is_admin() ){
		new QA_Admin();
	} else {
		new QA_Front();
	} 
} catch (Exception $e) {
	echo $e->getMessage(); 
}

// update user data
if(!get_option( 'update_version_1_dot_2' )){
	$users = get_users();
	foreach ($users as $user) {
		//count
		$count_question = et_count_user_posts($user->ID, 'question');
		$count_answer   = et_count_user_posts($user->ID, 'answer');
		$count_point    = get_user_meta( $user->ID, 'qa_point', true );
		//update
		update_user_meta( $user->ID, 'et_question_count', $count_question  );
		update_user_meta( $user->ID, 'et_answer_count', $count_answer  );
		update_user_meta( $user->ID, 'qa_point', $count_point > 1 ? $count_point : 1  );
	}
	update_option( 'update_version_1_dot_2', 1 );
}

?>