<!DOCTYPE html>
<?php $mts_options = get_option(MTS_THEME_NAME); ?>
<html class="no-js" <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<!-- Always force latest IE rendering engine (even in intranet) & Chrome Frame -->
	<!--[if IE ]>
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<![endif]-->
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<?php mts_meta(); ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php wp_head(); ?>
</head>
<body id="blog" <?php body_class('main'); ?>>       
	<div class="main-container">
		<?php if(isset($mts_options['mts_trending_articles'])) { if($mts_options['mts_trending_articles'] == '1' && $mts_options['mts_trending_articles'] != '') { ?>
			<div class="trending-articles">
				<div class="firstlink"><?php _e('Now Trending','pointpro'); ?>:</div>
				<ul>
					<?php $i = 1; 
					// prevent implode error
                    if ( empty( $mts_options['mts_trending_articles_cat'] ) || !is_array( $mts_options['mts_trending_articles_cat'] ) ) {
                        $mts_options['mts_trending_articles_cat'] = array('0');
                    }
                    $trending_cat = implode( ",", $mts_options['mts_trending_articles_cat'] );
					$trending_query = new wp_query( 'cat='.$trending_cat.'&posts_per_page='.$mts_options['mts_trending_articles_num'].'&ignore_sticky_posts=1' ); ?>
					<?php if ($trending_query->have_posts()) : while ($trending_query->have_posts()) : $trending_query->the_post(); ?>
						<li class="trendingPost <?php if($i % 4 == 0){echo 'last';} ?>">
							<a href="<?php the_permalink() ?>" title="<?php the_title(); ?>" rel="bookmark"><?php the_title(); ?></a>
						</li>                   
					<?php $i++; endwhile; endif; 
					wp_reset_query(); ?>
				</ul>
			</div>
		<?php }} ?>
		<header id="site-header" role="banner" itemscope itemtype="http://schema.org/WPHeader">
			<div class="container">
				<div id="header">
					<div class="logo-wrap">
						<?php if ($mts_options['mts_logo'] != '') { ?>
							<?php
							$logo_id = mts_get_image_id_from_url( $mts_options['mts_logo'] );
							$logo_w_h = '';
							if ( $logo_id ) {
	        					$logo     = wp_get_attachment_image_src( $logo_id, 'full' );
	        					$logo_w_h = ' width="'.$logo[1].'" height="'.$logo[2].'"';
	        				}
	        				if( is_front_page() || is_home() || is_404() ) { ?>
								<h1 id="logo" class="image-logo" itemprop="headline">
									<a href="<?php echo esc_url( home_url() ); ?>"><img src="<?php echo esc_url( $mts_options['mts_logo'] ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>" <?php echo $logo_w_h; ?>></a>
								</h1><!-- END #logo -->
							<?php } else { ?>
								<h2 id="logo" class="image-logo" itemprop="headline">
									<a href="<?php echo esc_url( home_url() ); ?>"><img src="<?php echo esc_url( $mts_options['mts_logo'] ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>" <?php echo $logo_w_h; ?>></a>
								</h2><!-- END #logo -->
							<?php } ?>
						<?php } else { ?>
							<?php if( is_front_page() || is_home() || is_404() ) { ?>
								<h1 id="logo" class="text-logo" itemprop="headline">
									<a href="<?php echo esc_url( home_url() ); ?>"><?php bloginfo( 'name' ); ?></a>
								</h1><!-- END #logo -->
							<?php } else { ?>
							    <h2 id="logo" class="text-logo" itemprop="headline">
									<a href="<?php echo esc_url( home_url() ); ?>"><?php bloginfo( 'name' ); ?></a>
								</h2><!-- END #logo -->
							<?php } ?>
							<div class="site-description" itemprop="description">
								<?php bloginfo( 'description' ); ?>
							</div>
						<?php } ?>
					</div>
					<?php if ( $mts_options['mts_show_nav'] == '1' ) { ?>
						<div id="secondary-navigation" role="navigation" itemscope itemtype="http://schema.org/SiteNavigationElement">
							<a href="#" id="pull" class="toggle-mobile-menu"><?php _e('Menu', 'pointpro' ); ?></a>
							<?php if ( has_nav_menu( 'mobile' ) ) { ?>
								<nav class="navigation clearfix">
									<?php if ( has_nav_menu( 'primary-menu' ) ) { ?>
										<?php wp_nav_menu( array( 'theme_location' => 'primary-menu', 'menu_class' => 'menu clearfix', 'container' => '', 'walker' => new mts_menu_walker ) ); ?>
									<?php } else { ?>
										<ul class="menu clearfix">
											<?php wp_list_categories('title_li='); ?>
										</ul>
									<?php } ?>
								</nav>
								<nav class="navigation mobile-only clearfix mobile-menu-wrapper">
									<?php wp_nav_menu( array( 'theme_location' => 'mobile', 'menu_class' => 'menu clearfix', 'container' => '', 'walker' => new mts_menu_walker ) ); ?>
								</nav>
							<?php } else { ?>
								<nav class="navigation clearfix mobile-menu-wrapper">
									<?php if ( has_nav_menu( 'primary-menu' ) ) { ?>
										<?php wp_nav_menu( array( 'theme_location' => 'primary-menu', 'menu_class' => 'menu clearfix', 'container' => '', 'walker' => new mts_menu_walker ) ); ?>
									<?php } else { ?>
										<ul class="menu clearfix">
											<?php wp_list_categories('title_li='); ?>
										</ul>
									<?php } ?>
								</nav>
							<?php } ?>
						</div>
					<?php } ?>
				</div><!--#header-->
			</div><!--.container-->
		</header>
		<?php if ($mts_options['mts_header_adcode'] != '' && !is_page_template('page-home.php')) { ?>
			<div class="header-bottom-second">
				<?php echo '<div id="header-widget-container">';
					if ($mts_options['mts_header_adcode'] != ''){
						echo '<div class="widget-header">';
						echo $mts_options['mts_header_adcode'];
						echo '</div>';
					} ?>
					<?php if ($mts_options['mts_posttopleft_adcode'] != ''){ ?>
						<div class="widget-header-bottom-right">
							<div class="textwidget">
								<div class="topad"><?php echo $mts_options['mts_posttopleft_adcode']; ?> </div>
							</div>
						</div> 
					<?php } ?>
				</div>
			</div>
		<?php } ?>