<?php
/**
 * The template for displaying Gallery archive.
 */

get_header();
$mts_options = get_option(MTS_THEME_NAME);

$mts_homepage_gallery_title = $mts_options['mts_homepage_gallery_title'];
$mts_gallery_layout = $mts_options['mts_gallery_layout'];

if ( '1' == $mts_gallery_layout ) {
	$cols    = ' one-fourth';
	$thumb_size = 'pointpro-project-4';
} else {
	$cols    = ' one-third';
	$thumb_size = 'pointpro-project-3';
} ?>
<div id="page">
	<div class="inner-page-header border-bottom clearfix">
		<h1 class="inner-page-title section-title"><span><?php echo $mts_homepage_gallery_title; ?></span></h1>
	</div>

	<div id="gallery-archive" class="grid cpt-archive">
		<?php wp_reset_query(); $paged = ( get_query_var('paged') > 1 ) ? get_query_var('paged') : 1;

		$args = array(
			'post_type' => 'gallery',
			'post_status' => 'publish',
			'paged' => $paged,
			'ignore_sticky_posts'=> 1,
			'posts_per_page' => empty ( $mts_options['mts_gallery_count'] ) ? '9' : $mts_options['mts_gallery_count']
		);

		$gallery_posts = new WP_Query( $args );
		$j = 0; if ( $gallery_posts->have_posts() ) : while ( $gallery_posts->have_posts() ) : $gallery_posts->the_post(); ?>
			<article class="gallery-item grid-box<?php echo $cols; ?>">
				<div class="grid-inner project-box-inner">
					<a class="gallery-image" href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>">
						<?php the_post_thumbnail( $thumb_size, array('title' => '')); ?>
					</a>					
				</div>
			</article><!--.post excerpt-->
		<?php $j++; endwhile; endif; ?>
	</div>

	<?php if ( $j !== 0 ) { // No pagination if there is no results ?>
		<!--Start Pagination-->

		<?php mts_pagination('', 3, 'mts_gallery_pagenavigation_type'); ?>
		<!--End Pagination-->
	<?php } ?>
</div>
<?php get_footer(); ?>