<?php    

// Remove extra strings from url
function removeString($url){

    // in case scheme relative URI is passed, e.g., //www.google.com/
    $url = trim($url, '/');

    // If scheme not included, prepend it
    if (!preg_match('#^http(s)?://#', $url)) {
        $url = 'http://' . $url;
    }

    $urlParts = parse_url($url);

    // remove www
    $domain = preg_replace('/^www\./', '', $urlParts['host']);

    // Check for special charactors
    $domain = RemoveSpecialChar($domain);

    return $domain;
}


// Get whois data
function whoisResult($url){

    $whois = new Whois();
    $result = $whois->Lookup($url,false);

    return $result;
}

//  Remove Special Charactors
function RemoveSpecialChar($value){
    
    $result  = preg_replace('/[^a-zA-Z0-9_.-]/s','',$value);
    return $result;
}

function domainAge($age){

    $age = strtotime($age);
    $current = strtotime(date('Y-m-j'));
    $age = $current - $age;
    $years = floor($age / 31556926);
    $days = round(($age % 31556926) / 86400);

    if($years != 0){
        $age = $years .' years '. $days .' days ';
    }else{
        $age = $days .' days ';
    }
    

    return $age;
}

function foramtDate($date){
    $date = strtotime($date);

    return date("Y-m-d", $date); 
}

function getData($url){
    
    $result = mysql_query("SELECT * FROM sites WHERE domain='$url' LIMIT 1");
    $result = mysql_fetch_array($result);

    // Update page view in database
    mysql_query("UPDATE sites SET views=views+1  WHERE domain='$url' ") or die(mysql_error());

    return $result;

}

function getPRank($url){

    $rank = GooglePageRankChecker::getRank($url);   

    return $rank;
}

?>