
<?php 
    $mokar_post_term_arr = get_the_terms( get_the_ID(), 'gallery_cat' );
    $mokar_post_term_filters = '';
    $mokar_post_term_names = '';

    if (is_array($mokar_post_term_arr) || is_object($mokar_post_term_arr)){
        foreach ( $mokar_post_term_arr as $post_term ) {

            $mokar_post_term_filters .= $post_term->slug . ' ';
            $mokar_post_term_names .= $post_term->name . ', ';
            if($post_term->parent!=0){
                $parent_term = get_term( $post_term->parent,'gallery_cat' );
                $mokar_post_term_filters .= $parent_term->slug . ' ';
                
            }
        }
    }

    $mokar_post_term_filters = trim( $mokar_post_term_filters );
    $mokar_post_term_names = substr( $mokar_post_term_names, 0, -2 );
    $mokar_author = get_the_author_link();
?>
<div class="item <?php echo esc_attr($mokar_post_term_filters);?>">
    <div class="figcaption">
        <?php if ( has_post_thumbnail() ) : ?>
            <figure class="gallery-image">
                <div class="gallery-img">
                    <?php 
                        $attachment_id = get_post_thumbnail_id();
                        $mokar_gallery_full = mokar_get_attachment($attachment_id, 'full'); 
                    ?>
                    <img width="<?php echo esc_attr($mokar_gallery_full['width']) ?>" height="<?php echo esc_attr($mokar_gallery_full['height']) ?>" src="<?php echo esc_url($mokar_gallery_full['src']) ?>" alt="<?php echo esc_html__('gallery','mokar') ?>" />   
                </div>
            </figure>   
        <?php endif;?>   
        <div class="post_body">
            <div class="info category">
                <?php echo get_the_term_list(get_the_ID(),'gallery_cat', '', ' ' ); ?>
            </div>   
            <a href="<?php the_permalink();?>" class="gallery_title"><h4><?php the_title();?></h4></a>
            <div class="info author">
                <span><?php esc_html_e( 'author:', 'mokar' );?>  </span>
                <a href="<?php echo esc_url(get_edit_user_link( $post->post_author )); ?>"><?php echo esc_html($mokar_author);?></a>
            </div>
            <?php
                //the_excerpt();
            ?> 
        </div>  
    </div>  
</div>