<?php
function mokar_product_meta_data(){
    return array(
        // Custom Tab Title
        "custom_tab_title" => array(
            "name" => "custom_tab_title",
            "title" => esc_html__("Custom Tab Title", 'mokar'),
            "desc" => esc_html__("Input the custom tab title.", 'mokar'),
            "type" => "textfield"
        ),
        // Content Tab Content
        "custom_tab_content" => array(
            "name" => "custom_tab_content",
            "title" => esc_html__("Custom Tab Content", 'mokar'),
            "desc" => esc_html__("Input the custom tab content.", 'mokar'),
            "type" => "editor"
        )
    );
}

function mokar_show_product_tab_meta_option() {
    $meta_box = mokar_product_meta_data();
    mokar_show_meta_box($meta_box);
}

function mokar_save_product_tab_meta_option($post_id) {
    $meta_box = mokar_product_meta_data();
    return mokar_save_meta_data($post_id, $meta_box);
}

function mokar_add_product_tab_metaboxes() {
    if (function_exists('add_meta_box')) {
        add_meta_box('view-meta-boxes', esc_html__('Custom Tab', 'mokar'), 'mokar_show_product_tab_meta_option', 'product', 'normal', 'low');
    }
}

add_action('add_meta_boxes', 'mokar_add_product_tab_metaboxes');
add_action('save_post', 'mokar_save_product_tab_meta_option');
function mokar_product_sidebar_option(){
    $mokar_sidebar_position = mokar_sidebar_position();
    $mokar_sidebars = mokar_sidebars();
    $mokar_header_layout = mokar_header_types();
    $mokar_footer_layout = mokar_footer_types();
    $mokar_layout = mokar_layouts();
    return array(
        'header' => array(
            'name' => 'header',
            'title' => esc_html__('Header Layout', 'mokar'),
            'type' => 'select',
            'options' => $mokar_header_layout,
            'default' => 'default'
        ),
        //footer
        'footer' => array(
            'name' => 'footer',
            'title' => esc_html__('Footer Layout', 'mokar'),
            'type' => 'select',
            'options' => $mokar_footer_layout,
            'default' => 'default'
        ),
        'left-sidebar' => array(
            'name' => 'left-sidebar',
            'type' => 'select',
            'title' => esc_html__('Left Sidebar', 'mokar'),
            'options' => $mokar_sidebars,
            'default' => 'default'
        ),
        'right-sidebar' => array(
            'name' => 'right-sidebar',
            'type' => 'select',
            'title' => esc_html__('Right Sidebar', 'mokar'),
            'options' => $mokar_sidebars,
            'default' => 'default'
        ),
        // layout
        'layout' => array(
            'name' => 'layout',
            'title' => esc_html__('Layout', 'mokar'),
            'type' => 'select',
            'options' => $mokar_layout,
            'default' => 'default'
        ),
		'related_col' => array(
            'name'  => 'related_col',
            'type' => 'select',
            'title' => esc_html__('Related product columns', 'mokar'),
            'options' => array(
                "default" => esc_html__("Default","mokar"),
                "2" => esc_html__("2","mokar"),
                "3" => esc_html__("3","mokar"),
                "4" => esc_html__("4","mokar"),
            ),
            'default' => 'default'            
        ),
    );
}
function mokar_show_product_default_meta_option() {
    $meta_box = mokar_product_sidebar_option();
    mokar_show_meta_box($meta_box);
}


function mokar_save_product_meta_option($post_id) {
    $meta_box = mokar_product_sidebar_option();
    return mokar_save_meta_data($post_id, $meta_box);
}

function mokar_add_product_metaboxes() {
    if (function_exists('add_meta_box')) {
        add_meta_box('show-meta-boxes', esc_html__('Sidebar Options', 'mokar'), 'mokar_show_product_default_meta_option', 'product', 'side', 'low');
    }
}

add_action('add_meta_boxes', 'mokar_add_product_metaboxes');
add_action('save_post', 'mokar_save_product_meta_option');
function mokar_add_categorymeta_product_table() {
// Create Product Cat Meta
global $wpdb;
$type = 'product_cat';
$table_name = $wpdb->prefix . $type . 'meta';
$variable_name = $type . 'meta';
$wpdb->$variable_name = $table_name;

// Create Product Cat Meta Table
mokar_create_metadata_table($table_name, $type);
}
add_action( 'init', 'mokar_add_categorymeta_product_table' );
//Taxonomy
function mokar_default_product_tax_meta_data() {
    $mokar_sidebar_position = mokar_sidebar_position();
    $mokar_sidebars = mokar_sidebars();   
    $mokar_list_mode = mokar_product_type();
    $mokar_header_layout = mokar_header_types();
    $mokar_footer_layout = mokar_footer_types(); 
    return array(
        // Breadcrumbs
        'breadcrumbs' => array(
            'name' => 'breadcrumbs',
            'title' => esc_html__('Breadcrumbs', 'mokar'),
            'desc' => esc_html__('Hide breadcrumbs', 'mokar'),
            'type' => 'checkbox'
        ),
        'page_title' => array(
            'name' => 'page_title',
            'title' => esc_html__('Page Title', 'mokar'),
            'desc' => esc_html__('Hide Page Title', 'mokar'),
            'type' => 'checkbox'
        ),
        'show_header' => array(
            'name' => 'show_header',
            'title' => esc_html__('Header', 'mokar'),
            'desc' => esc_html__('Hide header', 'mokar'),
            'type' => 'checkbox'
        ),
        //  Show Footer
        'show_footer' => array(
            'name' => 'show_footer',
            'title' => esc_html__('Footer', 'mokar'),
            'desc' => esc_html__('Hide footer', 'mokar'),
            'type' => 'checkbox'
        ),
        //sidebar position
        'left-sidebar' => array(
            'name' => 'left-sidebar',
            'type' => 'select',
            'title' => esc_html__('Left Sidebar', 'mokar'),
            'options' => $mokar_sidebars,
            'default' => 'default'
        ),
        'right-sidebar' => array(
            'name' => 'right-sidebar',
            'type' => 'select',
            'title' => esc_html__('Right Sidebar', 'mokar'),
            'options' => $mokar_sidebars,
            'default' => 'default'
        ),
		'category-item-count' => array(
			'name' => 'category-item-count',
			'type' => 'text',
			'title' => esc_html__('Products per Page', 'mokar'),
			'default' => ''
		),
        'list_mode_product' => array(
            'name' => 'list_mode_product',
            'type' => 'select',
            'title' => esc_html__('List mode', 'mokar'),
            'options' => $mokar_list_mode,
            'default' => 'only-grid'
        ),
        'category_cols' => array(
            'name' => 'category_cols',
            'type' => 'select',
            'title' => esc_html__('Number of grid column', 'mokar'),
            'options' =>  
                    array(
                    "3" => esc_html__("3 columns", 'mokar'),
                    "1" => esc_html__("1 columns", 'mokar'),
                    "2" => esc_html__("2 columns", 'mokar'),
                    "4" => esc_html__("4 columns", 'mokar'),
                    "5" => esc_html__("5 columns", 'mokar'),
                    "column-default" => esc_html__("Default", 'mokar'),
                    ),
            'default' => 'column-default'
        ),
    );
}

add_action( 'product_cat_add_form_fields', 'mokar_add_product_cat', 10, 2);
function mokar_add_product_cat() {
    $product_cat_meta_boxes = mokar_default_product_tax_meta_data();

    mokar_show_tax_add_meta_boxes($product_cat_meta_boxes);
}

add_action( 'product_cat_edit_form_fields', 'mokar_edit_product_cat', 10, 2);
function mokar_edit_product_cat($tag, $taxonomy) {
    $product_cat_meta_boxes = mokar_default_product_tax_meta_data();

    mokar_show_tax_edit_meta_boxes($tag, $taxonomy, $product_cat_meta_boxes);
}

add_action( 'created_term', 'mokar_save_product_cat', 10,3 );
add_action( 'edit_term', 'mokar_save_product_cat', 10,3 );

function mokar_save_product_cat($term_id, $tt_id, $taxonomy) {
    if (!$term_id) return;
    
    $product_cat_meta_boxes = mokar_default_product_tax_meta_data();
    return mokar_save_taxdata( $term_id, $tt_id, $taxonomy, $product_cat_meta_boxes );
}