<?php
function mokar_post_meta_data() {
    return array( 
        "highlight" => array(
            "name" => "highlight",
            "title" => esc_html__("Short Description", 'mokar'),
            "desc" => esc_html__("Content", 'mokar'),
            "type" => "editor"
        ),
    );
}
function mokar_post_format(){
    return array(
        "video_code" => array(
            "name" => "video_code",
            "title" => esc_html__("Video & Audio Embed Code", 'mokar'),
            "desc" => esc_html__('Enter the embed link (Youtube or Vimeo). ', 'mokar'),
            "type" => "textarea",
            'display_condition' => 'post-type-video', 
        ),
        "link_code" => array(
            "name" => "link_code",
            "title" => esc_html__("Link", 'mokar'),
            "desc" => esc_html__('Enter link. ', 'mokar'),
            "type" => "textfield",
            'display_condition' => 'post-type-link', 
        ),
        "link_title" => array(
            "name" => "link_title",
            "title" => esc_html__("Link title", 'mokar'),
            "desc" => esc_html__('Enter link title. ', 'mokar'),
            "type" => "textfield",
            'display_condition' => 'post-type-link', 
        ),
        "quote_code" => array(
            "name" => "quote_code",
            "title" => esc_html__("Quote", 'mokar'),
            "desc" => esc_html__('Enter quote. ', 'mokar'),
            "type" => "textarea",
            'display_condition' => 'post-type-quote', 
        ),
        "quote_author" => array(
            "name" => "quote_author",
            "title" => esc_html__("Quote author", 'mokar'),
            "desc" => esc_html__('Enter quote author. ', 'mokar'),
            "type" => "textfield",
            'display_condition' => 'post-type-quote', 
        ),
    );
}
function mokar_view_post_meta_option() {
    $meta_box = mokar_post_meta_data();
    mokar_show_meta_box($meta_box);
}
function mokar_view_post_format_meta_option() {
    $meta_box = mokar_post_format();
    mokar_show_meta_box($meta_box);
}

function mokar_show_post_meta_option() {
    $meta_box = mokar_default_meta_data();
    mokar_show_meta_box($meta_box);
}
function mokar_save_post2_meta_option($post_id) {
    $meta_box_post = mokar_post_meta_data();
    $meta_box_format = mokar_post_format();
    $meta_box = array_merge($meta_box_post,$meta_box_format); 
    return mokar_save_meta_data($post_id, $meta_box);
}
function mokar_save_post_meta_option($post_id) {
    $meta_box = mokar_default_meta_data();
    return mokar_save_meta_data($post_id, $meta_box);
}

function mokar_add_post_metaboxes() {
    if (function_exists('add_meta_box')) {
        add_meta_box('view-format-boxes', esc_html__('Post Format', 'mokar'), 'mokar_view_post_format_meta_option', 'post', 'normal', 'low');        
        add_meta_box('show-meta-boxes', esc_html__('Blog Options', 'mokar'), 'mokar_view_post_meta_option', 'post', 'normal', 'low');
        add_meta_box('view-meta-boxes', esc_html__('Layout Options', 'mokar'), 'mokar_show_post_meta_option', 'post', 'normal', 'low');
    }
}

add_action('add_meta_boxes', 'mokar_add_post_metaboxes');
add_action('save_post', 'mokar_save_post_meta_option');
add_action('save_post', 'mokar_save_post2_meta_option');

function mokar_default_post_tax_meta_data() {
    $mokar_sidebar_position = mokar_sidebar_position();
    $mokar_sidebars = mokar_sidebars();
    $mokar_header_layout = mokar_header_types();
    $mokar_blog_layout = mokar_page_blog_layouts();
    $mokar_blog_columns = mokar_page_blog_columns();
    $mokar_blog_layout['default']= esc_html__('Default','mokar');
    $mokar_list_style = mokar_blog_list_style();
    $mokar_list_style['default']= esc_html__('Default','mokar');
    return array(
        // Breadcrumbs
        'page_title' => array(
            'name' => 'page_title',
            'title' => esc_html__('Page Title', 'mokar'),
            'desc' => esc_html__('Hide Page Title', 'mokar'),
            'type' => 'checkbox'
        ),
        'show_header' => array(
            'name' => 'show_header',
            'title' => esc_html__('Header', 'mokar'),
            'desc' => esc_html__('Hide header', 'mokar'),
            'type' => 'checkbox'
        ),
        'blog_layout' => array(
            'name' => 'blog_layout',
            'title' => esc_html__('Blog layout', 'mokar'),
            'desc' => esc_html__('Select blog layout', 'mokar'),
            'type' => 'select',
            'options' => $mokar_blog_layout,
            'default' => 'default'            
        ),
        'blog_list_style' => array(
            'name' => 'blog_list_style',
            'title' => esc_html__('[List Layout] Blog list style', 'mokar'),
            'desc' => esc_html__('Select blog list style', 'mokar'),
            'type' => 'select',
            'options' => $mokar_list_style,
            'default' => 'default'            
        ),
		'blog_columns' => array(
            'name' => 'blog_columns',
            'title' => esc_html__('Blog columns', 'mokar'),
            'desc' => esc_html__('Select blog columns', 'mokar'),
            'type' => 'select',
            'options' => $mokar_blog_columns,
            'default' => 'default'            
        ),
        'post_desc' => array(
            'name' => 'post_desc',
            'title' => esc_html__('Post Description', 'mokar'),
            'type' => 'select',
            'options' => array(
                'default' => esc_html__('Default','mokar'), 
                '1' => esc_html__('Hide','mokar'), 
                '2' => esc_html__('Display','mokar'), 
             ),
            'default' => 'default'            
        ),        
        'post_pagination' => array(
            'name' => 'post_pagination',
            'title' => esc_html__('Pagination type', 'mokar'),
            'desc' => esc_html__('Select blog pagination', 'mokar'),
            'type' => 'select',
            'options' => array(
                'default' => esc_html__('Default','mokar'), 
                '1' => esc_html__('Load more','mokar'), 
                '2' => esc_html__('Next/Prev','mokar'), 
             ),
            'default' => 'default'            
        ),        
        //  Show Footer
        'show_footer' => array(
            'name' => 'show_footer',
            'title' => esc_html__('Footer', 'mokar'),
            'desc' => esc_html__('Hide footer', 'mokar'),
            'type' => 'checkbox'
        ),
        //sidebar position
        'left-sidebar' => array(
            'name' => 'left-sidebar',
            'type' => 'select',
            'title' => esc_html__('Left Sidebar', 'mokar'),
            'options' => $mokar_sidebars,
            'default' => 'default'
        ),
        'right-sidebar' => array(
            'name' => 'right-sidebar',
            'type' => 'select',
            'title' => esc_html__('Right Sidebar', 'mokar'),
            'options' => $mokar_sidebars,
            'default' => 'default'
        ),
    );
}
//category taxonomy
function mokar_add_categorymeta_table() {
    // Create Product Cat Meta
    global $wpdb;
    $type = 'category';
    $table_name = $wpdb->prefix . $type . 'meta';
    $variable_name = $type . 'meta';
    $wpdb->$variable_name = $table_name;

    // Create Category Meta Table
    mokar_create_metadata_table($table_name, $type);
}
add_action( 'init', 'mokar_add_categorymeta_table' );

// category meta
add_action( 'category_add_form_fields', 'mokar_add_category', 10, 2);
function mokar_add_category() {
    $category_meta_boxes = mokar_default_post_tax_meta_data();
    mokar_show_tax_add_meta_boxes($category_meta_boxes);
}

add_action( 'category_edit_form_fields', 'mokar_edit_category', 10, 2);
function mokar_edit_category($tag, $taxonomy) {
    $category_meta_boxes = mokar_default_post_tax_meta_data();
    mokar_show_tax_edit_meta_boxes($tag, $taxonomy, $category_meta_boxes);
}

add_action( 'created_term', 'mokar_save_category', 10,3 );
add_action( 'edit_term', 'mokar_save_category', 10,3 );
function mokar_save_category($term_id, $tt_id, $taxonomy) {
    if (!$term_id) return;
    
    $category_meta_boxes = mokar_default_post_tax_meta_data();
    return mokar_save_taxdata( $term_id, $tt_id, $taxonomy, $category_meta_boxes );
}



 