<?php
function mokar_page_meta_data() {
    $mokar_skin = array('color-1', 'color-2', 'color-3', 'color-4', 'color-5', 'color-6', 'color-7','color-8', 'color-9');  
    
    return array(
        'header_fixed' => array(
            'name' => 'header_fixed',
            'title' => esc_html__('Header Fixed', 'mokar'),
            'type' => 'checkbox'
        ),
        "logo_header_page"=> array(
            "name" => "logo_header_page",
            "title" => esc_html__("Logo header for page", 'mokar'),
            'desc' => esc_html__("Upload logo header only page", 'mokar'),
            "type" => "upload"
        ), 
        'header_menu_hcolor' => array(
            'name' => 'header_menu_hcolor',
            'title' => esc_html__('Header Menu Hover Color in desktop and tablet', 'mokar'),
            'desc' => esc_html__("You should input hex color(ex: #000000) or 'transparent'.", 'mokar'),
            'type' => 'color',
        ),         
        "icon_header4"=> array(
            "name" => "icon_header4",
            "title" => esc_html__("Color icon menu header for page", 'mokar'),
            'desc' => esc_html__("You should input hex color(ex: #fff).", 'mokar'),
            "type" => "color"
        ),  
        'body_bg' => array(
            'name' => 'body_bg',
            'title' => esc_html__('Body Background', 'mokar'),
            'desc' => esc_html__("You should input hex color(ex: #e1e1e1).", 'mokar'),
            'type' => 'color',
        ),         
        'footer_bg' => array(
            'name' => 'footer_bg',
            'title' => esc_html__('Footer Background', 'mokar'),
            'desc' => esc_html__("You should input hex color(ex: #e1e1e1).", 'mokar'),
            'type' => 'color',
        ),
        "logo_footer_page"=> array(
            "name" => "logo_footer_page",
            "title" => esc_html__("Logo footer for page", 'mokar'),
            'desc' => esc_html__("Upload logo footer only page", 'mokar'),
            "type" => "upload"
        ),   
        'footer_text_color' => array(
            'name' => 'footer_text_color',
            'title' => esc_html__('Footer Text Color', 'mokar'),
            'desc' => esc_html__("You should input hex color(ex: #000000) or 'transparent'.", 'mokar'),
            'type' => 'color',
        ), 
        'footer_link_color' => array(
            'name' => 'footer_link_color',
            'title' => esc_html__('Footer Link Color', 'mokar'),
            'desc' => esc_html__("You should input hex color(ex: #000000) or 'transparent'.", 'mokar'),
            'type' => 'color',
        ),                    
    );
}
function mokar_view_page_meta_option() {
    $meta_box = mokar_page_meta_data();
    mokar_show_meta_box($meta_box);
}
function mokar_save_page2_meta_option($post_id) {
    $meta_box = mokar_page_meta_data();
    return mokar_save_meta_data($post_id, $meta_box);
}
function mokar_show_page_meta_option() {
    $meta_box = mokar_default_meta_data();
    mokar_show_meta_box($meta_box);
}
function mokar_save_page_meta_option($post_id) {
    $meta_box = mokar_default_meta_data();
    return mokar_save_meta_data($post_id, $meta_box);
}

function mokar_add_page_metaboxes() {
    if (function_exists('add_meta_box')) {
        add_meta_box('view-meta-boxes', esc_html__('Layout Options', 'mokar'), 'mokar_show_page_meta_option', 'page', 'side', 'low');
        add_meta_box('view-skin-boxes', esc_html__('Skin Options', 'mokar'), 'mokar_view_page_meta_option', 'page', 'normal', 'low');        
    }
}
add_action('add_meta_boxes', 'mokar_add_page_metaboxes');
add_action('save_post', 'mokar_save_page_meta_option');
add_action('save_post', 'mokar_save_page2_meta_option');
 