<?php

/**
 * Mokar Settings Options
 */
if (!class_exists('Framework_Mokar_Settings')) {

    class Framework_Mokar_Settings {

        public $ReduxFramework;

        public function __construct() {

            if (!class_exists('ReduxFramework')) {
                return;
            }

            // This is needed. Bah WordPress bugs.  ;)
            if (true == Redux_Helpers::isTheme(__FILE__)) {
                $this->initSettings();
            } else {
                add_action('plugins_loaded', array($this, 'initSettings'), 10);
            }
        }

        public function initSettings() {
            $this->ReduxFramework = new ReduxFramework($this->mokar_get_setting_sections(), $this->mokar_get_setting_arguments());
        }

        public function mokar_get_setting_sections() {
            $page_layout = mokar_layouts();
            $sidebar_positions = mokar_sidebar_position();
            $block_name = mokar_get_block_name();
            $breadcrumbs_type = mokar_get_breadcrumbs_type();
            unset($page_layout['default']);
            unset($sidebar_positions['default']);
            $menus = get_terms('nav_menu');
            $menu_list =mokar_list_menu();            
            $sections = array(
                array(
                    'icon' => 'el-icon-edit',
                    'icon_class' => 'icon',
                    'title' => esc_html__('General', 'mokar'),
                    'fields' => array(
                    )
                ),
                array(
                'icon_class' => 'icon',
                'subsection' => true,
                'title' => esc_html__('Layout', 'mokar'),
                'fields' => array(
                        array(
                            'id' => 'layout',
                            'type' => 'button_set',
                            'title' => esc_html__('Layout', 'mokar'),
                            'options' => $page_layout,
                            'default' => 'fullwidth'
                        ),
                        array(
                            'id' => 'left-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Left Sidebar', 'mokar'),
                            'data' => 'sidebars',
                            'default' => ''
                        ),
                        array(
                            'id' => 'right-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Right Sidebar', 'mokar'),
                            'data' => 'sidebars',
                            'default' => ''
                        ),
                    )
                ),
                array(
                'icon_class' => 'icon',
                'subsection' => true,
                'title' => esc_html__('Logo, Favicon, Js Custom', 'mokar'),
                'fields' => array(
                        array(
                            'id' => 'logo',
                            'type' => 'media',
                            'url' => true,
                            'readonly' => false,
                            'title' => esc_html__('Logo', 'mokar'),
                            'required' => array(
                                        array('header-type', 'equals', array(
                                        '1', '3', '5', '6'
                                    )),
                                ),
                            'default' => array(
                                'url' => get_template_directory_uri() . '/images/logo.png',
                                'height' => 40,
                                'wide' => 140
                            )
                        ),   
                        array(
                            'id' => 'favicon',
                            'type' => 'media',
                            'url' => true,
                            'readonly' => false,
                            'title' => esc_html__('Favicon', 'mokar'),
                            'default' => array(
                                'url' => get_template_directory_uri() . '/images/favicon.ico'
                            )
                        ),
                        array(
                            'id' => 'js-code',
                            'type' => 'ace_editor',
                            'title' => esc_html__('JS Code', 'mokar'),
                            'subtitle' => esc_html__('Paste your JS code here.', 'mokar'),
                            'mode' => 'javascript',
                            'theme' => 'chrome',
                            'default' => "jQuery(document).ready(function(){});"
                        )
                    )
                ),
                array(
                'icon_class' => 'icon',
                'subsection' => true,
                'title' => esc_html__('Preloader', 'mokar'),
                'fields' => array(
                        array(
                            'id'            => 'preload',
                            'type'          => 'button_set',
                            'title'         => esc_html__('Preload ', 'mokar'),
                            'description'   => esc_html__('Enable Preload site', 'mokar'), 
                            'options'       => array(
                                'enable'  => esc_html__( 'Enable', 'mokar' ), 
                                'disable'  => esc_html__( 'Disable', 'mokar' ),   
                            ),
                            'default'       => 'enable', 
                        ),
                    )
                ),
                array(
                'icon_class' => 'icon',
                'subsection' => true,
                'title' => esc_html__('View, Language Switcher', 'mokar'),
                'fields' => array(
                        array(
                            'id'=>'wpml-switcher',
                            'type' => 'switch',
                            'title' => esc_html__('Show WPML Language Switcher', 'mokar'),
                            'desc' => esc_html__('Show wpml language switcher instead of view switcher menu.', 'mokar').' '.esc_html__('Compatible with WPML plugins.', 'mokar'),
                            'default' => false,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ),
                    )
                ),
                array(
                    'icon' => 'el-icon-css',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Skin', 'mokar'),
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('General', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => 'general-bg',
                            'type' => 'background',
                            'title' => esc_html__('General Background', 'mokar'),
                            'default' => array(
                                'background-color' => '#fff',
                                'background-image' => '',
                                'background-size' => 'inherit',
                                'background-repeat' => 'no-repeat',
                                'background-position' => 'center center',
                                'background-attachment' => 'inherit'
                            ),
                        ),
                        array(
                            'id' => 'general-font',
                            'type' => 'typography',
                            'title' => esc_html__('General Font', 'mokar'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'default' => array(
                                'color' => "#888",
                                'google' => true,
                                'font-weight' => '400',
                                'font-family' => 'Poppins',
                                'font-size' => '15px',
                                'line-height' => '24px'
                            ),
                        ),
                        array(
                            'id' => 'primary-color',
                            'type' => 'color',
                            'title' => esc_html__('Primary color', 'mokar'),
                            'default' => '#4997ff',
                            'validate' => 'color',
                            'transparent' => false
                        ),
                        array(
                            'id' => 'highlight-color',
                            'type' => 'color',
                            'title' => esc_html__('Highlight color', 'mokar'),
                            'default' => '#eaf3ff',
                            'validate' => 'color',
                            'transparent' => false
                        ),
                        array(
                            'id' => 'hover-color',
                            'type' => 'color',
                            'title' => esc_html__('Hover link color', 'mokar'),
                            'default' => '#000',
                            'validate' => 'color',
                            'transparent' => false,
                            'description' => esc_html__('change links color when hover/active.', 'mokar'),                            
                        ),                        
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Breadcrumbs', 'mokar'),
                    'fields' => array(
                        array(
                            'id'=>'breadcrumbs_bg_type',
                            'type' => 'switch',
                            'title' => esc_html__('Enable breadcrumb image background', 'mokar'),
                            'default' => false,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ),                       
                        array(

                            'id' => 'breadcrumbs-bg',
                            'type' => 'background',
                            'title' => esc_html__('Background', 'mokar'),
                            'background-color' => false,
                            'default' => array(
                                'background-size' => 'cover',
                                'background-repeat' => 'no-repeat',
                                'background-position' => 'center center',
                                'background-attachment' => 'fixed'
                            )
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Typography', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => 'h1-font',
                            'type' => 'typography',
                            'title' => esc_html__('H1 Font', 'mokar'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'font-weight' => false,
                            'line-height' => false,
                            'default' => array(
                                'color' => "#212425",
                                'google' => true,
                                'font-family' => 'Poppins',
                                'font-size' => '40px',
                            ),
                        ),
                        array(
                            'id' => 'h2-font',
                            'type' => 'typography',
                            'title' => esc_html__('H2 Font', 'mokar'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'font-weight' => false,
                            'line-height' => false,
                            'default' => array(
                                'color' => "#212425",
                                'google' => true,
                                'font-family' => 'Poppins',
                                'font-size' => '36px',
                            ),
                        ),
                        array(
                            'id' => 'h3-font',
                            'type' => 'typography',
                            'title' => esc_html__('H3 Font', 'mokar'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'font-weight' => false,
                            'line-height' => false,
                            'default' => array(
                                'color' => "#212425",
                                'google' => true,
                                'font-family' => 'Poppins',
                                'font-size' => '25px',
                            ),
                        ),
                        array(
                            'id' => 'h4-font',
                            'type' => 'typography',
                            'title' => esc_html__('H4 Font', 'mokar'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'font-weight' => false,
                            'line-height' => false,
                            'default' => array(
                                'color' => "#212425",
                                'google' => true,
                                'font-family' => 'Poppins',
                                'font-size' => '18px',
                            ),
                        ),
                        array(
                            'id' => 'h5-font',
                            'type' => 'typography',
                            'title' => esc_html__('H5 Font', 'mokar'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'font-weight' => false,
                            'line-height' => false,
                            'default' => array(
                                'color' => "#212425",
                                'google' => true,
                                'font-family' => 'Poppins',
                                'font-size' => '16px',
                            ),
                        ),
                        array(
                            'id' => 'h6-font',
                            'type' => 'typography',
                            'title' => esc_html__('H6 Font', 'mokar'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'font-weight' => false,
                            'line-height' => false,
                            'default' => array(
                                'color' => "#212425",
                                'google' => true,
                                'font-family' => 'Poppins',
                                'font-size' => '14px',
                            ),
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Custom', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => 'custom-css-code',
                            'type' => 'ace_editor',
                            'title' => esc_html__('CSS', 'mokar'),
                            'subtitle' => esc_html__('Enter CSS code here.', 'mokar'),
                            'mode' => 'css',
                            'theme' => 'monokai',
                            'default' => ""
                        ),
                    )
                ),
                $this->mokar_add_header_section_options(),
                array(
                    'icon_class' => 'el-icon-edit',
                    'subsection' => true,
                    'title' => esc_html__('Header Styling', 'mokar'),
                    'fields' => array(
                        array(
                            'id'       => 'logo_width',
                            'type'     => 'dimensions',
                            'units'    => array('em','px','%'),
                            'title'    => esc_html__('Set logo image width', 'mokar'),
                            'subtitle' => esc_html__('Allow users to set width for header logo image', 'mokar'),
                            'height'   => false,
                        ),                        
                        array(
                            'id'             => 'menu_spacing',
                            'type'           => 'spacing',
                            'mode'           => 'margin',
                            'units'          => array('px'),
                            'units_extended' => 'false',
                            'title'          => esc_html__('Set padding for menu items', 'mokar'),
                            'subtitle'       => esc_html__('Allow users to ajust menu item spacing', 'mokar'),
                            'required' => array('header-style', 'equals', array(
                                    '1','6','2'
                                )),                              
                        ),                         
                        array(
                            'id' => 'header-style',
                            'type' => 'select',
                            'title' => esc_html__('Select header for styling', 'mokar'),
                            'options' => mokar_header_types(),
                            'default' => '1',
                        ),      
                    //Header 1                                  
                        array(
                            'id' => 'header-bg',
                            'type' => 'color',
                            'title' => esc_html__('Header background color', 'mokar'),
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '1','6'
                                )),                                
                        ),                                                
                        array(
                            'id' => 'header-icon-color',
                            'type' => 'color',
                            'title' => esc_html__('Header icon color', 'mokar'),
                            'default' => '#212425',
                            'subtitle' => esc_html__('Default background color is #212425', 'mokar'),
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '1', '6'                         
                                )),                            
                        ), 
                        array(
                            'id' => 'header-menu',
                            'type' => 'color',
                            'title' => esc_html__('Header menu color', 'mokar'),
                            'default' => '#212425',
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '1', '6'                        
                                )),                            
                        ),  
                    //Header 2      
                        array(
                            'id' => 'header2-bg',
                            'type' => 'color',
                            'title' => esc_html__('Header background color', 'mokar'),
                            'default' => '#212425',
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '2',
                                )),                                
                        ),                                                
                        array(
                            'id' => 'header2-icon-color',
                            'type' => 'color',
                            'title' => esc_html__('Header icon color', 'mokar'),
                            'default' => '#ffffff',
                            'subtitle' => esc_html__('Default background color is #212425', 'mokar'),
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '2',                              
                                )),                            
                        ), 
                        array(
                            'id' => 'header2-menu',
                            'type' => 'color',
                            'title' => esc_html__('Header menu color', 'mokar'),
                            'default' => '#ffffff',
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '2',                              
                                )),                            
                        ),  
                     //Header 3
                        array(
                            'id' => 'header3-menu',
                            'type' => 'color',
                            'title' => esc_html__('Header menu color', 'mokar'),
                            'default' => '#191b1c',
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '3','5',                              
                                )),                            
                        ), 
                        array(
                            'id' => 'header3-icon_color',
                            'type' => 'color',
                            'title' => esc_html__('Header icon color', 'mokar'),
                            'default' => '#191b1c',
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '3', '5',                             
                                )),                            
                        ), 
                        array(
                            'id' => 'header3-side_bg',
                            'type' => 'color',
                            'title' => esc_html__('Header background color in side-menu', 'mokar'),
                            'default' => '#ffffff',
                            'validate' => 'color',
                            'subtitle' => esc_html__('Default background color is #fff', 'mokar'),
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '3','5',
                                )),                            
                        ),                                                                  
                    //Header 4                     
                        array(
                            'id' => 'header4-side_color',
                            'type' => 'color',
                            'title' => esc_html__('Header menu color in side-menu', 'mokar'),
                            'default' => '#fff',
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '4'                            
                                )),                            
                        ),
                        array(
                            'id' => 'header4-side_bg',
                            'type' => 'color',
                            'title' => esc_html__('Header background color in side-menu', 'mokar'),
                            'default' => '#212425',
                            'validate' => 'color',
                            'subtitle' => esc_html__('Default background color is #212425', 'mokar'),
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '4',
                                )),                            
                        ), 
                    //Header mobile                       
                         array(
                            'id' => 'menu-mobile-bg',
                            'type' => 'color',
                            'title' => esc_html__('[Mobile] Background color for menu in mobile', 'mokar'),
                            'default' => '#eaf3ff',
                            'subtitle' => esc_html__('Default background color is #eaf3ff', 'mokar'),
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '1', '6'                              
                                )),                            
                        ), 
                         array(
                            'id' => 'menu-mobile-color',
                            'type' => 'color',
                            'title' => esc_html__('[Mobile] Menu link color in mobile', 'mokar'),
                            'default' => '#212425',
                            'subtitle' => esc_html__('Default menu link color is #212425', 'mokar'),
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '1' , '6'                          
                                )),                            
                        ), 
                         array(
                            'id' => 'menu-mobile-border',
                            'type' => 'color',
                            'title' => esc_html__('[Mobile] Menu border color in mobile', 'mokar'),
                            'default' => '#ddd',
                            'subtitle' => esc_html__('Default menu link color is #ddd', 'mokar'),
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '1','6'                              
                                )),                            
                        ),                              
                     //Header 2 mobile                       
                         array(
                            'id' => 'menu2-mobile-bg',
                            'type' => 'color',
                            'title' => esc_html__('[Mobile] Background color for menu in mobile', 'mokar'),
                            'default' => '#212425',
                            'subtitle' => esc_html__('Default background color is #212425', 'mokar'),
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '2'                              
                                )),                            
                        ), 
                         array(
                            'id' => 'menu2-mobile-color',
                            'type' => 'color',
                            'title' => esc_html__('[Mobile] Menu link color in mobile', 'mokar'),
                            'default' => '#ffffff',
                            'subtitle' => esc_html__('Default menu link color is #ffffff', 'mokar'),
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '2'                          
                                )),                            
                        ), 
                         array(
                            'id' => 'menu2-mobile-border',
                            'type' => 'color',
                            'title' => esc_html__('[Mobile] Menu border color in mobile', 'mokar'),
                            'default' => '#4d4d4d',
                            'subtitle' => esc_html__('Default menu link color is #4d4d4d', 'mokar'),
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '2'                              
                                )),                            
                        ),  
                                                                 
                    )

                ),                
                array(
                    'icon' => 'el-icon-edit',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Footer', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => 'footer-type',
                            'type' => 'image_select',
                            'title' => esc_html__('Footer Type', 'mokar'),
                            'options' => $this->mokar_footer_types(),
                            'subtitle' => esc_html__('Each page will have option for select footer type. Footer selection in each page will have higher priority than this general selection.','mokar'),
                            'default' => '1'
                        ),
                        array(
                            'id' => 'logo_footer1',
                            'type' => 'media',
                            'url' => true,
                            'readonly' => false,
                            'title' => esc_html__('Footer logo', 'mokar'),
                            'required' => array('footer-type', 'equals', array(
                                    '1', '2', '3'
                                )),                            
                            'default' => array(
                                'url' => get_template_directory_uri() . '/images/logo_footer.png',
                            )
                        ),      
                        array(
                            'id' => 'logo_footer4',
                            'type' => 'media',
                            'url' => true,
                            'readonly' => false,
                            'title' => esc_html__('Footer logo', 'mokar'),
                            'required' => array('footer-type', 'equals', array(
                                    '4',
                                )),                            
                            'default' => array(
                                'url' => get_template_directory_uri() . '/images/logo-footer-4.png',
                            )
                        ), 
                        array(
                            'id' => 'logo_footer5',
                            'type' => 'media',
                            'url' => true,
                            'readonly' => false,
                            'title' => esc_html__('Footer logo', 'mokar'),
                            'required' => array('footer-type', 'equals', array(
                                    '5',
                                )),                            
                            'default' => array(
                                'url' => get_template_directory_uri() . '/images/logo-footer-5.png',
                            )
                        ),                                                                                               
                        array(
                            'id' => "footer-info",
                            'type' => 'textarea',
                            'title' => esc_html__('Footer Description', 'mokar'),
                            'default' => wp_kses( __('Beoplay A1 bluetooth speakers image on the left is owned by Bang and Olufsen and is released under creative commons lisence. ', 'mokar'), 
                                array(
                                'a' => array(
                                    'href' => array('callto'=> array()),
                                    'title' => array(),
                                    'target' => array(),
                                ),
                                'i' => array(
                                    'class' => array(),
                                    'aria-hidden' => array(),
                                ),
                                )),
                            'required' => array(
                                'footer-type', 'equals',array(
                                    '4'
                                )
                            ),                            
                        ),  
                        array(
                            'id' => "footer-email",
                            'type' => 'textarea',
                            'title' => esc_html__('Email Contact', 'mokar'),
                            'default' => wp_kses( __('<a href="mailto:support@mokar.com">support@mokar.com</a> ', 'mokar'), 
                                array(
                                'a' => array(
                                    'href' => array('mailto'=> array()),
                                    'title' => array(),
                                    'target' => array(),
                                ),
                                'i' => array(
                                    'class' => array(),
                                    'aria-hidden' => array(),
                                ),
                                )),
                            'required' => array(
                                'footer-type', 'equals',array(
                                    '5'
                                )
                            ),                            
                        ),
                        array(
                            'id' => 'social-twitter',
                            'type' => 'text',
                            'title' => esc_html__('Twitter', 'mokar'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'mokar'), 
                        ),
                        array(
                            'id' => 'social-instagram',
                            'type' => 'text',
                            'title' => esc_html__('Instagram', 'mokar'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'mokar')
                        ),
                        array(
                            'id' => 'social-facebook',
                            'type' => 'text',
                            'title' => esc_html__('Facebook', 'mokar'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'mokar')
                        ),
                        array(
                            'id' => 'social-dribbble',
                            'type' => 'text',
                            'title' => esc_html__('Dribbble', 'mokar'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'mokar')
                        ),        
                        array(
                            'id' => 'social-pinterest',
                            'type' => 'text',
                            'title' => esc_html__('Pinterest', 'mokar'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'mokar')
                        ),                   
                        array(
                            'id' => "footer-copyright",
                            'type' => 'textarea',
                            'title' => esc_html__('Copyright', 'mokar'),
                            'default' => '&#169;'.wp_kses( __(' Mokar. All Right Reserved 2017.', 'mokar'), 
                                array(
                                'a' => array(
                                    'href' => array(),
                                    'title' => array(),
                                    'target' => array(),
                                ),
                                'i' => array(
                                    'class' => array(),
                                    'aria-hidden' => array(),
                                ),
                            )),                         
                        ),
                    )
                ),

                array(
                    'icon_class' => 'el-icon-edit',
                    'subsection' => true,
                    'title' => esc_html__('Footer Styling', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => 'footer-style',
                            'type' => 'select',
                            'title' => esc_html__('Select footer for styling', 'mokar'),
                            'options' => mokar_footer_types(),
                            'default' => '1',
                        ),                         
                        array(
                            'id' => 'footer-bg',
                            'type' => 'color',
                            'title' => esc_html__('Footer background color', 'mokar'),
                            'required' => array('footer-style', 'equals', array(
                                    '1','2','3','6',
                                )),
                            'default' => '#212425',
                            'validate' => 'color',
                        ),
                        array(
                            'id' => 'footer-color',
                            'type' => 'color',
                            'title' => esc_html__('Footer text color', 'mokar'),
                            'required' => array('footer-style', 'equals', array(
                                    '1','3','2','6'
                                )),
                            'default' => '#a2a2a2',
                            'validate' => 'color',
                            'transparent' =>false,
                        ), 
                         array(
                            'id' => 'footer-color2',
                            'type' => 'color',
                            'title' => esc_html__('Footer text color', 'mokar'),
                            'required' => array('footer-style', 'equals', array(
                                    '4','5'
                                )),
                            'default' => '#888',
                            'validate' => 'color',
                            'transparent' =>false,
                        ),   
                        array(
                            'id' => 'footer-t-color',
                            'type' => 'color',
                            'title' => esc_html__('Footer title color', 'mokar'),
                            'required' => array('footer-style', 'equals', array(
                                    '3','6'
                                )),
                            'default' => '#fff',
                            'validate' => 'color',
                            'transparent' =>false,
                        ), 
                         array(
                            'id' => 'footer-t-color2',
                            'type' => 'color',
                            'title' => esc_html__('Footer title color', 'mokar'),
                            'required' => array('footer-style', 'equals', array(
                                    '4','5'
                                )),
                            'default' => '#212425',
                            'validate' => 'color',
                            'transparent' =>false,
                        ),   
                        //footer 4
                       array(
                            'id' => 'footer4-bg',
                            'type' => 'color',
                            'title' => esc_html__('Footer background color', 'mokar'),
                            'required' => array('footer-style', 'equals', array(
                                    '4',
                                )),
                            'default' => '#eaf3ff',
                            'validate' => 'color',
                        ),
                        array(
                            'id' => 'footer5-bg',
                            'type' => 'color',
                            'title' => esc_html__('Footer background color', 'mokar'),
                            'required' => array('footer-style', 'equals', array(
                                    '5',
                                )),
                            'default' => '#fff',
                            'validate' => 'color',
                        ), 
                                                                                                           
                    )
                ),                
                array(
                    'icon' => 'el-icon-th',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Blog & Single Blog', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Blog layout default', 'mokar')
                        ),
                        array(
                            'id' => 'blog-title',
                            'type' => 'text',
                            'title' => esc_html__('Page Title', 'mokar'),
                            'default' => 'Blog'
                        ),                        
                        array(
                            'id' => 'post-layout',
                            'type' => 'button_set',
                            'title' => esc_html__('Layout', 'mokar'),
                            'options' => $page_layout,
                            'default' => 'fullwidth'
                        ),
                        array(
                            'id' => 'left-post-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Left Sidebar', 'mokar'),
                            'data' => 'sidebars',
                            'default' => ''
                        ),
                        array(
                            'id' => 'right-post-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Right Sidebar', 'mokar'),
                            'data' => 'sidebars',
                            'default' => ''
                        ),
						array(
                            'id' => 'post-layout-version',
                            'type' => 'button_set',
                            'title' => esc_html__('Blog Layout', 'mokar'),
                            'options' => mokar_page_blog_layouts(),
                            'default' => 'list'
                        ),
						array(
                            'id' => 'post-layout-columns',
                            'type' => 'button_set',
                            'title' => esc_html__('Blog Columns', 'mokar'),
                            'options' => mokar_page_blog_columns(),
                            'default' => '3',
                            'required' => array('post-layout-version', 'equals', array(
                                    'grid','masonry',
                                )),                            
                        ),
                        array(
                            'id' => 'post-list-style',
                            'type' => 'button_set',
                            'title' => esc_html__('Blog List Style', 'mokar'),
                            'options' => mokar_blog_list_style(),
                            'default' => 'list_s1',
                            'required' => array('post-layout-version', 'equals', array(
                                    'list'
                                )),                            
                        ),
                        array(
                            'id' => 'post_desc',
                            'type' => 'button_set',
                            'title' => esc_html__('Post Description', 'mokar'),
                            'options' => array(
                                '1' => esc_html__('Hide','mokar'), 
                                '2' => esc_html__('Display','mokar'), 
                             ),
                            'default' => '1',
                            'required' => array('post-layout-version', 'equals', array(
                                    'grid', 'masonry'
                                )),                            
                        ),                          
                        array(
                            'id'       => 'post_per_page',
                            'type'     => 'spinner', 
                            'title'    => esc_html__('Post show per page', 'mokar'),
                            'default'  => '9',
                            'min'      => '1',
                            'step'     => '1',
                            'max'      => '50',
                            'required' => array('post-layout-version', 'equals', array(
                                    'masonry',
                                )),                             
                        ),                                                
                        array(
                            'id' => 'post_pagination',
                            'type' => 'button_set',
                            'title' => esc_html__('Pagination type', 'mokar'),
                            'options' => array(
                                '1' => esc_html__('Load more','mokar'), 
                                '2' => esc_html__('Next/Prev','mokar'), 
                             ),
                            'default' => '2'
                        ),                                                
                    )
                ),
                array(
                    'icon' => 'el-icon-picture',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Portfolio', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => '2',
                            'type' => 'info',
                            'desc' => esc_html__('Portfolio Archive Page', 'mokar')
                        ),                                               
                        array(
                           'id' => 'section-start',
                           'type' => 'section',
                           'title' => esc_html__('Changing portfolio slug', 'mokar'),
                           'indent' => true,                    
                        ),                        
                        array(
                            'id'        => 'gallery_slug',
                            'type'      => 'text',
                            'title'     => esc_html__('Custom Slug', 'mokar'),
                            'subtitle'  => esc_html__('If you want your gallery post type to have a custom slug in the url, please enter it here.', 'mokar'),
                            'desc'      => esc_html__('You will still have to refresh your permalinks after saving this! 
    This is done by going to Settings > Permalinks and clicking save.', 'mokar'),
                            'validate'  => 'str_replace',
                            'str'       => array(
                                'search'        => ' ', 
                                'replacement'   => '-'
                            ),
                            'default'   => 'gallery',                    
                        ),  
                        array(
                            'id'        => 'gallery_cat_slug',
                            'type'      => 'text',
                            'title'     => esc_html__('Custom Slug for Portfolio category', 'mokar'),
                            'subtitle'  => esc_html__('If you want your gallery category to have a custom slug in the url, please enter it here.', 'mokar'),
                            'desc'      => esc_html__('You will still have to refresh your permalinks after saving this! 
    This is done by going to Settings > Permalinks and clicking save.', 'mokar'),
                            'validate'  => 'str_replace',
                            'str'       => array(
                                'search'        => ' ', 
                                'replacement'   => '-'
                            ),
                            'default'   => 'gallery_cat',                    
                        ), 
                        array(
                            'id'     => 'section-end',
                            'type'   => 'section',
                            'indent' => false,                        
                        ),
                        array(
                            'id' => '3',
                            'type' => 'info',
                            'desc' => esc_html__('The below options is also available in each Gallery Category. Please go to Gallery > Gallery Category and edit a category for more detail. The selections in each category will have higher priority than below general selections', 'mokar')
                        ),                             
                        array(
                            'id'        => 'gallery_desc',
                            'type'      => 'textarea',
                            'title'     => esc_html__('Description', 'mokar'),
                            'default'   => esc_html__('We love to design beautiful, eye-catching 
                            web sites and web applications.','mokar').'&ldquo;',                    
                        ), 
                        array(
                            'id' => 'gallery_filter',
                            'type' => 'switch',
                            'title' => esc_html__('Show Filter', 'mokar'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar')
                        ),                                                                       
                        array(
                            'id' => 'gallery-layout',
                            'type' => 'button_set',
                            'title' => esc_html__('General Layout', 'mokar'),
                            'options' => $page_layout,
                            'default' => 'fullwidth'
                        ),
                        array(
                            'id' => 'left-gallery-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Left Sidebar', 'mokar'),
                            'data' => 'sidebars',
                            'default' => ''
                        ),
                        array(
                            'id' => 'right-gallery-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Right Sidebar', 'mokar'),
                            'data' => 'sidebars',
                            'default' => ''
                        ),
                        array(
                            'id' => 'gallery-cols',
                            'type' => 'button_set',
                            'title' => esc_html__('Portfolio Columns', 'mokar'),
                            'options' => mokar_gallery_columns(),
                            'default' => '3',
                        ),
                        array(
                            'id' => 'gallery-style-version',
                            'type' => 'button_set',
                            'title' => esc_html__('Portfolio layouts', 'mokar'),
                            'options' => mokar_page_gallery_layouts(),
                            'default' => '1'
                        ),                        
                        array(
                            'id' => 'gallery-loadmore-style',
                            'type' => 'button_set',
                            'title' => esc_html__('Portfolio loadmore style', 'mokar'),
                            'options' => array(
                                '1' => esc_html__('Button style 1','mokar'),
                                '2' => esc_html__('Button style 2','mokar'),
                                ),
                            'default' => '1',                         
                        ), 
                        array(
                            'id'       => 'gallery_per_page',
                            'type'     => 'spinner', 
                            'title'    => esc_html__('Post show per page', 'mokar'),
                            'default'  => '12',
                            'min'      => '1',
                            'step'     => '1',
                            'max'      => '20',
                        ) 
                    )                      
                ),
               array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Single Portfolio', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Portfolio detail page', 'mokar')
                        ),
                        array(
                            'id' => 'single_gallery_style',
                            'type' => 'button_set',
                            'title' => esc_html__('Single gallery layout', 'mokar'),
                            'options' => array(
                                    "1" => esc_html__("Wide","mokar"),
                                    "2" => esc_html__("Slider","mokar"),
                                    "3" => esc_html__("Side Information","mokar"),
                                ),
                            'default' => '2',                         
                        ), 
                    )
                ),
                array(
                    'icon' => 'el-icon-shopping-cart',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Shop', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => 'product-cart',
                            'type' => 'switch',
                            'title' => esc_html__('Show Add to Cart button', 'mokar'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar')
                        ),
                        array(
                            'id' => 'product-price',
                            'type' => 'switch',
                            'title' => esc_html__('Show Product Price', 'mokar'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar')
                        ),                        
                        array(
                            'id' => 'product-label',
                            'type' => 'switch',
                            'title' => esc_html__('Show Product Label', 'mokar'),
                            'default' => false,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Product listing', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Product listing', 'mokar')
                        ),
						array(
                            'id'        => 'shop-sologan',
                            'type'      => 'textarea',
                            'title'     => esc_html__('Slogan', 'mokar'),
                            'default'   => '&ldquo;'.' We help companies and startups from all over the world materialize their ideas into great projects.'.'&rdquo;',                    
                        ),  
                        array(
                            'id' => 'shop-layout',
                            'type' => 'button_set',
                            'title' => esc_html__('Layout', 'mokar'),
                            'options' => $page_layout,
                            'default' => 'fullwidth'
                        ),
                        array(
                            'id' => 'left-shop-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Left Sidebar', 'mokar'),
                            'data' => 'sidebars',
                            'default' => ''
                        ),
                        array(
                            'id' => 'right-shop-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Right Sidebar', 'mokar'),
                            'data' => 'sidebars',
                            'default' => ''
                        ),
                        array(
                            'id' => 'category-item',
                            'type' => 'text',
                            'title' => esc_html__('Products per Page', 'mokar'),
                            'desc' => esc_html__('Comma separated list of product counts.', 'mokar'),
                            'default' => '8,16,24'
                        ),
						array(
                            'id' => 'product-layouts',
                            'type' => 'button_set',
                            'title' => esc_html__('Product Layouts', 'mokar'),
                            'options' => mokar_product_type(),
                            'default' => 'only-grid',
                        ),
                        array(
                            'id' => 'product-cols',
                            'type' => 'button_set',
                            'title' => esc_html__('Product Columns', 'mokar'),
                            'options' => mokar_product_columns(),
                            'default' => '4',
                            'required' => array('product-layouts', 'equals', array(
                                    'only-grid'
                                )),                             
                        ),
                        array(
                            'id' => 'product-wishlist',
                            'type' => 'switch',
                            'title' => esc_html__('Show Wishlist', 'mokar'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ), 
						array(
                            'id' => 'product-pagination',
                            'type' => 'button_set',
                            'title' => esc_html__('Product Pagination', 'mokar'),
                            'default' => true,
                            'options' => mokar_pagination_types(),
                            'default' => 'loadmore'
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Single Product', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => 'single-product-layout',
                            'type' => 'button_set',
                            'title' => esc_html__('Layout', 'mokar'),
                            'options' => $page_layout,
                            'default' => 'fullwidth'
                        ),
                        array(
                            'id' => 'left-single-product-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Left Sidebar', 'mokar'),
                            'data' => 'sidebars',
                            'default' => ''
                        ),
                        array(
                            'id' => 'right-single-product-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Right Sidebar', 'mokar'),
                            'data' => 'sidebars',
                            'default' => ''
                        ),
						array(
                            'id' => 'product-share',
                            'type' => 'switch',
                            'title' => esc_html__('Show Product share link', 'mokar'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ),   
                        array(
                            'id' => 'product-related',
                            'type' => 'switch',
                            'title' => esc_html__('Show Related Products', 'mokar'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ),
                        array(
                            'id' => 'product-reviewtab',
                            'type' => 'switch',
                            'title' => esc_html__('Remove Product Review tab', 'mokar'),
                            'default' => false,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ),                                                    
                        array(
                            'id' => 'product-destab',
                            'type' => 'switch',
                            'title' => esc_html__('Remove Product Description tab', 'mokar'),
                            'default' => false,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ),                          
                        array(
                            'id' => 'product-infotab',
                            'type' => 'switch',
                            'title' => esc_html__('Remove Additional Information tab', 'mokar'),
                            'default' => false,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ),     
                        array(
                            'id' => 'product_tagtab',
                            'type' => 'switch',
                            'title' => esc_html__('Remove Tag Tab', 'mokar'),
                            'default' => false,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ),  
                        array(
                            'id' => 'product-reviewtab-name',
                            'type' => 'text',
                            'title' => esc_html__('Rename Product Review Tab', 'mokar'),
                            'default' => esc_html__('Reviews', 'mokar')
                        ), 
                        array(
                            'id' => 'product-destab-name',
                            'type' => 'text',
                            'title' => esc_html__('Rename Product Description Tab', 'mokar'),
                            'default' => esc_html__('Description', 'mokar')
                        ), 
                        array(
                            'id' => 'product-infotab-name',
                            'type' => 'text',
                            'title' => esc_html__('Rename Additional Information Tab', 'mokar'),
                            'default' => esc_html__('Additional Information', 'mokar')
                        ),  
                        array(
                            'id' => 'product-tagtab-name',
                            'type' => 'text',
                            'title' => esc_html__('Rename Tag Tab', 'mokar'),
                            'default' => esc_html__('Tags', 'mokar')
                        ),                                                                                                                                                                                      
                    )
                ),
                array(
                    'icon' => 'el-icon-cog',
                    'icon_class' => 'icon',
                    'title' => esc_html__('404 Page', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => '404-bg-image',
                            'type' => 'media',
                            'url' => true,    
                            'readonly' => false,
                            'title' => esc_html__('Background image', 'mokar'),
                            'desc' => esc_html__('Background image for 404 page', 'mokar'),
                        ),
                    )
                ),                        
                array(
                    'icon' => 'el-icon-cog',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Coming soon', 'mokar'),
                    'fields' => array(
                        array(
                            'id' => 'under-contr-mode',
                            'type' => 'switch',
                            'title' => esc_html__('Activate under construction mode', 'mokar'),
                            'default' => false,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ),
                       array(
                            'id' => 'under-bg-image',
                            'type' => 'media',
                            'url' => true,
                            'readonly' => false,
                            'title' => esc_html__('Background image', 'mokar'),
                            'desc' => esc_html__('Background image for coming soon page', 'mokar'),
                            'default' => array(
                                'url' => get_template_directory_uri() . '/images/coming-soon.jpg',
                            )
                        ),
                        array(
                            'id' => 'logo-coming',
                            'type' => 'media',
                            'url' => true,
                            'readonly' => false,
                            'title' => esc_html__('Logo display in coming soon page', 'mokar'),
                            'default' => array(
                                'url' => get_template_directory_uri() . '/images/logo_footer.png',
                                'height' => 115,
                                'wide' => 115
                            )
                        ),
                        array(
                            'id' => "under-contr-title",
                            'type' => 'text',
                            'title' => esc_html__('Big Title', 'mokar'),
                            'default' => esc_html__('Something really good is coming very soon.', 'mokar')
                        ),
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Countdown Timer', 'mokar')
                        ),
                        array(
                            'id' => 'under-display-countdown',
                            'type' => 'switch',
                            'title' => esc_html__('Display countdown timer', 'mokar'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ),
                         array(
                            'id' => "under-end-date",
                            'type' => 'date',
                            'title' => esc_html__('End date', 'mokar'),
                            'default' => '12/28/2017',
                            'required' => array('under-display-countdown', 'equals', true),
                        ),
                        array(
                            'id' => "under-contr-day",
                            'type' => 'text',
                            'title' => esc_html__('Text display under day number', 'mokar'),
                            'default' => esc_html__('Days', 'mokar')
                        ),  
                        array(
                            'id' => "under-contr-hour",
                            'type' => 'text',
                            'title' => esc_html__('Text display under hour number', 'mokar'),
                            'default' => esc_html__('Hours', 'mokar')
                        ),
                        array(
                            'id' => "under-contr-min",
                            'type' => 'text',
                            'title' => esc_html__('Text display under minute number', 'mokar'),
                            'default' => esc_html__('Minutes', 'mokar')
                        ),
                        array(
                            'id' => "under-contr-sec",
                            'type' => 'text',
                            'title' => esc_html__('Text display under secs number', 'mokar'),
                            'default' => esc_html__('Secs', 'mokar')
                        ),                                                                                                
                        array(
                            'id' => "under-contr-text",
                            'type' => 'text',
                            'title' => esc_html__('Text display before Mailchimp Form', 'mokar'),
                            'default' => esc_html__('Register now and be among the first to know more.', 'mokar')
                        ),                         
                        array(
                            'id' => 'under-mail',
                            'type' => 'switch',
                            'title' => esc_html__('Display subcribe form', 'mokar'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'mokar'),
                            'off' => esc_html__('No', 'mokar'),
                        ),
                    )
                ),
            );
            return $sections;
        }

        protected function mokar_add_header_section_options() {
            $header = array(
                'icon' => 'el-icon-edit',
                'icon_class' => 'icon',
                'title' => esc_html__('Header', 'mokar'),
                'fields' => array(
                    array(
                        'id' => 'header-type',
                        'type' => 'image_select',
                        'title' => esc_html__('Header Type', 'mokar'),
                        'subtitle' => esc_html__('Each page will have option for select header type. Header selection in each page will have higher priority than this general selection.','mokar'),
                        'options' => $this->mokar_header_types(),
                        'default' => '1'
                    ), 
                    array(
                        'id' => 'logo2',
                        'type' => 'media',
                        'url' => true,
                        'readonly' => false,
                        'title' => esc_html__('Logo', 'mokar'),
                        'required' => array(
                                    array('header-type', 'equals', array(
                                    '2'
                                )),
                            ),
                        'default' => array(
                            'url' => get_template_directory_uri() . '/images/logo2.png',
                            'height' => 40,
                            'wide' => 140
                        )
                    ),                            
                    array(
                        'id' => 'logo_header4',
                        'type' => 'media',
                        'url' => true,
                        'readonly' => false,
                        'title' => esc_html__('Logo for header 4', 'mokar'),
                        'required' => array(
                                    array('header-type', 'equals', array(
                                    '4'
                                )),
                            ),
                        'default' => array(
                            'url' => get_template_directory_uri() . '/images/logo.png',
                            'height' => 120,
                            'wide' => 120
                        )
                    ),                                     
                    array(
                        'id' => 'header-fixed',
                        'type' => 'switch',
                        'required' => array('header-type', 'equals', array(
                                '1'
                            )),  
                        'title' => esc_html__('Enable fixed header (Header displays over content)', 'mokar'),
                        'default' => true
                    ),                     
                    array(
                        'id' => 'header_search_style',
                        'type' => 'button_set',
                        'title' => esc_html__('Header search style', 'mokar'),
                        'options' => array(
                                "1" => esc_html__("Standard","mokar"),
                                "2" => esc_html__("Fullscreen","mokar"),
                            ),
                        'default' => '2',                         
                    ),                                         
                    array(
                        'id' => 'header_search_type',
                        'type' => 'button_set',
                        'title' => esc_html__('Header search type', 'mokar'),
                        'options' => array(
                                "1" => esc_html__("Product (if Woocommerce enable)","mokar"),
                                "2" => esc_html__("Blog","mokar"),
                            ),
                        'default' => '1',                         
                    ),
                    array(
                        'id' => 'header-account',
                        'type' => 'switch',
                        'title' => esc_html__('Show account link', 'mokar'),
                        'required' => array('header-type', 'equals', array(
                                '5','3'
                            )),                         
                        'default' => true
                    ),            
                    array(
                        'id' => 'header-minicart',
                        'type' => 'switch',
                        'title' => esc_html__('Show minicart', 'mokar'),
                        'required' => array('header-type', 'equals', array(
                                '1','5','2','3'
                            )),                         
                        'default' => true
                    ),  
					array(
                        'id' => 'header-minicart-hiden',
                        'type' => 'switch',
                        'title' => esc_html__('Show minicart', 'mokar'),
                        'required' => array('header-type', 'equals', array(
                                '4','6'
                            )),                         
                        'default' => false
                    ),   					
                    array(
                        'id' => 'header-search',
                        'type' => 'switch',
                        'title' => esc_html__('Show Search', 'mokar'),
                        'required' => array('header-type', 'equals', array(
                                '1','2','3','5','6'
                            )),                         
                        'default' => true
                    ),   
                    array(
                        'id' => 'header4-search',
                        'type' => 'switch',
                        'title' => esc_html__('Show Search', 'mokar'),
                        'required' => array('header-type', 'equals', array(
                                '4',
                            )),                         
                        'default' => false
                    ),                                                        
                    array(
                        'id' => 'header-sticky',
                        'type' => 'switch',
                        'title' => esc_html__('Enable sticky', 'mokar'),
                        'default' => true
                    ),   
                    array(
                        'id' => 'header-sticky-mobile',
                        'type' => 'switch',
                        'required' => array('header-sticky', 'equals', 1,),
                        'title' => esc_html__('Enable sticky on mobile ', 'mokar'),
                        'default' => true
                    ),                
                ),
            );

            return $header;
        }

        public function mokar_get_setting_arguments() {
            $theme = wp_get_theme();
            $args = array(
                // TYPICAL -> Change these values as you need/desire
                'opt_name' => 'mokar_settings',
                'display_name' => esc_html__('Mokar', 'mokar'),
                'display_version' => $theme->get('Version'),
                'menu_type' => 'menu',
                'allow_sub_menu' => true,
                'menu_title' => esc_html__('Mokar Options', 'mokar'),
                'page_title' => esc_html__('Mokar', 'mokar'),
                'google_api_key' => '',
                'google_update_weekly' => false,
                'async_typography' => true,
                'admin_bar' => true,
                'admin_bar_icon' => 'dashicons-admin-generic',
                'admin_bar_priority' => 50,
                'global_variable' => '',
                'dev_mode' => false,
                'update_notice' => true,
                'customizer' => true,
                'page_priority' => null,
                'page_parent' => 'themes.php',
                'page_permissions' => 'manage_options',
                'menu_icon' => '',
                'last_tab' => '',
                'page_icon' => 'icon-themes',
                'page_slug' => '',
                'save_defaults' => true,
                'default_show' => false,
                'default_mark' => '',
                'show_import_export' => true,
                'transient_time' => 60 * MINUTE_IN_SECONDS,
                'output' => true,
                'output_tag' => true,
                'database' => '',
                'use_cdn' => true,
                // HINTS
                'hints' => array(
                    'icon' => 'el el-question-sign',
                    'icon_position' => 'right',
                    'icon_color' => 'lightgray',
                    'icon_size' => 'normal',
                    'tip_style' => array(
                        'color' => 'red',
                        'shadow' => true,
                        'rounded' => false,
                        'style' => '',
                    ),
                    'tip_position' => array(
                        'my' => 'top left',
                        'at' => 'bottom right',
                    ),
                    'tip_effect' => array(
                        'show' => array(
                            'effect' => 'slide',
                            'duration' => '500',
                            'event' => 'mouseover',
                        ),
                        'hide' => array(
                            'effect' => 'slide',
                            'duration' => '500',
                            'event' => 'click mouseleave',
                        ),
                    ),
                )
            );
            return $args;
        }

        protected function mokar_header_types() {
            return array(
                '1' => array('alt' => esc_html__('Header Type 1', 'mokar'), 'img' => get_template_directory_uri() . '/inc/admin/settings/headers/header-1.jpg'),
                '2' => array('alt' => esc_html__('Header Type 2', 'mokar'), 'img' => get_template_directory_uri() . '/inc/admin/settings/headers/header-2.jpg'),
                '3' => array('alt' => esc_html__('Header Type 3', 'mokar'), 'img' => get_template_directory_uri() . '/inc/admin/settings/headers/header-3.jpg'),
                '4' => array('alt' => esc_html__('Header Type 4', 'mokar'), 'img' => get_template_directory_uri() . '/inc/admin/settings/headers/header-4.jpg'),
                '5' => array('alt' => esc_html__('Header Type 5', 'mokar'), 'img' => get_template_directory_uri() . '/inc/admin/settings/headers/header-5.jpg'),
                '6' => array('alt' => esc_html__('Header Type 6', 'mokar'), 'img' => get_template_directory_uri() . '/inc/admin/settings/headers/header-6.jpg'),                                            
            );
        }

        protected function mokar_footer_types() {
            return array(
                '1' => array('alt' => esc_html__('Footer Type 1', 'mokar'), 'img' => get_template_directory_uri() . '/inc/admin/settings/footers/footer-1.jpg'),
                '2' => array('alt' => esc_html__('Footer Type 2', 'mokar'), 'img' => get_template_directory_uri() . '/inc/admin/settings/footers/footer-2.jpg'),
                '3' => array('alt' => esc_html__('Footer Type 3', 'mokar'), 'img' => get_template_directory_uri() . '/inc/admin/settings/footers/footer-3.jpg'),
                '4' => array('alt' => esc_html__('Footer Type 4', 'mokar'), 'img' => get_template_directory_uri() . '/inc/admin/settings/footers/footer-4.jpg'),
                '5' => array('alt' => esc_html__('Footer Type 5', 'mokar'), 'img' => get_template_directory_uri() . '/inc/admin/settings/footers/footer-5.jpg'), 
                '6' => array('alt' => esc_html__('Footer Type 6', 'mokar'), 'img' => get_template_directory_uri() . '/inc/admin/settings/footers/footer-6.jpg'),           
            );
        }

    }

    
    function mokar_get_framework_settings() {
        global $mokarReduxSettings;
        $mokarReduxSettings = new Framework_Mokar_Settings();
        return $mokarReduxSettings;
    }
    mokar_get_framework_settings();
}