<?php

add_action('redux/options/mokar_settings/saved', 'mokar_save_theme_settings', 10, 2);
add_action('redux/options/mokar_settings/import', 'mokar_save_theme_settings', 10, 2);
add_action('redux/options/mokar_settings/reset', 'mokar_save_theme_settings');
add_action('redux/options/mokar_settings/section/reset', 'mokar_save_theme_settings');

function mokar_config_value($value) {
    return isset($value) ? $value : 0;
}

//complie scss
function mokar_save_theme_settings() {
    global $mokar_settings;
    update_option('mokar_init_theme', '1');
    global $mokarReduxSettings;

    $reduxFramework = $mokarReduxSettings->ReduxFramework;
    $template_dir = get_template_directory();

    // Compile SCSS Files
    if (!class_exists('scssc')) {
        require_once( MOKAR_ADMIN . '/sassphp/scss.inc.php' );
    }

    // config skin file
    ob_start();
    include MOKAR_ADMIN . '/sassphp/config_skin_scss.php';
    $_config_css = ob_get_clean();

    $filename = $template_dir . '/sass/config/_config_skin.scss';

    if (file_exists($filename)) {
        @unlink($filename);
    }
    $reduxFramework->filesystem->execute('put_contents', $filename, array('content' => $_config_css));

    // skin css
    ob_start();

    $scss = new scssc();
    $scss->setImportPaths($template_dir . '/sass');
    $scss->setFormatter('scss_formatter');
    echo $scss->compile('@import "skin.scss"');

    if (isset($mokar_settings['custom-css-code']))
        echo $mokar_settings['custom-css-code'];

    $_config_css = ob_get_clean();

    $filename = $template_dir . '/css/config/skin.css';

    if (file_exists($filename)) {
        @unlink($filename);
    }
    $reduxFramework->filesystem->execute('put_contents', $filename, array('content' => $_config_css));
}
