<?php
$mokar_settings = mokar_check_theme_options();
$mokar_header_class = '';
if( function_exists( 'ubermenu' ) ){
	$mokar_header_class = 'uber_enable';
}
?>

<div class="header-wrapper <?php echo esc_attr($mokar_header_class);?>">
	<div class="container ">
		<div class="row">
			<div class="col-md-5 col-sm-5 col-xs-12 text-left">
			<?php if(isset($mokar_settings['header-account'])  && $mokar_settings['header-account']):?>
				<div class="header-user hidden-xs">

					<?php
				        $mokar_myaccount_page_id = get_option('woocommerce_myaccount_page_id');
				        $mokar_logout_url = wp_logout_url(get_permalink($mokar_myaccount_page_id));
				        if (get_option('woocommerce_force_ssl_checkout') == 'yes') {
				            $mokar_logout_url = str_replace('http:', 'https:', $logout_url);
				        }
				    ?>
					    <ul>
					        <li><a href="<?php echo esc_url(get_permalink($mokar_myaccount_page_id)); ?>"><?php echo esc_html__('My Account', 'mokar') ?></a></li>
					        <?php if (!is_user_logged_in()): ?>
					            <li><a href="<?php echo esc_url(get_permalink($mokar_myaccount_page_id)); ?>"><?php echo esc_html__('Login / Register', 'mokar') ?></a></li>
					        <?php else: ?>
					            <li><a href="<?php echo esc_url($mokar_logout_url) ?>"><?php echo esc_html__('Logout', 'mokar') ?></a></li>
					        <?php endif; ?>
					    </ul>
				</div>
			<?php endif;?>
				<div class="left-header">
					<div class="nav-menu">
						<button class="btn-open-menu menu-toggle"><i class="fa fa-bars"></i></button>
						<nav id="site-navigation" class="main-navigation">
							<button class="btn-close-menu"> <i class="pe-7s-close" aria-hidden="true"></i></button>
							<?php
							$mokar_before_items_wrap = '';
							$mokar_after_item_wrap = '';
						if( function_exists( 'ubermenu' ) ){
						  ubermenu( 'main' , array( 
						  	'theme_location' => 'primary',
						  	
						  ) ); 
						}else{									
							if(has_nav_menu('primary')){                   
								wp_nav_menu(array(
									'theme_location' => 'primary',
									'menu_class' => 'mega-menu',
									'container_class' => 'h_vertical_menu',
									'items_wrap' => $mokar_before_items_wrap . '<ul id="%1$s" class="%2$s">%3$s</ul>' . $mokar_after_item_wrap,
									'walker' => new Mokar_Primary_Walker_Nav_Menu()
										)
								);
							}
						}
							?>               
						</nav>
					</div> 
					<?php 	                
			            if ($mokar_settings['header-search']) {
			                    $mokar_search_template = mokar_get_search_form();
			                    echo '<div class="search-block-top">' .wp_kses($mokar_search_template, mokar_allow_html()) . '</div>';
			                }  
			        ?>						
				</div>
			</div>
			<div class="col-md-2 col-sm-2 col-xs-12">
				<?php if (is_front_page()) : ?>
			        <h1 class="header-logo text-center">
			        <?php else : ?>
			            <h2 class="header-logo text-center ">
			            <?php endif; ?>
			            <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
			                <?php
			                if ($mokar_settings['logo'] && $mokar_settings['logo']['url']):
			                    echo '<img class="" src="' . esc_url(str_replace(array('http:', 'https:'), '', $mokar_settings['logo']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '" />';
			                else:
			                    bloginfo('name');
			                endif;
			                ?>
			            </a>
			            <?php if (is_front_page()) : ?>
			        </h1>
			    <?php else : ?>
			        </h2>
			    <?php endif; ?>
			</div>
			<div class="col-md-5 col-sm-5 col-xs-12">
				<?php 
				//mokar_show_language_dropdown();
				mokar_show_language_dropdown_demo()
				?>
				<?php	 
			    if (isset($mokar_settings['header-minicart']) && $mokar_settings['header-minicart'] && class_exists('WooCommerce')) :
			        $mokar_minicart_template = mokar_get_minicart_template();?>
			        <div id="mini-scart" class="mini-cart"> <?php echo wp_kses($mokar_minicart_template, mokar_allow_html()); ?> </div>
			    <?php endif; ?>
			    <?php if(isset($mokar_settings['header-account'])  && $mokar_settings['header-account']):?>
				<div class="header-user hidden-ms hidden-lg hidden-md"> 				
					<a href="#" class="toggle_filter"><i class="fa fa-user" aria-hidden="true"></i></a>
					<?php
				        $mokar_myaccount_page_id = get_option('woocommerce_myaccount_page_id');
				        $mokar_logout_url = wp_logout_url(get_permalink($mokar_myaccount_page_id));
				        if (get_option('woocommerce_force_ssl_checkout') == 'yes') {
				            $mokar_logout_url = str_replace('http:', 'https:', $logout_url);
				        }
				    ?>
				    <div class="content-filter">
					    <ul>
					        <li><a href="<?php echo esc_url(get_permalink($mokar_myaccount_page_id)); ?>"><?php echo esc_html__('My Account', 'mokar') ?></a></li>
					        <?php if (!is_user_logged_in()): ?>
					            <li><a href="<?php echo esc_url(get_permalink($mokar_myaccount_page_id)); ?>"><?php echo esc_html__('Login / Register', 'mokar') ?></a></li>
					        <?php else: ?>
					            <li><a href="<?php echo esc_url($mokar_logout_url) ?>"><?php echo esc_html__('Logout', 'mokar') ?></a></li>
					        <?php endif; ?>
					    </ul>
					</div>
				</div>	
				<?php endif;?>		    
			</div> 
		</div>
	</div>            
</div>
<!-- Menu -->
