<?php
$mokar_settings = mokar_check_theme_options();
$mokar_header_class = '';
if( function_exists( 'ubermenu' ) ){
	$mokar_header_class = 'uber_enable';
}
?>

<div class="header-wrapper <?php echo esc_attr($mokar_header_class);?>">
	<?php if(isset($mokar_settings['header-account'])  && $mokar_settings['header-account']):?>
		<div class="col-md-4 col-sm-5 col-xs-12 text-left header-user hidden-xs">
		<?php
            $mokar_myaccount_page_id = get_option('woocommerce_myaccount_page_id');
            $mokar_logout_url = wp_logout_url(get_permalink($mokar_myaccount_page_id));
            if (get_option('woocommerce_force_ssl_checkout') == 'yes') {
                $mokar_logout_url = str_replace('http:', 'https:', $logout_url);
            }
        ?>
        
        <ul>
            <li><a href="<?php echo esc_url(get_permalink($mokar_myaccount_page_id)); ?>"><?php echo esc_html__('My Account', 'mokar') ?></a></li>
            <?php if (!is_user_logged_in()): ?>
                <li><a href="<?php echo esc_url(get_permalink($mokar_myaccount_page_id)); ?>"><?php echo esc_html__('Login / Register', 'mokar') ?></a></li>
            <?php else: ?>
                <li><a href="<?php echo esc_url($mokar_logout_url) ?>"><?php echo esc_html__('Logout', 'mokar') ?></a></li>
            <?php endif; ?>
        </ul>
    	
	</div>
	<?php endif;?>
	<?php if(isset($mokar_settings['header-account'])  && $mokar_settings['header-account']):?>
		<div class="col-md-4 col-sm-3 col-xs-12">
	<?php else:?>
		<div class="col-md-8 col-sm-8 col-xs-12 text-left account-hidden">
	<?php endif;?>
		<?php if (is_front_page()) : ?>
            <h1 class="header-logo">
            <?php else : ?>
                <h2 class="header-logo">
                <?php endif; ?>
                <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
                    <?php
                    if ($mokar_settings['logo'] && $mokar_settings['logo']['url']):
                        echo '<img class="" src="' . esc_url(str_replace(array('http:', 'https:'), '', $mokar_settings['logo']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '" />';
                    else:
                        bloginfo('name');
                    endif;
                    ?>
                </a>
                <?php if (is_front_page()) : ?>
            </h1>
        <?php else : ?>
            </h2>
        <?php endif; ?>
	</div>
	<div class="col-md-4 col-sm-4 col-xs-12">
		<div class="right-header">
			<?php 	                
	            if ($mokar_settings['header-search']) {
	                    $mokar_search_template = mokar_get_search_form();
	                    echo '<div class="search-block-top">' .wp_kses($mokar_search_template, mokar_allow_html()) . '</div>';
	                }  
	            mokar_show_language_dropdown(); 
	        ?>
			<?php	 
				if (isset($mokar_settings['header-minicart']) && $mokar_settings['header-minicart'] && class_exists('WooCommerce')) :
				$mokar_minicart_template = mokar_get_minicart_template();?>
				<div id="mini-scart" class="mini-cart"> <?php echo wp_kses($mokar_minicart_template, mokar_allow_html()); ?> </div>
			<?php endif; ?>
			<?php if(isset($mokar_settings['header-account'])  && $mokar_settings['header-account']):?>
			<div class="header-user hidden-ms hidden-lg hidden-md hidden-768"> 				
				<a href="#" class="toggle_filter"><i class="fa fa-user" aria-hidden="true"></i></a>
				<?php
			        $mokar_myaccount_page_id = get_option('woocommerce_myaccount_page_id');
			        $mokar_logout_url = wp_logout_url(get_permalink($mokar_myaccount_page_id));
			        if (get_option('woocommerce_force_ssl_checkout') == 'yes') {
			            $mokar_logout_url = str_replace('http:', 'https:', $logout_url);
			        }
			    ?>
			    <div class="content-filter">
				    <ul>
				        <li><a href="<?php echo esc_url(get_permalink($mokar_myaccount_page_id)); ?>"><?php echo esc_html__('My Account', 'mokar') ?></a></li>
				        <?php if (!is_user_logged_in()): ?>
				            <li><a href="<?php echo esc_url(get_permalink($mokar_myaccount_page_id)); ?>"><?php echo esc_html__('Login / Register', 'mokar') ?></a></li>
				        <?php else: ?>
				            <li><a href="<?php echo esc_url($mokar_logout_url) ?>"><?php echo esc_html__('Logout', 'mokar') ?></a></li>
				        <?php endif; ?>
				    </ul>
				</div>
			</div>	 
			<?php endif; ?>
			<div class="nav-menu">
				<button class="btn-open-menu menu-toggle"><i class="icon-menu"></i></button>
				<nav id="site-navigation" class="main-navigation">
					<button class="btn-close-menu"> <i class="pe-7s-close" aria-hidden="true"></i></button>
					<?php
					$mokar_before_items_wrap = '';
					$mokar_after_item_wrap = '';
				if( function_exists( 'ubermenu' ) ){
				  ubermenu( 'main' , array( 
				  	'theme_location' => 'primary',
				  	
				  ) ); 
				}else{									
					if(has_nav_menu('primary')){                   
						wp_nav_menu(array(
							'theme_location' => 'primary',
							'menu_class' => 'mega-menu',
							'container_class' => 'h_vertical_menu',
							'items_wrap' => $mokar_before_items_wrap . '<ul id="%1$s" class="%2$s">%3$s</ul>' . $mokar_after_item_wrap,
							'walker' => new Mokar_Primary_Walker_Nav_Menu()
								)
						);
					}
				}
					?>               
				</nav>
			</div> 
		</div>
	</div>             
</div>
<!-- Menu -->
