<?php
$mokar_settings = mokar_check_theme_options();
$mokar_header_class = '';
if( function_exists( 'ubermenu' ) ){
	$mokar_header_class = 'uber_enable';
}
?>

<div class="header-wrapper <?php echo esc_attr($mokar_header_class);?>">
        <?php if (is_front_page()) : ?>
            <h1 class="header-logo">
            <?php else : ?>
                <h2 class="header-logo">
                <?php endif; ?>
                <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
                    <?php
                    if ($mokar_settings['logo'] && $mokar_settings['logo']['url']):
                        echo '<img class="" width="140" height="40" src="' . esc_url(str_replace(array('http:', 'https:'), '', $mokar_settings['logo']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '" />';
                    else:
                        bloginfo('name');
                    endif;
                    ?>
                </a>
                <?php if (is_front_page()) : ?>
            </h1>
        <?php else : ?>
            </h2>
        <?php endif; ?>
       
        <div class="header-right">
	        	<div class="header_icon display-inline-b">	                 
		            <?php 	                
		            if ($mokar_settings['header-search']) {
		                    $mokar_search_template = mokar_get_search_form();
		                    echo '<div class="search-block-top">' .wp_kses($mokar_search_template, mokar_allow_html()) . '</div>';
		                }  
		            mokar_show_language_dropdown(); 
			        ?>  
		        </div>	
				<?php	 
					if (isset($mokar_settings['header-minicart']) && $mokar_settings['header-minicart'] && class_exists('WooCommerce')) :
			        $mokar_minicart_template = mokar_get_minicart_template();?>
			        <div id="mini-scart" class="mini-cart"> <?php echo wp_kses($mokar_minicart_template, mokar_allow_html()); ?> </div>
			    <?php endif; ?>
		        <div class="header_icon display-inline-b header-myaccount">
		        	<i class="icon-menu"></i>
		        	<div class="dib header-profile">
		        	<?php
		                $mokar_myaccount_page_id = get_option('woocommerce_myaccount_page_id');
		                $mokar_logout_url = wp_logout_url(get_permalink($mokar_myaccount_page_id));
		                if (get_option('woocommerce_force_ssl_checkout') == 'yes') {
		                    $mokar_logout_url = str_replace('http:', 'https:', $logout_url);
		                }
		            ?>
                        <ul>
                            <li><a href="<?php echo esc_url(get_permalink($mokar_myaccount_page_id)); ?>"><?php echo esc_html__('My Account', 'mokar') ?></a></li>
                            <?php if (!is_user_logged_in()): ?>
                                <li><a href="<?php echo esc_url(get_permalink($mokar_myaccount_page_id)); ?>"><?php echo esc_html__('Login / Register', 'mokar') ?></a></li>
                            <?php else: ?>
                                <li><a href="<?php echo esc_url($mokar_logout_url) ?>"><?php echo esc_html__('Logout', 'mokar') ?></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
		        </div>	        		        	    	        		        	
	        </div>    
	      <div class="header-center">
	        <nav id="site-navigation" class="main-navigation">
	        	<button class="btn-open btn-menu-open"><i class="icon-menu"></i></button>
	        		<div class="nav-sections">

						<ul class="section-nav-title hidden-md hidden-lg hidden-sm">
						  <li ><a class="tablinks menutab" href="javascript:void(0)" id="defaultOpen"><?php echo esc_html('Menu','mokar');?></a></li>
						  <li ><a class="tablinks accounttab" href="javascript:void(0)"><?php echo esc_html('Account','mokar');?></a></li>						  
						</ul>
						<div id="menu" class="tabcontent">
			                <?php
			                $before_items_wrap = '';
			                $after_item_wrap = '';
							if( function_exists( 'ubermenu' ) ){
							  ubermenu( 'main' , array( 'theme_location' => 'primary' ) ); 
							}else{
				                if (has_nav_menu('primary')) {
				                    wp_nav_menu(array(
				                        'theme_location' => 'primary',
				                        'menu_class' => 'mega-menu',
				                        'items_wrap' => $before_items_wrap . '<ul id="%1$s" class="%2$s">%3$s</ul>' . $after_item_wrap,
				                        'walker' => new Mokar_Primary_Walker_Nav_Menu()
				                            )
				                    );
				                }
				            }
			                ?> 
			            </div>
			            <div id="account" class="tabcontent hidden-md hidden-sm hidden-lg">
			            <?php 
							if ( class_exists( 'WooCommerce' )) {
								$myaccount_page_id = get_option('woocommerce_myaccount_page_id');
							}else{
								$myaccount_page_id = wp_login_url();
							}
							$logout_url = wp_logout_url(get_permalink($myaccount_page_id));
							if (get_option('woocommerce_force_ssl_checkout') == 'yes') {
								$logout_url = str_replace('http:', 'https:', $logout_url);
							}
			            ?>
							<ul class="mega-menu">
								<?php if (!is_user_logged_in()): ?>
									<li class="dib customlinks"><a href="<?php echo esc_url(get_permalink($myaccount_page_id)); ?>"><?php echo esc_html__('Member Login', 'mokar') ?></a></li>
								<?php else: ?>
									<li class="dib customlinks"><a href="<?php echo esc_url($logout_url) ?>"><?php echo esc_html__('Logout', 'mokar') ?></a></li>
									<li><a href="<?php echo esc_url(get_permalink($myaccount_page_id)); ?>"><?php echo esc_html__('My Account', 'mokar') ?></a></li>											

								<?php endif; ?>									
								
							</ul>
			            </div>
	                </div>
  
		            
	        </nav>  
	        	
        </div>    
</div>
<!-- Menu -->
