<?php

$output = $title = $image = $btn_text = $btn_layout = $items_desktop_large = $items_desktop = $items_tablets = $items_mobile = $el_class = '';
extract( shortcode_atts( array(
    'title' => '',
    'image' => '',
    'product_name' => '',
	'btn_layout' => 'btn_layout_1',
    'btn_text' => __('Add to cart', 'arrowpress'),
    'link' => '#',
	'items_desktop_large' => 1,
    'items_desktop' => 1,
    'items_tablets' => 1,
    'items_mobile' => 1,
    'el_class' => ''
), $atts ) );
$href = vc_build_link($link);
$bgImage = wp_get_attachment_url($image);
$el_class = arrowpress_shortcode_extract_class( $el_class );

$output = '<div class="product_attribute arrowpress-products ' . $el_class . '"';
$output .= '>';

ob_start();
?>
	<div class="product-attribute">
		<div class="title-deal">
			<?php if($title != '') :?>
				<h3><?php echo esc_html($title); ?></h3>
			<?php endif; ?>		
		</div>
		<div class="product-deal">
			<div class="product-img">
				<?php if($bgImage):?>
					<img src="<?php echo esc_url($bgImage);?>" alt="img">
				<?php endif;?>	
			</div>
			<div class="deal-of">
				<?php if($product_name != '') :?>
					<h3><a href="<?php echo esc_url($href['url']); ?>"><?php echo esc_html($product_name); ?></a></h3>
				<?php endif; ?>		
				<div class="product-desc ">
					<?php 
						echo wpb_js_remove_wpautop(do_shortcode($content), true);
					?>		
				</div>
				<?php if($btn_text == '') :?>
					<?php else: ?>
					<div class="btn-banner woocommerce-page">
						<a href="<?php echo esc_url($href['url']); ?>" class="btn  
						   <?php if($btn_layout == 'btn_layout_1'){echo 'btn-default';} 
							if($btn_layout == 'btn_layout_2'){echo 'btn-primary';} ?>">
							<i class="pe-7s-cart"></i> <?php echo esc_html($btn_text); ?>
						</a>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
	
<?php
$output .= ob_get_clean();
$output .= '</div>' . arrowpress_shortcode_end_block_comment('arrowpress_product_attribute') . "\n";
echo $output;
wp_reset_postdata();