<?php

$output = $title = $orderby = $order = $items_desktop_large = $items_desktop = $items_tablets = $items_mobile = $el_class = '';
$per_page = 12;
$columns = 4;
extract( shortcode_atts( array(
    'layout' => '',
    'shortcodes_layout' => '',
    'slug_name' => '',
    'slogan' => '',
    'per_page' => 12,
    'columns' => 4,
    'orderby' => 'date',
    'order' => 'desc',
    'view_more' => 'yes',
	'items_desktop_large' => 3,
    'items_desktop' => 3,
    'items_tablets' => 2,
    'items_mobile' => 1,
    'el_class' => ''
), $atts ) );

$shortcodes = '';
if($shortcodes_layout == 'recent_products'){
	$shortcodes = 'recent_products';
}elseif($shortcodes_layout == 'featured_products'){
	$shortcodes = 'featured_products';
}elseif($shortcodes_layout == 'best_selling_products'){
	$shortcodes = 'best_selling_products';
}elseif($shortcodes_layout == 'top_rated_products'){
	$shortcodes = 'top_rated_products';
}else{
	$shortcodes = 'sale_products';
}
if($layout == 'slide'){
	$slide_class = 'product_slide';
}else{
	$slide_class = '';
}

$el_class = arrowpress_shortcode_extract_class( $el_class );

$terms = get_terms( 'product_cat', array(
	'hierarchical'  => false,
	'hide_empty'        => true,
	'order' => 'random'
) );
$output = '<div class="product-grid arrowpress-products wpb_content_element ' . $slide_class . $el_class . '"';
$output .= '>';

global $woocommerce_loop;

$woocommerce_loop['columns'] = $columns;
ob_start();
?>
	<div class="width-default">
		<div class="row">
			<div class="col-md-7 col-sm-12 col-xs-12">
				<?php if($slogan !==''): ?>
					<div class="slogan">
						<p><?php echo $slogan; ?></p>
					</div>
				<?php endif; ?>
			</div>
			<div class="col-md-5 col-sm-12 col-xs-12">
				<?php if($layout == 'filter') : ?>
					<div id="options" class="gallery_filter filter-cate">
						<div id="filters" class="button-group js-radio-button-group">
							<div class="inline-block">
								<button class="is-checked btn-filter" data-filter="*"><?php echo esc_html(substr('All', 0, 1)).'.';?></button> 
								<div class="text_filter"><?php echo esc_html__('All','arrowpress-shortcodes'); ?></div>
							</div>
							<?php foreach ( $terms as $key => $term ) : ?> 
								<div class="inline-block">
									<button class="btn-filter" data-filter=".<?php echo esc_attr($term->slug); ?>"><?php echo esc_html(substr($term->name, 0, 1)).'.'; ?></button>
									<div class="text_filter"><?php echo esc_html($term->name); ?></div>
								</div>
							<?php endforeach;?>  
						</div>
					</div> 
				<?php endif; ?>
			</div>
		</div>
	</div>
<?php
	echo do_shortcode('['.$shortcodes.' category="'.$slug_name.'" per_page="'.$per_page.'" columns="'.$columns.'" orderby="'.$orderby.'" order="'.$order.'"]');
?>
	<div class="btn-viewmore text-center animate-top">
		<a class="view_more btn btn-primary" href="<?php echo get_post_type_archive_link('product'); ?>"><?php echo esc_html__('View more', 'arrowpress-shortcodes');?></a>
	</div>
	
	<?php if($layout == 'slide') : ?>
		<script type="text/javascript">
			jQuery(function ($) {
				$(document).ready(function(){
				  $('.<?php echo esc_js($slide_class); ?> .product-entries-wrap').slick({
					slidesToScroll: 1,	
					infinite: true,
					slidesToShow: <?php echo esc_js($items_desktop_large);?>,
					dots:false,
					arrows:true,
					responsive: [
						{
						  breakpoint: 1200,
						  settings: {
							slidesToShow: <?php echo esc_js($items_desktop);?>,
						  }
						},
						{
						  breakpoint: 992,
						  settings: {
							slidesToShow: <?php echo esc_js($items_tablets);?>,
						  }
						},
						{
						  breakpoint: 480,
						  settings: {
							slidesToShow: <?php echo esc_js($items_mobile);?>,
						  }
						}
					]
				  });
				});
			});
		</script>
	<?php endif; ?>
<?php
$output .= ob_get_clean();
$output .= '</div>' . arrowpress_shortcode_end_block_comment('arrowpress_product') . "\n";
echo $output;
wp_reset_postdata();